package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UsingNotYetGenerateGenerics}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUsingNotYetGenerateGenerics.builder()}.
 */
@Generated(from = "UsingNotYetGenerateGenerics", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUsingNotYetGenerateGenerics<T>
    implements UsingNotYetGenerateGenerics<T> {
  private final ImmutableGenericsAsItIs<String> notYetGenerated;
  private final ImmutableB<T> andThisToo;
  private final ImmutableList<ImmutableGenericsAsItIs<String>> notYetInCollection;

  private ImmutableUsingNotYetGenerateGenerics(
      ImmutableGenericsAsItIs<String> notYetGenerated,
      ImmutableB<T> andThisToo,
      ImmutableList<ImmutableGenericsAsItIs<String>> notYetInCollection) {
    this.notYetGenerated = notYetGenerated;
    this.andThisToo = andThisToo;
    this.notYetInCollection = notYetInCollection;
  }

  /**
   * @return The value of the {@code notYetGenerated} attribute
   */
  @Override
  public ImmutableGenericsAsItIs<String> notYetGenerated() {
    return notYetGenerated;
  }

  /**
   * @return The value of the {@code andThisToo} attribute
   */
  @Override
  public ImmutableB<T> andThisToo() {
    return andThisToo;
  }

  /**
   * @return The value of the {@code notYetInCollection} attribute
   */
  @Override
  public ImmutableList<ImmutableGenericsAsItIs<String>> notYetInCollection() {
    return notYetInCollection;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UsingNotYetGenerateGenerics#notYetGenerated() notYetGenerated} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for notYetGenerated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUsingNotYetGenerateGenerics<T> withNotYetGenerated(ImmutableGenericsAsItIs<String> value) {
    if (this.notYetGenerated == value) return this;
    ImmutableGenericsAsItIs<String> newValue = Objects.requireNonNull(value, "notYetGenerated");
    return new ImmutableUsingNotYetGenerateGenerics<>(newValue, this.andThisToo, this.notYetInCollection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UsingNotYetGenerateGenerics#andThisToo() andThisToo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for andThisToo
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUsingNotYetGenerateGenerics<T> withAndThisToo(ImmutableB<T> value) {
    if (this.andThisToo == value) return this;
    ImmutableB<T> newValue = Objects.requireNonNull(value, "andThisToo");
    return new ImmutableUsingNotYetGenerateGenerics<>(this.notYetGenerated, newValue, this.notYetInCollection);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsingNotYetGenerateGenerics#notYetInCollection() notYetInCollection}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableUsingNotYetGenerateGenerics<T> withNotYetInCollection(ImmutableGenericsAsItIs<String>... elements) {
    ImmutableList<ImmutableGenericsAsItIs<String>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUsingNotYetGenerateGenerics<>(this.notYetGenerated, this.andThisToo, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsingNotYetGenerateGenerics#notYetInCollection() notYetInCollection}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of notYetInCollection elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingNotYetGenerateGenerics<T> withNotYetInCollection(Iterable<? extends ImmutableGenericsAsItIs<String>> elements) {
    if (this.notYetInCollection == elements) return this;
    ImmutableList<ImmutableGenericsAsItIs<String>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUsingNotYetGenerateGenerics<>(this.notYetGenerated, this.andThisToo, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUsingNotYetGenerateGenerics} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUsingNotYetGenerateGenerics<?>
        && equalTo(0, (ImmutableUsingNotYetGenerateGenerics<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableUsingNotYetGenerateGenerics<?> another) {
    return notYetGenerated.equals(another.notYetGenerated)
        && andThisToo.equals(another.andThisToo)
        && notYetInCollection.equals(another.notYetInCollection);
  }

  /**
   * Computes a hash code from attributes: {@code notYetGenerated}, {@code andThisToo}, {@code notYetInCollection}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + notYetGenerated.hashCode();
    h += (h << 5) + andThisToo.hashCode();
    h += (h << 5) + notYetInCollection.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UsingNotYetGenerateGenerics} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UsingNotYetGenerateGenerics")
        .omitNullValues()
        .add("notYetGenerated", notYetGenerated)
        .add("andThisToo", andThisToo)
        .add("notYetInCollection", notYetInCollection)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link UsingNotYetGenerateGenerics} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable UsingNotYetGenerateGenerics instance
   */
  public static <T> ImmutableUsingNotYetGenerateGenerics<T> copyOf(UsingNotYetGenerateGenerics<T> instance) {
    if (instance instanceof ImmutableUsingNotYetGenerateGenerics<?>) {
      return (ImmutableUsingNotYetGenerateGenerics<T>) instance;
    }
    return ImmutableUsingNotYetGenerateGenerics.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUsingNotYetGenerateGenerics ImmutableUsingNotYetGenerateGenerics}.
   * <pre>
   * ImmutableUsingNotYetGenerateGenerics.&amp;lt;T&amp;gt;builder()
   *    .notYetGenerated(ImmutableGenericsAsItIs&amp;lt;String&amp;gt;) // required {@link UsingNotYetGenerateGenerics#notYetGenerated() notYetGenerated}
   *    .andThisToo(ImmutableB&amp;lt;T&amp;gt;) // required {@link UsingNotYetGenerateGenerics#andThisToo() andThisToo}
   *    .addNotYetInCollection|addAllNotYetInCollection(ImmutableGenericsAsItIs&amp;lt;String&amp;gt;) // {@link UsingNotYetGenerateGenerics#notYetInCollection() notYetInCollection} elements
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableUsingNotYetGenerateGenerics builder
   */
  public static <T> ImmutableUsingNotYetGenerateGenerics.Builder<T> builder() {
    return new ImmutableUsingNotYetGenerateGenerics.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableUsingNotYetGenerateGenerics ImmutableUsingNotYetGenerateGenerics}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UsingNotYetGenerateGenerics", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_NOT_YET_GENERATED = 0x1L;
    private static final long INIT_BIT_AND_THIS_TOO = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ImmutableGenericsAsItIs<String> notYetGenerated;
    private @Nullable ImmutableB<T> andThisToo;
    private ImmutableList.Builder<ImmutableGenericsAsItIs<String>> notYetInCollection = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UsingNotYetGenerateGenerics} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(UsingNotYetGenerateGenerics<T> instance) {
      Objects.requireNonNull(instance, "instance");
      notYetGenerated(instance.notYetGenerated());
      andThisToo(instance.andThisToo());
      addAllNotYetInCollection(instance.notYetInCollection());
      return this;
    }

    /**
     * Initializes the value for the {@link UsingNotYetGenerateGenerics#notYetGenerated() notYetGenerated} attribute.
     * @param notYetGenerated The value for notYetGenerated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> notYetGenerated(ImmutableGenericsAsItIs<String> notYetGenerated) {
      this.notYetGenerated = Objects.requireNonNull(notYetGenerated, "notYetGenerated");
      initBits &= ~INIT_BIT_NOT_YET_GENERATED;
      return this;
    }

    /**
     * Initializes the value for the {@link UsingNotYetGenerateGenerics#andThisToo() andThisToo} attribute.
     * @param andThisToo The value for andThisToo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> andThisToo(ImmutableB<T> andThisToo) {
      this.andThisToo = Objects.requireNonNull(andThisToo, "andThisToo");
      initBits &= ~INIT_BIT_AND_THIS_TOO;
      return this;
    }

    /**
     * Adds one element to {@link UsingNotYetGenerateGenerics#notYetInCollection() notYetInCollection} list.
     * @param element A notYetInCollection element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addNotYetInCollection(ImmutableGenericsAsItIs<String> element) {
      this.notYetInCollection.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UsingNotYetGenerateGenerics#notYetInCollection() notYetInCollection} list.
     * @param elements An array of notYetInCollection elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<T> addNotYetInCollection(ImmutableGenericsAsItIs<String>... elements) {
      this.notYetInCollection.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UsingNotYetGenerateGenerics#notYetInCollection() notYetInCollection} list.
     * @param elements An iterable of notYetInCollection elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> notYetInCollection(Iterable<? extends ImmutableGenericsAsItIs<String>> elements) {
      this.notYetInCollection = ImmutableList.builder();
      return addAllNotYetInCollection(elements);
    }

    /**
     * Adds elements to {@link UsingNotYetGenerateGenerics#notYetInCollection() notYetInCollection} list.
     * @param elements An iterable of notYetInCollection elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addAllNotYetInCollection(Iterable<? extends ImmutableGenericsAsItIs<String>> elements) {
      this.notYetInCollection.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableUsingNotYetGenerateGenerics ImmutableUsingNotYetGenerateGenerics}.
     * @return An immutable instance of UsingNotYetGenerateGenerics
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUsingNotYetGenerateGenerics<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUsingNotYetGenerateGenerics<>(notYetGenerated, andThisToo, notYetInCollection.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NOT_YET_GENERATED) != 0) attributes.add("notYetGenerated");
      if ((initBits & INIT_BIT_AND_THIS_TOO) != 0) attributes.add("andThisToo");
      return "Cannot build UsingNotYetGenerateGenerics, some of required attributes are not set " + attributes;
    }
  }
}
