package org.immutables.fixture.generics;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RecursiveGenerics}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRecursiveGenerics.builder()}.
 */
@Generated(from = "RecursiveGenerics", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRecursiveGenerics<T extends RecursiveGenerics<T>>
    implements RecursiveGenerics<T> {

  private ImmutableRecursiveGenerics(ImmutableRecursiveGenerics.Builder<T> builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRecursiveGenerics} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRecursiveGenerics<?>
        && equalTo(0, (ImmutableRecursiveGenerics<?>) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableRecursiveGenerics<?> another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -372418253;
  }

  /**
   * Prints the immutable value {@code RecursiveGenerics}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RecursiveGenerics{}";
  }

  /**
   * Creates an immutable copy of a {@link RecursiveGenerics} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable RecursiveGenerics instance
   */
  public static <T extends RecursiveGenerics<T>> ImmutableRecursiveGenerics<T> copyOf(RecursiveGenerics<T> instance) {
    if (instance instanceof ImmutableRecursiveGenerics<?>) {
      return (ImmutableRecursiveGenerics<T>) instance;
    }
    return ImmutableRecursiveGenerics.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRecursiveGenerics ImmutableRecursiveGenerics}.
   * <pre>
   * ImmutableRecursiveGenerics.&amp;lt;T&amp;gt;builder()
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableRecursiveGenerics builder
   */
  public static <T extends RecursiveGenerics<T>> ImmutableRecursiveGenerics.Builder<T> builder() {
    return new ImmutableRecursiveGenerics.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableRecursiveGenerics ImmutableRecursiveGenerics}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RecursiveGenerics", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T extends RecursiveGenerics<T>> {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RecursiveGenerics} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(RecursiveGenerics<T> instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableRecursiveGenerics ImmutableRecursiveGenerics}.
     * @return An immutable instance of RecursiveGenerics
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRecursiveGenerics<T> build() {
      return new ImmutableRecursiveGenerics<T>(this);
    }
  }
}
