package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MultipleGenericsInExtendingBuilder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new MultipleGenericsInExtendingBuilder.Builder()}.
 */
@Generated(from = "MultipleGenericsInExtendingBuilder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMultipleGenericsInExtendingBuilder<T, K, V>
    extends MultipleGenericsInExtendingBuilder<T, K, V> {
  private final T value;

  private ImmutableMultipleGenericsInExtendingBuilder(T value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public T getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MultipleGenericsInExtendingBuilder#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMultipleGenericsInExtendingBuilder<T, K, V> withValue(T value) {
    if (this.value == value) return this;
    T newValue = Objects.requireNonNull(value, "value");
    return new ImmutableMultipleGenericsInExtendingBuilder<>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMultipleGenericsInExtendingBuilder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMultipleGenericsInExtendingBuilder<?, ?, ?>
        && equalTo(0, (ImmutableMultipleGenericsInExtendingBuilder<?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableMultipleGenericsInExtendingBuilder<?, ?, ?> another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MultipleGenericsInExtendingBuilder} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MultipleGenericsInExtendingBuilder")
        .omitNullValues()
        .add("value", value)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link MultipleGenericsInExtendingBuilder} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param <K> generic parameter K
   * @param <V> generic parameter V
   * @param instance The instance to copy
   * @return A copied immutable MultipleGenericsInExtendingBuilder instance
   */
  public static <T, K, V> ImmutableMultipleGenericsInExtendingBuilder<T, K, V> copyOf(MultipleGenericsInExtendingBuilder<T, K, V> instance) {
    if (instance instanceof ImmutableMultipleGenericsInExtendingBuilder<?, ?, ?>) {
      return (ImmutableMultipleGenericsInExtendingBuilder<T, K, V>) instance;
    }
    return new MultipleGenericsInExtendingBuilder.Builder<T, K, V>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableMultipleGenericsInExtendingBuilder ImmutableMultipleGenericsInExtendingBuilder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MultipleGenericsInExtendingBuilder", generator = "Immutables")
  @NotThreadSafe
  public static class Builder<T, K, V> {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable T value;

    /**
     * Creates a builder for {@link ImmutableMultipleGenericsInExtendingBuilder ImmutableMultipleGenericsInExtendingBuilder} instances.
     * <pre>
     * new MultipleGenericsInExtendingBuilder.Builder&amp;lt;T, K, V&amp;gt;()
     *    .value(T) // required {@link MultipleGenericsInExtendingBuilder#getValue() value}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof MultipleGenericsInExtendingBuilder.Builder<?, ?, ?>)) {
        throw new UnsupportedOperationException("Use: new MultipleGenericsInExtendingBuilder.Builder<T, K, V>()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code MultipleGenericsInExtendingBuilder} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final MultipleGenericsInExtendingBuilder.Builder<T, K, V> from(MultipleGenericsInExtendingBuilder<T, K, V> instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.getValue());
      return (MultipleGenericsInExtendingBuilder.Builder<T, K, V>) this;
    }

    /**
     * Initializes the value for the {@link MultipleGenericsInExtendingBuilder#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final MultipleGenericsInExtendingBuilder.Builder<T, K, V> value(T value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return (MultipleGenericsInExtendingBuilder.Builder<T, K, V>) this;
    }

    /**
     * Builds a new {@link ImmutableMultipleGenericsInExtendingBuilder ImmutableMultipleGenericsInExtendingBuilder}.
     * @return An immutable instance of MultipleGenericsInExtendingBuilder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMultipleGenericsInExtendingBuilder<T, K, V> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMultipleGenericsInExtendingBuilder<>(value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build MultipleGenericsInExtendingBuilder, some of required attributes are not set " + attributes;
    }
  }
}
