package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GenericCore.GenericChild}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGenericChild.builder()}.
 */
@Generated(from = "GenericCore.GenericChild", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGenericChild<T extends CharSequence>
    implements GenericCore.GenericChild<T> {
  private final T object;

  private ImmutableGenericChild(T object) {
    this.object = object;
  }

  /**
   * @return The value of the {@code object} attribute
   */
  @Override
  public T getObject() {
    return object;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericCore.GenericChild#getObject() object} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for object
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGenericChild<T> withObject(T value) {
    if (this.object == value) return this;
    T newValue = Objects.requireNonNull(value, "object");
    return new ImmutableGenericChild<>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGenericChild} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGenericChild<?>
        && equalTo(0, (ImmutableGenericChild<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableGenericChild<?> another) {
    return object.equals(another.object);
  }

  /**
   * Computes a hash code from attributes: {@code object}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + object.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GenericChild} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GenericChild")
        .omitNullValues()
        .add("object", object)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GenericCore.GenericChild} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable GenericChild instance
   */
  public static <T extends CharSequence> ImmutableGenericChild<T> copyOf(GenericCore.GenericChild<T> instance) {
    if (instance instanceof ImmutableGenericChild<?>) {
      return (ImmutableGenericChild<T>) instance;
    }
    return ImmutableGenericChild.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGenericChild ImmutableGenericChild}.
   * <pre>
   * ImmutableGenericChild.&amp;lt;T&amp;gt;builder()
   *    .object(T) // required {@link GenericCore.GenericChild#getObject() object}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableGenericChild builder
   */
  public static <T extends CharSequence> ImmutableGenericChild.Builder<T> builder() {
    return new ImmutableGenericChild.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableGenericChild ImmutableGenericChild}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GenericCore.GenericChild", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T extends CharSequence> {
    private static final long INIT_BIT_OBJECT = 0x1L;
    private long initBits = 0x1L;

    private @Nullable T object;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.generics.GenericCore.Core} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(GenericCore.Core<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.generics.GenericCore.GenericChild} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(GenericCore.GenericChild<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof GenericCore.Core<?>) {
        GenericCore.Core<T> instance = (GenericCore.Core<T>) object;
        if ((bits & 0x1L) == 0) {
          object(instance.getObject());
          bits |= 0x1L;
        }
      }
      if (object instanceof GenericCore.GenericChild<?>) {
        GenericCore.GenericChild<T> instance = (GenericCore.GenericChild<T>) object;
        if ((bits & 0x1L) == 0) {
          object(instance.getObject());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link GenericCore.GenericChild#getObject() object} attribute.
     * @param object The value for object 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> object(T object) {
      this.object = Objects.requireNonNull(object, "object");
      initBits &= ~INIT_BIT_OBJECT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGenericChild ImmutableGenericChild}.
     * @return An immutable instance of GenericChild
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGenericChild<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGenericChild<>(object);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OBJECT) != 0) attributes.add("object");
      return "Cannot build GenericChild, some of required attributes are not set " + attributes;
    }
  }
}
