package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.generics.alpha.ImmutableSpecificType;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ChildWithGeneric}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableChildWithGeneric.builder()}.
 */
@Generated(from = "ChildWithGeneric", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableChildWithGeneric extends ChildWithGeneric {
  private final ImmutableSpecificType item;

  private ImmutableChildWithGeneric(ImmutableSpecificType item) {
    this.item = item;
  }

  /**
   * @return The value of the {@code item} attribute
   */
  @Override
  public ImmutableSpecificType getItem() {
    return item;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChildWithGeneric#getItem() item} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for item
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableChildWithGeneric withItem(ImmutableSpecificType value) {
    if (this.item == value) return this;
    ImmutableSpecificType newValue = Objects.requireNonNull(value, "item");
    return new ImmutableChildWithGeneric(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableChildWithGeneric} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableChildWithGeneric
        && equalTo(0, (ImmutableChildWithGeneric) another);
  }

  private boolean equalTo(int synthetic, ImmutableChildWithGeneric another) {
    return item.equals(another.item);
  }

  /**
   * Computes a hash code from attributes: {@code item}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + item.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChildWithGeneric} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ChildWithGeneric")
        .omitNullValues()
        .add("item", item)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ChildWithGeneric} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChildWithGeneric instance
   */
  public static ImmutableChildWithGeneric copyOf(ChildWithGeneric instance) {
    if (instance instanceof ImmutableChildWithGeneric) {
      return (ImmutableChildWithGeneric) instance;
    }
    return ImmutableChildWithGeneric.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableChildWithGeneric ImmutableChildWithGeneric}.
   * <pre>
   * ImmutableChildWithGeneric.builder()
   *    .item(org.immutables.fixture.generics.alpha.ImmutableSpecificType) // required {@link ChildWithGeneric#getItem() item}
   *    .build();
   * </pre>
   * @return A new ImmutableChildWithGeneric builder
   */
  public static ImmutableChildWithGeneric.Builder builder() {
    return new ImmutableChildWithGeneric.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableChildWithGeneric ImmutableChildWithGeneric}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ChildWithGeneric", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ITEM = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ImmutableSpecificType item;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChildWithGeneric} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ChildWithGeneric instance) {
      Objects.requireNonNull(instance, "instance");
      item(instance.getItem());
      return this;
    }

    /**
     * Initializes the value for the {@link ChildWithGeneric#getItem() item} attribute.
     * @param item The value for item 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder item(ImmutableSpecificType item) {
      this.item = Objects.requireNonNull(item, "item");
      initBits &= ~INIT_BIT_ITEM;
      return this;
    }

    /**
     * Builds a new {@link ImmutableChildWithGeneric ImmutableChildWithGeneric}.
     * @return An immutable instance of ChildWithGeneric
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableChildWithGeneric build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableChildWithGeneric(item);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ITEM) != 0) attributes.add("item");
      return "Cannot build ChildWithGeneric, some of required attributes are not set " + attributes;
    }
  }
}
