package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GenericSubType.B}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableB.builder()}.
 */
@Generated(from = "GenericSubType.B", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableB<T> implements GenericSubType.B<T> {
  private final int a;
  private final T b;

  private ImmutableB(int a, T b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public T b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericSubType.B#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableB<T> withA(int value) {
    if (this.a == value) return this;
    return new ImmutableB<>(value, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericSubType.B#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableB<T> withB(T value) {
    if (this.b == value) return this;
    T newValue = Objects.requireNonNull(value, "b");
    return new ImmutableB<>(this.a, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableB} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableB<?>
        && equalTo(0, (ImmutableB<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableB<?> another) {
    return a == another.a
        && b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code B} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("B")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GenericSubType.B} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable B instance
   */
  public static <T> ImmutableB<T> copyOf(GenericSubType.B<T> instance) {
    if (instance instanceof ImmutableB<?>) {
      return (ImmutableB<T>) instance;
    }
    return ImmutableB.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableB ImmutableB}.
   * <pre>
   * ImmutableB.&amp;lt;T&amp;gt;builder()
   *    .a(int) // required {@link GenericSubType.B#a() a}
   *    .b(T) // required {@link GenericSubType.B#b() b}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableB builder
   */
  public static <T> ImmutableB.Builder<T> builder() {
    return new ImmutableB.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableB ImmutableB}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GenericSubType.B", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private int a;
    private @Nullable T b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.generics.GenericSubType.B} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(GenericSubType.B<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.generics.GenericSubType.A} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(GenericSubType.A instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof GenericSubType.B<?>) {
        GenericSubType.B<T> instance = (GenericSubType.B<T>) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
        b(instance.b());
      }
      if (object instanceof GenericSubType.A) {
        GenericSubType.A instance = (GenericSubType.A) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link GenericSubType.B#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link GenericSubType.B#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> b(T b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableB ImmutableB}.
     * @return An immutable instance of B
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableB<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableB<>(a, b);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build B, some of required attributes are not set " + attributes;
    }
  }
}
