package org.immutables.fixture.encoding.defs;

import org.immutables.encode.EncodingMetadata;

@EncodingMetadata(
  name = "org.immutables.fixture.encoding.defs.PositiveIntEncoding",
  imports = {
  },
  typeParams = {},
  elements = {
    @EncodingMetadata.Element(
      name = "field",
      tags = {"IMPL", "PRIVATE", "FINAL", "FIELD"},
      naming = "*",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "from",
      tags = {"STATIC", "PRIVATE", "FROM"},
      naming = "*_from",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {"v: int"},
      doc = {},
      annotations = {},
      code = "{\nreturn @^v >= 0 ? @^v : -@^v;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "toString",
      tags = {"PRIVATE", "TO_STRING"},
      naming = "*_toString",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn String.valueOf(@@field);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "hashCode",
      tags = {"PRIVATE", "HASH_CODE"},
      naming = "*_hashCode",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @@field;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "equals",
      tags = {"PRIVATE", "EQUALS"},
      naming = "*_equals",
      stdNaming = "NONE",
      type = "boolean",
      typeParams = {},
      params = {"obj: org.immutables.fixture.encoding.defs.PositiveIntEncoding"},
      doc = {},
      annotations = {},
      code = "{\nreturn @@field == @^obj.@@field;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "positiveIntEncoding_build",
      tags = {"BUILDER", "PRIVATE", "BUILD", "SYNTH"},
      naming = "*_build",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nif (@@positiveIntEncoding_builder == null) throw new java.lang.IllegalStateException(\"\'<*>\' is not initialized\");\nreturn @@positiveIntEncoding_builder;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "positiveIntEncoding_isSet",
      tags = {"BUILDER", "PRIVATE", "SYNTH", "IS_INIT"},
      naming = "*_isSet",
      stdNaming = "NONE",
      type = "boolean",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@@positiveIntEncoding_builder != null;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "positiveIntEncoding_get",
      tags = {"EXPOSE", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @@field;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "positiveIntEncoding_copy",
      tags = {"COPY", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {"value: int"},
      doc = {},
      annotations = {},
      code = "{\nreturn @:from(@^value);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "positiveIntEncoding_builder",
      tags = {"BUILDER", "PRIVATE", "FIELD", "SYNTH"},
      naming = "*_builder",
      stdNaming = "NONE",
      type = "java.lang.Integer",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "positiveIntEncoding_set",
      tags = {"BUILDER", "INIT", "COPY", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"value: int"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@positiveIntEncoding_builder = @:from(@^value);\n}",
      thrown = {}
    )
  }
)
public @interface PositiveIntEncodingEnabled {}
