package org.immutables.fixture.encoding.defs;

import org.immutables.encode.EncodingMetadata;

@EncodingMetadata(
  name = "org.immutables.fixture.encoding.defs.OptionalList2",
  imports = {
    "java.util.*",
    "java.util.stream.*"
  },
  typeParams = {"T"},
  elements = {
    @EncodingMetadata.Element(
      name = "list",
      tags = {"IMPL", "PRIVATE", "FINAL", "FIELD"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "null",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "initFromOptional",
      tags = {"STATIC", "PRIVATE", "FROM"},
      naming = "*_initFromOptional",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {},
      params = {"optional: java.util.Optional<java.util.List<T>>"},
      doc = {},
      annotations = {},
      code = "{\nObjects.requireNonNull(@^optional, \"optional\"); // TODO: Adding this line causes methods to be\n// created twice in generated code\nreturn @^optional\n.map(elements -> @:createSafeList(elements)) // TODO: Method reference name mangling doesn\'t\n// happen in generated code\n.orElse(null);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "toString",
      tags = {"PRIVATE", "TO_STRING"},
      naming = "*_toString",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn Objects.toString(this.@@list);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "hashCode",
      tags = {"PRIVATE", "HASH_CODE"},
      naming = "*_hashCode",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn Objects.hashCode(this.@@list);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "equals",
      tags = {"PRIVATE", "EQUALS"},
      naming = "*_equals",
      stdNaming = "NONE",
      type = "boolean",
      typeParams = {},
      params = {"other: org.immutables.fixture.encoding.defs.OptionalList2<T>"},
      doc = {},
      annotations = {},
      code = "{\nreturn Objects.equals(this.@@list, @^other.@@list);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "build",
      tags = {"BUILDER", "PRIVATE", "BUILD"},
      naming = "*_build",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@@list;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "get",
      tags = {"EXPOSE"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.Optional<java.util.List<T>>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn Optional.ofNullable(this.@@list);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "optionalList2_copy",
      tags = {"COPY", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {},
      params = {"value: java.util.Optional<java.util.List<T>>"},
      doc = {},
      annotations = {},
      code = "{\nreturn @:initFromOptional(@^value);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "createSafeList",
      tags = {"STATIC", "PRIVATE", "HELPER"},
      naming = "*_createSafeList",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {"T: java.lang.Object"},
      params = {"iterable: java.lang.Iterable<T>"},
      doc = {},
      annotations = {},
      code = "{\nList<@^T> list = StreamSupport.stream(@^iterable.spliterator(), false)\n.map(element -> Objects.requireNonNull(element, \"element\"))\n.collect(Collectors.toList());\nreturn Collections.unmodifiableList(list);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "list",
      tags = {"BUILDER", "PRIVATE", "FIELD"},
      naming = "*_list",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "addAll",
      tags = {"BUILDER", "INIT"},
      naming = "*",
      stdNaming = "ADD_ALL",
      type = "void",
      typeParams = {},
      params = {"iterable: java.lang.Iterable<T>"},
      doc = {},
      annotations = {},
      code = "{\nObjects.requireNonNull(@^iterable, \"iterable\");\nif (this.@@list == null) {\nthis.@@list = new ArrayList<>();\n}\nStreamSupport.stream(@^iterable.spliterator(), false)\n.map(element -> Objects.requireNonNull(element, \"element\"))\n.forEach(element -> this.@@list.add(element));\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "addSingle",
      tags = {"BUILDER", "INIT"},
      naming = "*",
      stdNaming = "ADD",
      type = "void",
      typeParams = {},
      params = {"element: T"},
      doc = {},
      annotations = {},
      code = "{\nif (this.@@list == null) {\nthis.@@list = new ArrayList<>();\n}\nthis.@@list.add(Objects.requireNonNull(@^element, \"element\"));\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "addVarargs",
      tags = {"BUILDER", "FINAL", "INIT"},
      naming = "*",
      stdNaming = "ADD",
      type = "void",
      typeParams = {},
      params = {"elements: T..."},
      doc = {},
      annotations = {"@java.lang.SafeVarargs"},
      code = "{\nif (this.@@list == null) {\nthis.@@list = new ArrayList<>();\n}\nStream.of(@^elements)\n.forEach(element -> this.@@list.add(Objects.requireNonNull(element, \"element\")));\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "setFromIterable",
      tags = {"BUILDER", "INIT"},
      naming = "*",
      stdNaming = "INIT",
      type = "void",
      typeParams = {},
      params = {"iterable: java.lang.Iterable<T>"},
      doc = {},
      annotations = {},
      code = "{\nif (this.@@list == null) {\nthis.@@list = null;\n} else {\nthis.@@list = StreamSupport.stream(@^iterable.spliterator(), false)\n.map(element -> Objects.requireNonNull(element, \"element\"))\n.collect(Collectors.toList());\n}\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "setFromOptional",
      tags = {"BUILDER", "INIT", "COPY"},
      naming = "*",
      stdNaming = "INIT",
      type = "void",
      typeParams = {},
      params = {"optional: java.util.Optional<java.util.List<T>>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@list = @^optional.orElse(null);\n}",
      thrown = {}
    )
  }
)
public @interface OptionalList2Enabled {}
