package org.immutables.fixture.encoding.defs;

import org.immutables.encode.EncodingMetadata;

@EncodingMetadata(
  name = "org.immutables.fixture.encoding.defs.CompactOptionalDouble",
  imports = {
  },
  typeParams = {},
  elements = {
    @EncodingMetadata.Element(
      name = "opt",
      tags = {"IMPL", "PRIVATE", "FINAL", "VIRTUAL"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.OptionalDouble",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "java.util.OptionalDouble.empty()",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "from",
      tags = {"STATIC", "PRIVATE", "FROM"},
      naming = "*_from",
      stdNaming = "NONE",
      type = "java.util.OptionalDouble",
      typeParams = {},
      params = {"ddd: java.lang.Object"},
      doc = {},
      annotations = {},
      code = "{\nif (Double.isNaN((Double) @^ddd)) {\nreturn java.util.OptionalDouble.empty();\n}\nreturn java.util.OptionalDouble.of((Double) @^ddd);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "toString",
      tags = {"PRIVATE", "TO_STRING", "SYNTH"},
      naming = "*_toString",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:get().toString();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "hashCode",
      tags = {"PRIVATE", "HASH_CODE", "SYNTH"},
      naming = "*_hashCode",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:get().hashCode();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "equals",
      tags = {"PRIVATE", "EQUALS", "SYNTH"},
      naming = "*_equals",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {"other: org.immutables.fixture.encoding.defs.CompactOptionalDouble"},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@:get().equals(@^other.@:get())\n;}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "build",
      tags = {"BUILDER", "PRIVATE", "BUILD"},
      naming = "*_build",
      stdNaming = "NONE",
      type = "java.util.OptionalDouble",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@@builder;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "isSet",
      tags = {"BUILDER", "PRIVATE", "IS_INIT"},
      naming = "*_isSet",
      stdNaming = "NONE",
      type = "boolean",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @@builder.isPresent();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "value",
      tags = {"PRIVATE", "FINAL", "FIELD"},
      naming = "*_value",
      stdNaming = "NONE",
      type = "double",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "@@opt.orElse(0)",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "present",
      tags = {"PRIVATE", "FINAL", "FIELD"},
      naming = "*_present",
      stdNaming = "NONE",
      type = "boolean",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "@@opt.isPresent()",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "get",
      tags = {"EXPOSE"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.OptionalDouble",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @@present\n? java.util.OptionalDouble.of(@@value)\n: java.util.OptionalDouble.empty();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "compactOptionalDouble_copy",
      tags = {"COPY", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.OptionalDouble",
      typeParams = {},
      params = {"value: java.lang.Object"},
      doc = {},
      annotations = {},
      code = "{\nreturn @:from(@^value);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "builder",
      tags = {"BUILDER", "PRIVATE", "FIELD"},
      naming = "*_builder",
      stdNaming = "NONE",
      type = "java.util.OptionalDouble",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "java.util.OptionalDouble.empty()",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "set",
      tags = {"BUILDER", "INIT"},
      naming = "*",
      stdNaming = "INIT",
      type = "void",
      typeParams = {},
      params = {"value: double"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@builder = java.util.OptionalDouble.of(@^value);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "setOpt",
      tags = {"BUILDER", "INIT", "COPY"},
      naming = "*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"value: java.util.OptionalDouble"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@builder = java.util.Objects.requireNonNull(@^value);\n}",
      thrown = {}
    )
  }
)
public @interface CompactOptionalDoubleEnabled {}
