package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Canvas.Color Color} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableColor is not thread-safe</em>
 * @see ImmutableColor
 */
@Generated(from = "Canvas.Color", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Canvas.Color"})
@NotThreadSafe
public final class ModifiableColor implements Canvas.Color {
  private static final long INIT_BIT_RED = 0x1L;
  private static final long INIT_BIT_GREEN = 0x2L;
  private static final long INIT_BIT_BLUE = 0x4L;
  private long initBits = 0x7L;

  private double red;
  private double green;
  private double blue;

  private ModifiableColor() {}

  /**
   * Construct a modifiable instance of {@code Color}.
   * @param red The value for the {@link Canvas.Color#red() red} attribute 
   * @param green The value for the {@link Canvas.Color#green() green} attribute 
   * @param blue The value for the {@link Canvas.Color#blue() blue} attribute 
   * @return A new modifiable instance
   */
  public static ModifiableColor create(double red, double green, double blue) {
    return new ModifiableColor()
        .setRed(red)
        .setGreen(green)
        .setBlue(blue);
  }

  /**
   * Construct a modifiable instance of {@code Color}.
   * @return A new modifiable instance
   */
  public static ModifiableColor create() {
    return new ModifiableColor();
  }

  /**
   * @return value of {@code red} attribute
   */
  @Override
  public final double red() {
    if (!redIsSet()) {
      checkRequiredAttributes();
    }
    return red;
  }

  /**
   * @return value of {@code green} attribute
   */
  @Override
  public final double green() {
    if (!greenIsSet()) {
      checkRequiredAttributes();
    }
    return green;
  }

  /**
   * @return value of {@code blue} attribute
   */
  @Override
  public final double blue() {
    if (!blueIsSet()) {
      checkRequiredAttributes();
    }
    return blue;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableColor clear() {
    initBits = 0x7L;
    red = 0;
    green = 0;
    blue = 0;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Canvas.Color} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableColor from(Canvas.Color instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableColor) {
      from((ModifiableColor) instance);
      return this;
    }
    setRed(instance.red());
    setGreen(instance.green());
    setBlue(instance.blue());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Canvas.Color} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableColor from(ModifiableColor instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.redIsSet()) {
      setRed(instance.red());
    }
    if (instance.greenIsSet()) {
      setGreen(instance.green());
    }
    if (instance.blueIsSet()) {
      setBlue(instance.blue());
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Canvas.Color#red() red} attribute.
   * @param red The value for red
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableColor setRed(double red) {
    this.red = red;
    initBits &= ~INIT_BIT_RED;
    return this;
  }

  /**
   * Assigns a value to the {@link Canvas.Color#green() green} attribute.
   * @param green The value for green
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableColor setGreen(double green) {
    this.green = green;
    initBits &= ~INIT_BIT_GREEN;
    return this;
  }

  /**
   * Assigns a value to the {@link Canvas.Color#blue() blue} attribute.
   * @param blue The value for blue
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableColor setBlue(double blue) {
    this.blue = blue;
    initBits &= ~INIT_BIT_BLUE;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link Canvas.Color#red() red} is set.
   * @return {@code true} if set
   */
  public final boolean redIsSet() {
    return (initBits & INIT_BIT_RED) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link Canvas.Color#green() green} is set.
   * @return {@code true} if set
   */
  public final boolean greenIsSet() {
    return (initBits & INIT_BIT_GREEN) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link Canvas.Color#blue() blue} is set.
   * @return {@code true} if set
   */
  public final boolean blueIsSet() {
    return (initBits & INIT_BIT_BLUE) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableColor unsetRed() {
    initBits |= INIT_BIT_RED;
    red = 0;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableColor unsetGreen() {
    initBits |= INIT_BIT_GREEN;
    green = 0;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableColor unsetBlue() {
    initBits |= INIT_BIT_BLUE;
    blue = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!redIsSet()) attributes.add("red");
    if (!greenIsSet()) attributes.add("green");
    if (!blueIsSet()) attributes.add("blue");
    return "Color is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableColor ImmutableColor}.
   * @return An immutable instance of Color
   */
  public final ImmutableColor toImmutable() {
    checkRequiredAttributes();
    return ImmutableColor.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableColor} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableColor)) return false;
    ModifiableColor other = (ModifiableColor) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableColor another) {
    return Double.doubleToLongBits(red) == Double.doubleToLongBits(another.red)
        && Double.doubleToLongBits(green) == Double.doubleToLongBits(another.green)
        && Double.doubleToLongBits(blue) == Double.doubleToLongBits(another.blue);
  }

  /**
   * Computes a hash code from attributes: {@code red}, {@code green}, {@code blue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Doubles.hashCode(red);
    h += (h << 5) + Doubles.hashCode(green);
    h += (h << 5) + Doubles.hashCode(blue);
    return h;
  }

  /**
   * Generates a string representation of this {@code Color}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableColor")
        .add("red", redIsSet() ? red() : "?")
        .add("green", greenIsSet() ? green() : "?")
        .add("blue", blueIsSet() ? blue() : "?")
        .toString();
  }
}
