package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Canvas.Point}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePoint.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePoint.of()}.
 */
@Generated(from = "Canvas.Point", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePoint implements Canvas.Point {
  private final int x;
  private final int y;

  private ImmutablePoint(int x, int y) {
    this.x = x;
    this.y = y;
  }

  private ImmutablePoint(ImmutablePoint original, int x, int y) {
    this.x = x;
    this.y = y;
  }

  /**
   * @return The value of the {@code x} attribute
   */
  @Override
  public int x() {
    return x;
  }

  /**
   * @return The value of the {@code y} attribute
   */
  @Override
  public int y() {
    return y;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Canvas.Point#x() x} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for x
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePoint withX(int value) {
    if (this.x == value) return this;
    return new ImmutablePoint(this, value, this.y);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Canvas.Point#y() y} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for y
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePoint withY(int value) {
    if (this.y == value) return this;
    return new ImmutablePoint(this, this.x, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePoint} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePoint
        && equalTo(0, (ImmutablePoint) another);
  }

  private boolean equalTo(int synthetic, ImmutablePoint another) {
    return x == another.x
        && y == another.y;
  }

  /**
   * Computes a hash code from attributes: {@code x}, {@code y}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + x;
    h += (h << 5) + y;
    return h;
  }

  /**
   * Prints the immutable value {@code Point} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Point")
        .omitNullValues()
        .add("x", x)
        .add("y", y)
        .toString();
  }

  /**
   * Construct a new immutable {@code Point} instance.
   * @param x The value for the {@code x} attribute
   * @param y The value for the {@code y} attribute
   * @return An immutable Point instance
   */
  public static ImmutablePoint of(int x, int y) {
    return new ImmutablePoint(x, y);
  }

  /**
   * Creates an immutable copy of a {@link Canvas.Point} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Point instance
   */
  public static ImmutablePoint copyOf(Canvas.Point instance) {
    if (instance instanceof ImmutablePoint) {
      return (ImmutablePoint) instance;
    }
    return ImmutablePoint.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePoint ImmutablePoint}.
   * <pre>
   * ImmutablePoint.builder()
   *    .x(int) // required {@link Canvas.Point#x() x}
   *    .y(int) // required {@link Canvas.Point#y() y}
   *    .build();
   * </pre>
   * @return A new ImmutablePoint builder
   */
  public static ImmutablePoint.Builder builder() {
    return new ImmutablePoint.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePoint ImmutablePoint}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Canvas.Point", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_X = 0x1L;
    private static final long INIT_BIT_Y = 0x2L;
    private long initBits = 0x3L;

    private int x;
    private int y;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiablePoint} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiablePoint instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.xIsSet()) {
        x(instance.x());
      }
      if (instance.yIsSet()) {
        y(instance.y());
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Point} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Canvas.Point instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiablePoint) {
        return from((ModifiablePoint) instance);
      }
      x(instance.x());
      y(instance.y());
      return this;
    }

    /**
     * Initializes the value for the {@link Canvas.Point#x() x} attribute.
     * @param x The value for x 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder x(int x) {
      this.x = x;
      initBits &= ~INIT_BIT_X;
      return this;
    }

    /**
     * Initializes the value for the {@link Canvas.Point#y() y} attribute.
     * @param y The value for y 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder y(int y) {
      this.y = y;
      initBits &= ~INIT_BIT_Y;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePoint ImmutablePoint}.
     * @return An immutable instance of Point
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePoint build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePoint(null, x, y);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_X) != 0) attributes.add("x");
      if ((initBits & INIT_BIT_Y) != 0) attributes.add("y");
      return "Cannot build Point, some of required attributes are not set " + attributes;
    }
  }
}
