package org.immutables.fixture.deep;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeepChild}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeepChild.builder()}.
 */
@Generated(from = "DeepChild", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableDeepChild implements DeepChild {

  private ImmutableDeepChild(ImmutableDeepChild.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeepChild} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeepChild
        && equalTo(0, (ImmutableDeepChild) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableDeepChild another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1382793627;
  }

  /**
   * Prints the immutable value {@code DeepChild}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeepChild{}";
  }

  /**
   * Creates an immutable copy of a {@link DeepChild} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeepChild instance
   */
  public static ImmutableDeepChild copyOf(DeepChild instance) {
    if (instance instanceof ImmutableDeepChild) {
      return (ImmutableDeepChild) instance;
    }
    return ImmutableDeepChild.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeepChild ImmutableDeepChild}.
   * <pre>
   * ImmutableDeepChild.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableDeepChild builder
   */
  public static ImmutableDeepChild.Builder builder() {
    return new ImmutableDeepChild.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeepChild ImmutableDeepChild}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeepChild", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeepChild} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeepChild instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeepChild ImmutableDeepChild}.
     * @return An immutable instance of DeepChild
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeepChild build() {
      return new ImmutableDeepChild(this);
    }
  }
}
