package org.immutables.fixture.deep;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeepAndJdkOnly.Container}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContainer.builder()}.
 */
@Generated(from = "DeepAndJdkOnly.Container", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContainer implements DeepAndJdkOnly.Container {
  private final ImmutableDeep deep;

  private ImmutableContainer(ImmutableDeep deep) {
    this.deep = deep;
  }

  /**
   * @return The value of the {@code deep} attribute
   */
  @Override
  public ImmutableDeep getDeep() {
    return deep;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeepAndJdkOnly.Container#getDeep() deep} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deep
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContainer withDeep(DeepAndJdkOnly.Deep value) {
    if (this.deep == value) return this;
    ImmutableDeep newValue = ImmutableDeep.copyOf(value);
    return new ImmutableContainer(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContainer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContainer
        && equalTo(0, (ImmutableContainer) another);
  }

  private boolean equalTo(int synthetic, ImmutableContainer another) {
    return deep.equals(another.deep);
  }

  /**
   * Computes a hash code from attributes: {@code deep}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + deep.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Container} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Container{"
        + "deep=" + deep
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DeepAndJdkOnly.Container} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Container instance
   */
  public static ImmutableContainer copyOf(DeepAndJdkOnly.Container instance) {
    if (instance instanceof ImmutableContainer) {
      return (ImmutableContainer) instance;
    }
    return ImmutableContainer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContainer ImmutableContainer}.
   * <pre>
   * ImmutableContainer.builder()
   *    .deep(org.immutables.fixture.deep.DeepAndJdkOnly.Deep) // required {@link DeepAndJdkOnly.Container#getDeep() deep}
   *    .build();
   * </pre>
   * @return A new ImmutableContainer builder
   */
  public static ImmutableContainer.Builder builder() {
    return new ImmutableContainer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContainer ImmutableContainer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeepAndJdkOnly.Container", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DEEP = 0x1L;
    private long initBits = 0x1L;

    private @Nullable DeepAndJdkOnly.Deep deep;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Container} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeepAndJdkOnly.Container instance) {
      Objects.requireNonNull(instance, "instance");
      deep(instance.getDeep());
      return this;
    }

    /**
     * Constructs and initializes the value for the {@link DeepAndJdkOnly.Container#getDeep() deep} attribute.
     * @param a The value for {@code deep.a} 
     * @param b The value for {@code deep.b} 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deep(int a, int b) {
      return deep(ImmutableDeep.of(a, b));
    }

    /**
     * Initializes the value for the {@link DeepAndJdkOnly.Container#getDeep() deep} attribute.
     * @param deep The value for deep 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deep(DeepAndJdkOnly.Deep deep) {
      this.deep = ImmutableDeep.copyOf(deep);
      initBits &= ~INIT_BIT_DEEP;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContainer ImmutableContainer}.
     * @return An immutable instance of Container
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContainer build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContainer(ImmutableDeep.copyOf(deep));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DEEP) != 0) attributes.add("deep");
      return "Cannot build Container, some of required attributes are not set " + attributes;
    }
  }
}
