package org.immutables.fixture.custann;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.CustColl;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CustomCollection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new CustomCollection.Builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCustomCollection.of()}.
 */
@Generated(from = "CustomCollection", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCustomCollection<E> implements CustomCollection<E> {
  private final CustColl<E> col;
  private final CustColl<Integer> cint;

  private ImmutableCustomCollection(Iterable<? extends E> col) {
    this.col = CustColl.from(col);
    this.cint = CustColl.of();
  }

  private ImmutableCustomCollection(CustColl<E> col, CustColl<Integer> cint) {
    this.col = col;
    this.cint = cint;
  }

  /**
   * @return The value of the {@code col} attribute
   */
  @Override
  public CustColl<E> col() {
    return col;
  }

  /**
   * @return The value of the {@code cint} attribute
   */
  @Override
  public CustColl<Integer> cint() {
    return cint;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CustomCollection#col() col}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableCustomCollection<E> withCol(E... elements) {
    CustColl<E> newValue = CustColl.from(Arrays.asList(elements));
    return new ImmutableCustomCollection<>(newValue, this.cint);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CustomCollection#col() col}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of col elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCustomCollection<E> withCol(Iterable<? extends E> elements) {
    if (this.col == elements) return this;
    CustColl<E> newValue = CustColl.from(elements);
    return new ImmutableCustomCollection<>(newValue, this.cint);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CustomCollection#cint() cint}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCustomCollection<E> withCint(int... elements) {
    CustColl<Integer> newValue = CustColl.from(Ints.asList(elements));
    return new ImmutableCustomCollection<>(this.col, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CustomCollection#cint() cint}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of cint elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCustomCollection<E> withCint(Iterable<Integer> elements) {
    if (this.cint == elements) return this;
    CustColl<Integer> newValue = CustColl.from(elements);
    return new ImmutableCustomCollection<>(this.col, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCustomCollection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCustomCollection<?>
        && equalTo(0, (ImmutableCustomCollection<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableCustomCollection<?> another) {
    return col.equals(another.col)
        && cint.equals(another.cint);
  }

  /**
   * Computes a hash code from attributes: {@code col}, {@code cint}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + col.hashCode();
    h += (h << 5) + cint.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CustomCollection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CustomCollection")
        .omitNullValues()
        .add("col", col)
        .add("cint", cint)
        .toString();
  }

  /**
   * Construct a new immutable {@code CustomCollection} instance.
 * @param <E> generic parameter E
   * @param col The value for the {@code col} attribute
   * @return An immutable CustomCollection instance
   */
  public static <E> ImmutableCustomCollection<E> of(CustColl<E> col) {
    return of((Iterable<? extends E>) col);
  }

  /**
   * Construct a new immutable {@code CustomCollection} instance.
 * @param <E> generic parameter E
   * @param col The value for the {@code col} attribute
   * @return An immutable CustomCollection instance
   */
  public static <E> ImmutableCustomCollection<E> of(Iterable<? extends E> col) {
    return new ImmutableCustomCollection<>(col);
  }

  /**
   * Creates an immutable copy of a {@link CustomCollection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <E> generic parameter E
   * @param instance The instance to copy
   * @return A copied immutable CustomCollection instance
   */
  public static <E> ImmutableCustomCollection<E> copyOf(CustomCollection<E> instance) {
    if (instance instanceof ImmutableCustomCollection<?>) {
      return (ImmutableCustomCollection<E>) instance;
    }
    return new CustomCollection.Builder<E>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCustomCollection ImmutableCustomCollection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CustomCollection", generator = "Immutables")
  @NotThreadSafe
  public static class Builder<E> {
    private CustColl.Builder<E> col = CustColl.builder();
    private CustColl.Builder<Integer> cint = CustColl.builder();

    /**
     * Creates a builder for {@link ImmutableCustomCollection ImmutableCustomCollection} instances.
     * <pre>
     * new CustomCollection.Builder&amp;lt;E&amp;gt;()
     *    .addCol|addAllCol(E) // {@link CustomCollection#col() col} elements
     *    .addCint|addAllCint(int) // {@link CustomCollection#cint() cint} elements
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof CustomCollection.Builder<?>)) {
        throw new UnsupportedOperationException("Use: new CustomCollection.Builder<E>()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code CustomCollection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CustomCollection.Builder<E> from(CustomCollection<E> instance) {
      Objects.requireNonNull(instance, "instance");
      addAllCol(instance.col());
      addAllCint(instance.cint());
      return (CustomCollection.Builder<E>) this;
    }

    /**
     * Adds one element to {@link CustomCollection#col() col} custColl.
     * @param element A col element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CustomCollection.Builder<E> addCol(E element) {
      this.col.add(element);
      return (CustomCollection.Builder<E>) this;
    }

    /**
     * Adds elements to {@link CustomCollection#col() col} custColl.
     * @param elements An array of col elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final CustomCollection.Builder<E> addCol(E... elements) {
      this.col.addAll(Arrays.asList(elements));
      return (CustomCollection.Builder<E>) this;
    }


    /**
     * Sets or replaces all elements for {@link CustomCollection#col() col} custColl.
     * @param elements An iterable of col elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CustomCollection.Builder<E> col(Iterable<? extends E> elements) {
      this.col = CustColl.builder();
      return addAllCol(elements);
    }

    /**
     * Adds elements to {@link CustomCollection#col() col} custColl.
     * @param elements An iterable of col elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CustomCollection.Builder<E> addAllCol(Iterable<? extends E> elements) {
      this.col.addAll(elements);
      return (CustomCollection.Builder<E>) this;
    }

    /**
     * Adds one element to {@link CustomCollection#cint() cint} custColl.
     * @param element A cint element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CustomCollection.Builder<E> addCint(int element) {
      this.cint.add(element);
      return (CustomCollection.Builder<E>) this;
    }

    /**
     * Adds elements to {@link CustomCollection#cint() cint} custColl.
     * @param elements An array of cint elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CustomCollection.Builder<E> addCint(int... elements) {
      this.cint.addAll(Ints.asList(elements));
      return (CustomCollection.Builder<E>) this;
    }


    /**
     * Sets or replaces all elements for {@link CustomCollection#cint() cint} custColl.
     * @param elements An iterable of cint elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CustomCollection.Builder<E> cint(Iterable<Integer> elements) {
      this.cint = CustColl.builder();
      return addAllCint(elements);
    }

    /**
     * Adds elements to {@link CustomCollection#cint() cint} custColl.
     * @param elements An iterable of cint elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CustomCollection.Builder<E> addAllCint(Iterable<Integer> elements) {
      this.cint.addAll(elements);
      return (CustomCollection.Builder<E>) this;
    }

    /**
     * Builds a new {@link ImmutableCustomCollection ImmutableCustomCollection}.
     * @return An immutable instance of CustomCollection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCustomCollection<E> build() {
      return new ImmutableCustomCollection<>(col.build(), cint.build());
    }
  }
}
