package org.immutables.fixture.custann;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;
import nonimmutables.CustColl;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code CustomCollection}.
 * @see ImmutableCustomCollection
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture.custann", generator = "Gsons")
public final class GsonAdaptersCustomCollection implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (CustomCollectionTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new CustomCollectionTypeAdapter(type, gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersCustomCollection(CustomCollection)";
  }

  @org.immutables.value.Generated(from = "CustomCollection", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class CustomCollectionTypeAdapter<E> extends TypeAdapter<CustomCollection<E>> {
    public final Integer cintTypeSample = null;
    private final TypeAdapter<E> colTypeAdapter;
    private final TypeAdapter<Integer> cintTypeAdapter;

    CustomCollectionTypeAdapter(TypeToken<?> type, Gson gson) {
      Type[] typeArguments = getTypeArguments(type);
      this.colTypeAdapter = gson.getAdapter( (TypeToken<E>) TypeToken.get(typeArguments[0]));
      this.cintTypeAdapter = gson.getAdapter( Integer.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return CustomCollection.class == type.getRawType()
          || ImmutableCustomCollection.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, CustomCollection<E> value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeCustomCollection(out, value);
      }
    }

    @Override
    public CustomCollection<E> read(JsonReader in) throws IOException {
      return readCustomCollection(in);
    }

    private void writeCustomCollection(JsonWriter out, CustomCollection<E> instance)
        throws IOException {
      out.beginObject();
      CustColl<E> colElements = instance.col();
      out.name("col");
      out.beginArray();
      for (E e : colElements) {
        colTypeAdapter.write(out, e);
      }
      out.endArray();
      CustColl<Integer> cintElements = instance.cint();
      out.name("cint");
      out.beginArray();
      for (Integer e : cintElements) {
        cintTypeAdapter.write(out, e);
      }
      out.endArray();
      out.endObject();
    }

    private  CustomCollection<E> readCustomCollection(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      CustomCollection.Builder<E> builder = new CustomCollection.Builder<E>();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, CustomCollection.Builder<E> builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'c':
        if ("col".equals(attributeName)) {
          readInCol(in, builder);
          return;
        }
        if ("cint".equals(attributeName)) {
          readInCint(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInCol(JsonReader in, CustomCollection.Builder<E> builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          E value = colTypeAdapter.read(in);
          builder.addCol(value);
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        E value = colTypeAdapter.read(in);
        builder.addCol(value);
      }
    }

    private void readInCint(JsonReader in, CustomCollection.Builder<E> builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addCint(in.nextInt());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addCint(in.nextInt());
      }
    }
  }

  private static Type[] getTypeArguments(TypeToken<?> type) {
    if (type.getType() instanceof ParameterizedType) {
      return ((ParameterizedType) type.getType()).getActualTypeArguments();
    }
    throw new IllegalStateException("Please supply Type with actual type parameters to serialize "
        + type.getType() + " instance using method overloads like toJson(instance, type)."
        + " Runtime raw type alone is not enough."
        + " You can use TypeToken class or reflection to construct Type with type arguments");
  }
}
