package org.immutables.fixture.couse.sub;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.couse.A;
import org.immutables.fixture.couse.B;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractC}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code C.builder()}.
 */
@Generated(from = "AbstractC", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class C implements AbstractC {
  private final @Strange int i;
  private final java.lang.@Strange String s;
  private final A a;
  private final Optional<A> aO;
  private final ImmutableMap<A, List<B>> abM;
  private final ImmutableMap<RetentionPolicy, C> raM;

  private C(
      @Strange int i,
      java.lang.@Strange String s,
      A a,
      Optional<A> aO,
      ImmutableMap<A, List<B>> abM,
      ImmutableMap<RetentionPolicy, C> raM) {
    this.i = i;
    this.s = s;
    this.a = a;
    this.aO = aO;
    this.abM = abM;
    this.raM = raM;
  }

  /**
   * @return The value of the {@code i} attribute
   */
  @Override
  public @Strange int i() {
    return i;
  }

  /**
   * @return The value of the {@code s} attribute
   */
  @Override
  public java.lang.@Strange String s() {
    return s;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public A a() {
    return a;
  }

  /**
   * @return The value of the {@code aO} attribute
   */
  @Override
  public Optional<A> aO() {
    return aO;
  }

  /**
   * @return The value of the {@code abM} attribute
   */
  @Override
  public ImmutableMap<A, List<B>> abM() {
    return abM;
  }

  /**
   * @return The value of the {@code raM} attribute
   */
  @Override
  public ImmutableMap<RetentionPolicy, C> raM() {
    return raM;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link C#i() i} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for i
   * @return A modified copy of the {@code this} object
   */
  public final C withI(@Strange int value) {
    if (this.i == value) return this;
    return new C(value, this.s, this.a, this.aO, this.abM, this.raM);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link C#s() s} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for s
   * @return A modified copy of the {@code this} object
   */
  public final C withS(java.lang.@Strange String value) {
    java.lang.@Strange String newValue = Objects.requireNonNull(value, "s");
    if (this.s.equals(newValue)) return this;
    return new C(this.i, newValue, this.a, this.aO, this.abM, this.raM);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link C#a() a} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final C withA(A value) {
    if (this.a == value) return this;
    A newValue = Objects.requireNonNull(value, "a");
    return new C(this.i, this.s, newValue, this.aO, this.abM, this.raM);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link C#aO() aO} attribute.
   * @param value The value for aO
   * @return A modified copy of {@code this} object
   */
  public final C withAO(A value) {
    Optional<A> newValue = Optional.of(value);
    if (this.aO.isPresent() && this.aO.get() == value) return this;
    return new C(this.i, this.s, this.a, newValue, this.abM, this.raM);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link C#aO() aO} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for aO
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final C withAO(Optional<? extends A> optional) {
    Optional<A> value = (Optional<A>) optional;
    if (!this.aO.isPresent() && !value.isPresent()) return this;
    if (this.aO.isPresent() && value.isPresent() && this.aO.get() == value.get()) return this;
    return new C(this.i, this.s, this.a, value, this.abM, this.raM);
  }

  /**
   * Copy the current immutable object by replacing the {@link C#abM() abM} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the abM map
   * @return A modified copy of {@code this} object
   */
  public final C withAbM(Map<? extends A, ? extends List<B>> entries) {
    if (this.abM == entries) return this;
    ImmutableMap<A, List<B>> newValue = ImmutableMap.copyOf(entries);
    return new C(this.i, this.s, this.a, this.aO, newValue, this.raM);
  }

  /**
   * Copy the current immutable object by replacing the {@link C#raM() raM} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the raM map
   * @return A modified copy of {@code this} object
   */
  public final C withRaM(Map<RetentionPolicy, ? extends C> entries) {
    if (this.raM == entries) return this;
    ImmutableMap<RetentionPolicy, C> newValue = Maps.immutableEnumMap(entries);
    return new C(this.i, this.s, this.a, this.aO, this.abM, newValue);
  }

  /**
   * This instance is equal to all instances of {@code C} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof C
        && equalTo(0, (C) another);
  }

  private boolean equalTo(int synthetic, C another) {
    return i == another.i
        && s.equals(another.s)
        && a.equals(another.a)
        && aO.equals(another.aO)
        && abM.equals(another.abM)
        && raM.equals(another.raM);
  }

  /**
   * Computes a hash code from attributes: {@code i}, {@code s}, {@code a}, {@code aO}, {@code abM}, {@code raM}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + i;
    h += (h << 5) + s.hashCode();
    h += (h << 5) + a.hashCode();
    h += (h << 5) + aO.hashCode();
    h += (h << 5) + abM.hashCode();
    h += (h << 5) + raM.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code C} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("C")
        .omitNullValues()
        .add("i", i)
        .add("s", s)
        .add("a", a)
        .add("aO", aO.orNull())
        .add("abM", abM)
        .add("raM", raM)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AbstractC} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable C instance
   */
  static C copyOf(AbstractC instance) {
    if (instance instanceof C) {
      return (C) instance;
    }
    return C.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link C C}.
   * <pre>
   * C.builder()
   *    .i(@org.immutables.fixture.couse.sub.Strange int) // required {@link C#i() i}
   *    .s(@org.immutables.fixture.couse.sub.Strange String) // required {@link C#s() s}
   *    .a(org.immutables.fixture.couse.A) // required {@link C#a() a}
   *    .aO(org.immutables.fixture.couse.A) // optional {@link C#aO() aO}
   *    .putAbM|putAllAbM(org.immutables.fixture.couse.A =&gt; List&amp;lt;org.immutables.fixture.couse.B&amp;gt;) // {@link C#abM() abM} mappings
   *    .putRaM|putAllRaM(annotation.RetentionPolicy =&gt; C) // {@link C#raM() raM} mappings
   *    .build();
   * </pre>
   * @return A new C builder
   */
  public static C.Builder builder() {
    return new C.Builder();
  }

  /**
   * Builds instances of type {@link C C}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractC", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_I = 0x1L;
    private static final long INIT_BIT_S = 0x2L;
    private static final long INIT_BIT_A = 0x4L;
    private long initBits = 0x7L;

    private @Strange int i;
    private @Nullable java.lang.@Strange String s;
    private @Nullable A a;
    private Optional<A> aO = Optional.absent();
    private ImmutableMap.Builder<A, List<B>> abM = ImmutableMap.builder();
    private ImmutableMap.Builder<RetentionPolicy, C> raM = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code C} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(C instance) {
      return from((AbstractC) instance);
    }

    /**
     * Copy abstract value type {@code AbstractC} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(AbstractC instance) {
      Objects.requireNonNull(instance, "instance");
      i(instance.i());
      s(instance.s());
      a(instance.a());
      Optional<A> aOOptional = instance.aO();
      if (aOOptional.isPresent()) {
        aO(aOOptional);
      }
      putAllAbM(instance.abM());
      putAllRaM(instance.raM());
      return this;
    }

    /**
     * Initializes the value for the {@link C#i() i} attribute.
     * @param i The value for i 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i(@Strange int i) {
      this.i = i;
      initBits &= ~INIT_BIT_I;
      return this;
    }

    /**
     * Initializes the value for the {@link C#s() s} attribute.
     * @param s The value for s 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder s(java.lang.@Strange String s) {
      this.s = Objects.requireNonNull(s, "s");
      initBits &= ~INIT_BIT_S;
      return this;
    }

    /**
     * Initializes the value for the {@link C#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(A a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the optional value {@link C#aO() aO} to aO.
     * @param aO The value for aO
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder aO(A aO) {
      this.aO = Optional.of(aO);
      return this;
    }

    /**
     * Initializes the optional value {@link C#aO() aO} to aO.
     * @param aO The value for aO
     * @return {@code this} builder for use in a chained invocation
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    @CanIgnoreReturnValue 
    public final Builder aO(Optional<? extends A> aO) {
      this.aO = (Optional<A>) aO;
      return this;
    }

    /**
     * Put one entry to the {@link C#abM() abM} map.
     * @param key The key in the abM map
     * @param value The associated value in the abM map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAbM(A key, List<B> value) {
      this.abM.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link C#abM() abM} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAbM(Map.Entry<? extends A, ? extends List<B>> entry) {
      this.abM.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link C#abM() abM} map. Nulls are not permitted
     * @param entries The entries that will be added to the abM map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder abM(Map<? extends A, ? extends List<B>> entries) {
      this.abM = ImmutableMap.builder();
      return putAllAbM(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link C#abM() abM} map. Nulls are not permitted
     * @param entries The entries that will be added to the abM map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllAbM(Map<? extends A, ? extends List<B>> entries) {
      this.abM.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link C#raM() raM} map.
     * @param key The key in the raM map
     * @param value The associated value in the raM map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putRaM(RetentionPolicy key, C value) {
      this.raM.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link C#raM() raM} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putRaM(Map.Entry<RetentionPolicy, ? extends C> entry) {
      this.raM.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link C#raM() raM} map. Nulls are not permitted
     * @param entries The entries that will be added to the raM map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder raM(Map<RetentionPolicy, ? extends C> entries) {
      this.raM = ImmutableMap.builder();
      return putAllRaM(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link C#raM() raM} map. Nulls are not permitted
     * @param entries The entries that will be added to the raM map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllRaM(Map<RetentionPolicy, ? extends C> entries) {
      this.raM.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link C C}.
     * @return An immutable instance of C
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public C build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new C(i, s, a, aO, abM.build(), Maps.immutableEnumMap(raM.build()));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_I) != 0) attributes.add("i");
      if ((initBits & INIT_BIT_S) != 0) attributes.add("s");
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build C, some of required attributes are not set " + attributes;
    }
  }
}
