package org.immutables.fixture.couse;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractB}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code B.builder()}.
 */
@Generated(from = "AbstractB", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class B implements AbstractB {
  private final A a;
  private final Optional<A> aO;

  private B(A a, Optional<A> aO) {
    this.a = a;
    this.aO = aO;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public A a() {
    return a;
  }

  /**
   * @return The value of the {@code aO} attribute
   */
  @Override
  public Optional<A> aO() {
    return aO;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link B#a() a} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final B withA(A value) {
    if (this.a == value) return this;
    A newValue = Objects.requireNonNull(value, "a");
    return new B(newValue, this.aO);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link B#aO() aO} attribute.
   * @param value The value for aO
   * @return A modified copy of {@code this} object
   */
  public final B withAO(A value) {
    Optional<A> newValue = Optional.of(value);
    if (this.aO.isPresent() && this.aO.get() == value) return this;
    return new B(this.a, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link B#aO() aO} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for aO
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final B withAO(Optional<? extends A> optional) {
    Optional<A> value = (Optional<A>) optional;
    if (!this.aO.isPresent() && !value.isPresent()) return this;
    if (this.aO.isPresent() && value.isPresent() && this.aO.get() == value.get()) return this;
    return new B(this.a, value);
  }

  /**
   * This instance is equal to all instances of {@code B} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof B
        && equalTo(0, (B) another);
  }

  private boolean equalTo(int synthetic, B another) {
    return a.equals(another.a)
        && aO.equals(another.aO);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code aO}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + aO.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code B} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("B")
        .omitNullValues()
        .add("a", a)
        .add("aO", aO.orNull())
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AbstractB} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable B instance
   */
  static B copyOf(AbstractB instance) {
    if (instance instanceof B) {
      return (B) instance;
    }
    return B.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link B B}.
   * <pre>
   * B.builder()
   *    .a(org.immutables.fixture.couse.A) // required {@link B#a() a}
   *    .aO(A) // optional {@link B#aO() aO}
   *    .build();
   * </pre>
   * @return A new B builder
   */
  public static B.Builder builder() {
    return new B.Builder();
  }

  /**
   * Builds instances of type {@link B B}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractB", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private @Nullable A a;
    private Optional<A> aO = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code B} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(B instance) {
      return from((AbstractB) instance);
    }

    /**
     * Copy abstract value type {@code AbstractB} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(AbstractB instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      Optional<A> aOOptional = instance.aO();
      if (aOOptional.isPresent()) {
        aO(aOOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link B#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(A a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the optional value {@link B#aO() aO} to aO.
     * @param aO The value for aO
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder aO(A aO) {
      this.aO = Optional.of(aO);
      return this;
    }

    /**
     * Initializes the optional value {@link B#aO() aO} to aO.
     * @param aO The value for aO
     * @return {@code this} builder for use in a chained invocation
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    @CanIgnoreReturnValue 
    public final Builder aO(Optional<? extends A> aO) {
      this.aO = (Optional<A>) aO;
      return this;
    }

    /**
     * Builds a new {@link B B}.
     * @return An immutable instance of B
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public B build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new B(a, aO);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build B, some of required attributes are not set " + attributes;
    }
  }
}
