package org.immutables.fixture.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ToBuilderMethod.ToBuilderSandwich}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ToBuilderMethod.ToBuilderSandwich.Builder()}.
 */
@Generated(from = "ToBuilderMethod.ToBuilderSandwich", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableToBuilderSandwich
    implements ToBuilderMethod.ToBuilderSandwich {
  private final int a;
  private final String b;

  private ImmutableToBuilderSandwich(int a, String b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public String b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ToBuilderMethod.ToBuilderSandwich#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToBuilderSandwich withA(int value) {
    if (this.a == value) return this;
    return new ImmutableToBuilderSandwich(value, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ToBuilderMethod.ToBuilderSandwich#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToBuilderSandwich withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableToBuilderSandwich(this.a, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableToBuilderSandwich} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableToBuilderSandwich
        && equalTo(0, (ImmutableToBuilderSandwich) another);
  }

  private boolean equalTo(int synthetic, ImmutableToBuilderSandwich another) {
    return a == another.a
        && b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ToBuilderSandwich} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ToBuilderSandwich")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ToBuilderMethod.ToBuilderSandwich} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ToBuilderSandwich instance
   */
  public static ToBuilderMethod.ToBuilderSandwich copyOf(ToBuilderMethod.ToBuilderSandwich instance) {
    if (instance instanceof ImmutableToBuilderSandwich) {
      return (ImmutableToBuilderSandwich) instance;
    }
    return new ToBuilderMethod.ToBuilderSandwich.Builder()
        .from(instance)
        .build();
  }
  /**
   * Creates a builder for {@link ToBuilderMethod.ToBuilderSandwich ToBuilderSandwich}.prefilled
   * with attibute values of {@code this} instance to easily create modified copies.
   * @return A new ToBuilderSandwich builder with attributes of {@code this} instance
   */
  public ToBuilderMethod.ToBuilderSandwich.Builder toBuilder() {
    return new ToBuilderMethod.ToBuilderSandwich.Builder().from(this);
  }

  /**
   * Builds instances of type {@link ToBuilderMethod.ToBuilderSandwich ToBuilderSandwich}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ToBuilderMethod.ToBuilderSandwich", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private int a;
    private @Nullable String b;

    /**
     * Creates a builder for {@link ToBuilderMethod.ToBuilderSandwich ToBuilderSandwich} instances.
     * <pre>
     * new ToBuilderMethod.ToBuilderSandwich.Builder()
     *    .a(int) // required {@link ToBuilderMethod.ToBuilderSandwich#a() a}
     *    .b(String) // required {@link ToBuilderMethod.ToBuilderSandwich#b() b}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ToBuilderMethod.ToBuilderSandwich.Builder)) {
        throw new UnsupportedOperationException("Use: new ToBuilderMethod.ToBuilderSandwich.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ToBuilderSandwich} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ToBuilderMethod.ToBuilderSandwich.Builder from(ToBuilderMethod.ToBuilderSandwich instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      return (ToBuilderMethod.ToBuilderSandwich.Builder) this;
    }

    /**
     * Initializes the value for the {@link ToBuilderMethod.ToBuilderSandwich#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ToBuilderMethod.ToBuilderSandwich.Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return (ToBuilderMethod.ToBuilderSandwich.Builder) this;
    }

    /**
     * Initializes the value for the {@link ToBuilderMethod.ToBuilderSandwich#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ToBuilderMethod.ToBuilderSandwich.Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return (ToBuilderMethod.ToBuilderSandwich.Builder) this;
    }

    /**
     * Builds a new {@link ToBuilderMethod.ToBuilderSandwich ToBuilderSandwich}.
     * @return An immutable instance of ToBuilderSandwich
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ToBuilderMethod.ToBuilderSandwich build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableToBuilderSandwich(a, b);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build ToBuilderSandwich, some of required attributes are not set " + attributes;
    }
  }
}
