package org.immutables.fixture.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OneAndTwoConcrete}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOneAndTwoConcrete.builder()}.
 */
@Generated(from = "OneAndTwoConcrete", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableOneAndTwoConcrete implements OneAndTwoConcrete {
  private final String one;
  private final String two;

  private ImmutableOneAndTwoConcrete(String one, String two) {
    this.one = one;
    this.two = two;
  }

  /**
   * @return The value of the {@code one} attribute
   */
  @Override
  public String one() {
    return one;
  }

  /**
   * @return The value of the {@code two} attribute
   */
  @Override
  public String two() {
    return two;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OneAndTwoConcrete#one() one} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for one
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOneAndTwoConcrete withOne(String value) {
    String newValue = Objects.requireNonNull(value, "one");
    if (this.one.equals(newValue)) return this;
    return new ImmutableOneAndTwoConcrete(newValue, this.two);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OneAndTwoConcrete#two() two} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for two
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOneAndTwoConcrete withTwo(String value) {
    String newValue = Objects.requireNonNull(value, "two");
    if (this.two.equals(newValue)) return this;
    return new ImmutableOneAndTwoConcrete(this.one, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOneAndTwoConcrete} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOneAndTwoConcrete
        && equalTo(0, (ImmutableOneAndTwoConcrete) another);
  }

  private boolean equalTo(int synthetic, ImmutableOneAndTwoConcrete another) {
    return one.equals(another.one)
        && two.equals(another.two);
  }

  /**
   * Computes a hash code from attributes: {@code one}, {@code two}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + one.hashCode();
    h += (h << 5) + two.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OneAndTwoConcrete} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OneAndTwoConcrete")
        .omitNullValues()
        .add("one", one)
        .add("two", two)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link OneAndTwoConcrete} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OneAndTwoConcrete instance
   */
  public static ImmutableOneAndTwoConcrete copyOf(OneAndTwoConcrete instance) {
    if (instance instanceof ImmutableOneAndTwoConcrete) {
      return (ImmutableOneAndTwoConcrete) instance;
    }
    return ImmutableOneAndTwoConcrete.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOneAndTwoConcrete ImmutableOneAndTwoConcrete}.
   * <pre>
   * ImmutableOneAndTwoConcrete.builder()
   *    .one(String) // required {@link OneAndTwoConcrete#one() one}
   *    .two(String) // required {@link OneAndTwoConcrete#two() two}
   *    .build();
   * </pre>
   * @return A new ImmutableOneAndTwoConcrete builder
   */
  public static ImmutableOneAndTwoConcrete.Builder builder() {
    return new ImmutableOneAndTwoConcrete.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOneAndTwoConcrete ImmutableOneAndTwoConcrete}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OneAndTwoConcrete", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ONE = 0x1L;
    private static final long INIT_BIT_TWO = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String one;
    private @Nullable String two;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.OneAndTwoConcrete} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OneAndTwoConcrete instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.OneAndTwo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OneAndTwo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.One} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(One instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.Two} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Two instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof OneAndTwoConcrete) {
        OneAndTwoConcrete instance = (OneAndTwoConcrete) object;
        if ((bits & 0x2L) == 0) {
          two(instance.two());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          one(instance.one());
          bits |= 0x1L;
        }
      }
      if (object instanceof OneAndTwo) {
        OneAndTwo instance = (OneAndTwo) object;
        if ((bits & 0x2L) == 0) {
          two(instance.two());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          one(instance.one());
          bits |= 0x1L;
        }
      }
      if (object instanceof One) {
        One instance = (One) object;
        if ((bits & 0x1L) == 0) {
          one(instance.one());
          bits |= 0x1L;
        }
      }
      if (object instanceof Two) {
        Two instance = (Two) object;
        if ((bits & 0x2L) == 0) {
          two(instance.two());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link OneAndTwoConcrete#one() one} attribute.
     * @param one The value for one 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder one(String one) {
      this.one = Objects.requireNonNull(one, "one");
      initBits &= ~INIT_BIT_ONE;
      return this;
    }

    /**
     * Initializes the value for the {@link OneAndTwoConcrete#two() two} attribute.
     * @param two The value for two 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder two(String two) {
      this.two = Objects.requireNonNull(two, "two");
      initBits &= ~INIT_BIT_TWO;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOneAndTwoConcrete ImmutableOneAndTwoConcrete}.
     * @return An immutable instance of OneAndTwoConcrete
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOneAndTwoConcrete build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOneAndTwoConcrete(one, two);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ONE) != 0) attributes.add("one");
      if ((initBits & INIT_BIT_TWO) != 0) attributes.add("two");
      return "Cannot build OneAndTwoConcrete, some of required attributes are not set " + attributes;
    }
  }
}
