package org.immutables.fixture.builder;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable;
import org.immutables.fixture.builder.attribute_builders.FirstPartyImmutableWithDifferentStyle;
import org.immutables.fixture.builder.functional.AttributeBuilderValueI;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GuavaAttributeBuilderParent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new GuavaAttributeBuilderParent.Builder()}.
 */
@Generated(from = "GuavaAttributeBuilderParent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGuavaAttributeBuilderParent
    extends GuavaAttributeBuilderParent {
  private final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable firstPartyImmutable;
  private final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle;
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable;
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive;
  private final @Nullable FirstPartyImmutable optionalFirstPartyImmutable;
  private final @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable nullableFirstPartyImmutable;
  private final ImmutableList<FirstPartyImmutable> firstPartyImmutableList;
  private final ImmutableList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> thirdPartyImmutableList;

  private ImmutableGuavaAttributeBuilderParent(
      org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable firstPartyImmutable,
      org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle,
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable,
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive,
      @Nullable FirstPartyImmutable optionalFirstPartyImmutable,
      @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable nullableFirstPartyImmutable,
      ImmutableList<FirstPartyImmutable> firstPartyImmutableList,
      ImmutableList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> thirdPartyImmutableList) {
    this.firstPartyImmutable = firstPartyImmutable;
    this.firstPartyImmutableWithDifferentStyle = firstPartyImmutableWithDifferentStyle;
    this.thirdPartyImmutable = thirdPartyImmutable;
    this.thirdPartyImmutableWithPrimitive = thirdPartyImmutableWithPrimitive;
    this.optionalFirstPartyImmutable = optionalFirstPartyImmutable;
    this.nullableFirstPartyImmutable = nullableFirstPartyImmutable;
    this.firstPartyImmutableList = firstPartyImmutableList;
    this.thirdPartyImmutableList = thirdPartyImmutableList;
  }

  /**
   * @return The value of the {@code firstPartyImmutable} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable firstPartyImmutable() {
    return firstPartyImmutable;
  }

  /**
   * @return The value of the {@code firstPartyImmutableWithDifferentStyle} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle() {
    return firstPartyImmutableWithDifferentStyle;
  }

  /**
   * @return The value of the {@code thirdPartyImmutable} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable() {
    return thirdPartyImmutable;
  }

  /**
   * @return The value of the {@code thirdPartyImmutableWithPrimitive} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive() {
    return thirdPartyImmutableWithPrimitive;
  }

  /**
   * @return The value of the {@code optionalFirstPartyImmutable} attribute
   */
  @Override
  public Optional<FirstPartyImmutable> optionalFirstPartyImmutable() {
    return Optional.ofNullable(optionalFirstPartyImmutable);
  }

  /**
   * @return The value of the {@code nullableFirstPartyImmutable} attribute
   */
  @Override
  public @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable nullableFirstPartyImmutable() {
    return nullableFirstPartyImmutable;
  }

  /**
   * @return The value of the {@code firstPartyImmutableList} attribute
   */
  @Override
  public ImmutableList<FirstPartyImmutable> firstPartyImmutableList() {
    return firstPartyImmutableList;
  }

  /**
   * @return The value of the {@code thirdPartyImmutableList} attribute
   */
  @Override
  public ImmutableList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> thirdPartyImmutableList() {
    return thirdPartyImmutableList;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuavaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for firstPartyImmutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGuavaAttributeBuilderParent withFirstPartyImmutable(FirstPartyImmutable value) {
    if (this.firstPartyImmutable == value) return this;
    org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable newValue = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
    return new ImmutableGuavaAttributeBuilderParent(
        newValue,
        this.firstPartyImmutableWithDifferentStyle,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable,
        this.firstPartyImmutableList,
        this.thirdPartyImmutableList);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuavaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for firstPartyImmutableWithDifferentStyle
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGuavaAttributeBuilderParent withFirstPartyImmutableWithDifferentStyle(FirstPartyImmutableWithDifferentStyle value) {
    if (this.firstPartyImmutableWithDifferentStyle == value) return this;
    org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle newValue = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
    return new ImmutableGuavaAttributeBuilderParent(
        this.firstPartyImmutable,
        newValue,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable,
        this.firstPartyImmutableList,
        this.thirdPartyImmutableList);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuavaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thirdPartyImmutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGuavaAttributeBuilderParent withThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
    if (this.thirdPartyImmutable == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable newValue = Objects.requireNonNull(value, "thirdPartyImmutable");
    return new ImmutableGuavaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        newValue,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable,
        this.firstPartyImmutableList,
        this.thirdPartyImmutableList);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuavaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thirdPartyImmutableWithPrimitive
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGuavaAttributeBuilderParent withThirdPartyImmutableWithPrimitive(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
    if (this.thirdPartyImmutableWithPrimitive == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive newValue = Objects.requireNonNull(value, "thirdPartyImmutableWithPrimitive");
    return new ImmutableGuavaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.thirdPartyImmutable,
        newValue,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable,
        this.firstPartyImmutableList,
        this.thirdPartyImmutableList);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link GuavaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} attribute.
   * @param value The value for optionalFirstPartyImmutable
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGuavaAttributeBuilderParent withOptionalFirstPartyImmutable(FirstPartyImmutable value) {
    @Nullable FirstPartyImmutable newValue = Objects.requireNonNull(value, "optionalFirstPartyImmutable");
    if (this.optionalFirstPartyImmutable == newValue) return this;
    return new ImmutableGuavaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableWithPrimitive,
        newValue,
        this.nullableFirstPartyImmutable,
        this.firstPartyImmutableList,
        this.thirdPartyImmutableList);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link GuavaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for optionalFirstPartyImmutable
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGuavaAttributeBuilderParent withOptionalFirstPartyImmutable(Optional<? extends FirstPartyImmutable> optional) {
    @Nullable FirstPartyImmutable value = optional.orElse(null);
    if (this.optionalFirstPartyImmutable == value) return this;
    return new ImmutableGuavaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableWithPrimitive,
        value,
        this.nullableFirstPartyImmutable,
        this.firstPartyImmutableList,
        this.thirdPartyImmutableList);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuavaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullableFirstPartyImmutable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGuavaAttributeBuilderParent withNullableFirstPartyImmutable(@Nullable FirstPartyImmutable value) {
    if (this.nullableFirstPartyImmutable == value) return this;
    @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable newValue = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
    return new ImmutableGuavaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        newValue,
        this.firstPartyImmutableList,
        this.thirdPartyImmutableList);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuavaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGuavaAttributeBuilderParent withFirstPartyImmutableList(FirstPartyImmutable... elements) {
    ImmutableList<FirstPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableGuavaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable,
        newValue,
        this.thirdPartyImmutableList);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuavaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of firstPartyImmutableList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGuavaAttributeBuilderParent withFirstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
    if (this.firstPartyImmutableList == elements) return this;
    ImmutableList<FirstPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableGuavaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable,
        newValue,
        this.thirdPartyImmutableList);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuavaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGuavaAttributeBuilderParent withThirdPartyImmutableList(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... elements) {
    ImmutableList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableGuavaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable,
        this.firstPartyImmutableList,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuavaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of thirdPartyImmutableList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGuavaAttributeBuilderParent withThirdPartyImmutableList(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> elements) {
    if (this.thirdPartyImmutableList == elements) return this;
    ImmutableList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableGuavaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable,
        this.firstPartyImmutableList,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGuavaAttributeBuilderParent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGuavaAttributeBuilderParent
        && equalTo(0, (ImmutableGuavaAttributeBuilderParent) another);
  }

  private boolean equalTo(int synthetic, ImmutableGuavaAttributeBuilderParent another) {
    return firstPartyImmutable.equals(another.firstPartyImmutable)
        && firstPartyImmutableWithDifferentStyle.equals(another.firstPartyImmutableWithDifferentStyle)
        && thirdPartyImmutable.equals(another.thirdPartyImmutable)
        && thirdPartyImmutableWithPrimitive.equals(another.thirdPartyImmutableWithPrimitive)
        && Objects.equals(optionalFirstPartyImmutable, another.optionalFirstPartyImmutable)
        && Objects.equals(nullableFirstPartyImmutable, another.nullableFirstPartyImmutable)
        && firstPartyImmutableList.equals(another.firstPartyImmutableList)
        && thirdPartyImmutableList.equals(another.thirdPartyImmutableList);
  }

  /**
   * Computes a hash code from attributes: {@code firstPartyImmutable}, {@code firstPartyImmutableWithDifferentStyle}, {@code thirdPartyImmutable}, {@code thirdPartyImmutableWithPrimitive}, {@code optionalFirstPartyImmutable}, {@code nullableFirstPartyImmutable}, {@code firstPartyImmutableList}, {@code thirdPartyImmutableList}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + firstPartyImmutable.hashCode();
    h += (h << 5) + firstPartyImmutableWithDifferentStyle.hashCode();
    h += (h << 5) + thirdPartyImmutable.hashCode();
    h += (h << 5) + thirdPartyImmutableWithPrimitive.hashCode();
    h += (h << 5) + Objects.hashCode(optionalFirstPartyImmutable);
    h += (h << 5) + Objects.hashCode(nullableFirstPartyImmutable);
    h += (h << 5) + firstPartyImmutableList.hashCode();
    h += (h << 5) + thirdPartyImmutableList.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuavaAttributeBuilderParent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GuavaAttributeBuilderParent")
        .omitNullValues()
        .add("firstPartyImmutable", firstPartyImmutable)
        .add("firstPartyImmutableWithDifferentStyle", firstPartyImmutableWithDifferentStyle)
        .add("thirdPartyImmutable", thirdPartyImmutable)
        .add("thirdPartyImmutableWithPrimitive", thirdPartyImmutableWithPrimitive)
        .add("optionalFirstPartyImmutable", optionalFirstPartyImmutable)
        .add("nullableFirstPartyImmutable", nullableFirstPartyImmutable)
        .add("firstPartyImmutableList", firstPartyImmutableList)
        .add("thirdPartyImmutableList", thirdPartyImmutableList)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GuavaAttributeBuilderParent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuavaAttributeBuilderParent instance
   */
  public static ImmutableGuavaAttributeBuilderParent copyOf(GuavaAttributeBuilderParent instance) {
    if (instance instanceof ImmutableGuavaAttributeBuilderParent) {
      return (ImmutableGuavaAttributeBuilderParent) instance;
    }
    return new GuavaAttributeBuilderParent.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableGuavaAttributeBuilderParent ImmutableGuavaAttributeBuilderParent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GuavaAttributeBuilderParent", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_FIRST_PARTY_IMMUTABLE = 0x1L;
    private static final long INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE = 0x2L;
    private static final long INIT_BIT_THIRD_PARTY_IMMUTABLE = 0x4L;
    private static final long INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder firstPartyImmutable;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyle;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder thirdPartyImmutable;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitive;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutable;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutable;
    private ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> firstPartyImmutableList = ImmutableList.builder();
    private ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> thirdPartyImmutableList = ImmutableList.builder();

    /**
     * Creates a builder for {@link ImmutableGuavaAttributeBuilderParent ImmutableGuavaAttributeBuilderParent} instances.
     * <pre>
     * new GuavaAttributeBuilderParent.Builder()
     *    .firstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // required {@link GuavaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable}
     *    .firstPartyImmutableWithDifferentStyle(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutableWithDifferentStyle) // required {@link GuavaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle}
     *    .thirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable) // required {@link GuavaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable}
     *    .thirdPartyImmutableWithPrimitive(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive) // required {@link GuavaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive}
     *    .optionalFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // optional {@link GuavaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable}
     *    .nullableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable | null) // nullable {@link GuavaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable}
     *    .addFirstPartyImmutable|addAllFirstPartyImmutableList(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // {@link GuavaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} elements
     *    .addThirdPartyImmutable|addAllThirdPartyImmutableList(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable) // {@link GuavaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} elements
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof GuavaAttributeBuilderParent.Builder)) {
        throw new UnsupportedOperationException("Use: new GuavaAttributeBuilderParent.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.functional.AttributeBuilderValueI} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder from(AttributeBuilderValueI instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.GuavaAttributeBuilderParent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder from(GuavaAttributeBuilderParent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof AttributeBuilderValueI) {
        AttributeBuilderValueI instance = (AttributeBuilderValueI) object;
        thirdPartyImmutable(instance.thirdPartyImmutable());
        firstPartyImmutableWithDifferentStyle(instance.firstPartyImmutableWithDifferentStyle());
        thirdPartyImmutableWithPrimitive(instance.thirdPartyImmutableWithPrimitive());
        firstPartyImmutable(instance.firstPartyImmutable());
        Optional<FirstPartyImmutable> optionalFirstPartyImmutableOptional = instance.optionalFirstPartyImmutable();
        if (optionalFirstPartyImmutableOptional.isPresent()) {
          optionalFirstPartyImmutable(optionalFirstPartyImmutableOptional);
        }
        @Nullable FirstPartyImmutable nullableFirstPartyImmutableValue = instance.nullableFirstPartyImmutable();
        if (nullableFirstPartyImmutableValue != null) {
          nullableFirstPartyImmutable(nullableFirstPartyImmutableValue);
        }
      }
      if (object instanceof GuavaAttributeBuilderParent) {
        GuavaAttributeBuilderParent instance = (GuavaAttributeBuilderParent) object;
        addAllThirdPartyImmutableList(instance.thirdPartyImmutableList());
        addAllFirstPartyImmutableList(instance.firstPartyImmutableList());
      }
    }

    /**
     * Initializes the value for the {@link GuavaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} attribute.
     * @param firstPartyImmutable The value for firstPartyImmutable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder firstPartyImmutable(FirstPartyImmutable firstPartyImmutable) {
      this.firstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutable));
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link GuavaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder firstPartyImmutableBuilder() {
      if (this.firstPartyImmutable == null) {
        this.firstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
      }
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;

      return this.firstPartyImmutable;
    }

    /**
     * Sets {@link GuavaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder firstPartyImmutableBuilder(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder firstPartyImmutable) {
      this.firstPartyImmutable = firstPartyImmutable;
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link GuavaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} attribute.
     * @param firstPartyImmutableWithDifferentStyle The value for firstPartyImmutableWithDifferentStyle 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder firstPartyImmutableWithDifferentStyle(FirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle) {
      this.firstPartyImmutableWithDifferentStyle = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(firstPartyImmutableWithDifferentStyle));
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link GuavaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyleBuilder() {
      if (this.firstPartyImmutableWithDifferentStyle == null) {
        this.firstPartyImmutableWithDifferentStyle = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder();
      }
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;

      return this.firstPartyImmutableWithDifferentStyle;
    }

    /**
     * Sets {@link GuavaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder firstPartyImmutableWithDifferentStyleBuilder(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyle) {
      this.firstPartyImmutableWithDifferentStyle = firstPartyImmutableWithDifferentStyle;
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link GuavaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} attribute.
     * @param thirdPartyImmutable The value for thirdPartyImmutable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder thirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable) {
      this.thirdPartyImmutable = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(Objects.requireNonNull(thirdPartyImmutable, "thirdPartyImmutable"));
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link GuavaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder thirdPartyImmutableBuilder() {
      if (this.thirdPartyImmutable == null) {
        this.thirdPartyImmutable = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;

      return this.thirdPartyImmutable;
    }

    /**
     * Sets {@link GuavaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder thirdPartyImmutableBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder thirdPartyImmutable) {
      this.thirdPartyImmutable = thirdPartyImmutable;
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link GuavaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} attribute.
     * @param thirdPartyImmutableWithPrimitive The value for thirdPartyImmutableWithPrimitive 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder thirdPartyImmutableWithPrimitive(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive) {
      this.thirdPartyImmutableWithPrimitive = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(Objects.requireNonNull(thirdPartyImmutableWithPrimitive, "thirdPartyImmutableWithPrimitive"));
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link GuavaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitiveBuilder() {
      if (this.thirdPartyImmutableWithPrimitive == null) {
        this.thirdPartyImmutableWithPrimitive = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;

      return this.thirdPartyImmutableWithPrimitive;
    }

    /**
     * Sets {@link GuavaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder thirdPartyImmutableWithPrimitiveBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitive) {
      this.thirdPartyImmutableWithPrimitive = thirdPartyImmutableWithPrimitive;
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the optional value {@link GuavaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to optionalFirstPartyImmutable.
     * @param optionalFirstPartyImmutable The value for optionalFirstPartyImmutable
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder optionalFirstPartyImmutable(FirstPartyImmutable optionalFirstPartyImmutable) {
      this.optionalFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(optionalFirstPartyImmutable, "optionalFirstPartyImmutable"));
      return (GuavaAttributeBuilderParent.Builder) this;
    }

      /**
       * Returns a builder for {@link GuavaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable}.
       *
       * Once called, the attribute builder field is set to a new instance of the builder.
       * If called more than once, returns the same builder instance.
       */
      public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutableBuilder() {
        if (this.optionalFirstPartyImmutable == null) {
          this.optionalFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
        }

        return this.optionalFirstPartyImmutable;
      }

      /**
       * Sets {@link GuavaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to the provided builder.
       */
      @CanIgnoreReturnValue 
      public final GuavaAttributeBuilderParent.Builder optionalFirstPartyImmutableBuilder(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutable) {
        this.optionalFirstPartyImmutable = optionalFirstPartyImmutable;
        return (GuavaAttributeBuilderParent.Builder) this;
      }

    /**
     * Initializes the optional value {@link GuavaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to optionalFirstPartyImmutable.
     * @param optionalFirstPartyImmutable The value for optionalFirstPartyImmutable
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder optionalFirstPartyImmutable(Optional<? extends FirstPartyImmutable> optionalFirstPartyImmutable) {
      this.optionalFirstPartyImmutable = convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(optionalFirstPartyImmutable.orElse(null));
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link GuavaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} attribute.
     * @param nullableFirstPartyImmutable The value for nullableFirstPartyImmutable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder nullableFirstPartyImmutable(@Nullable FirstPartyImmutable nullableFirstPartyImmutable) {
      this.nullableFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(nullableFirstPartyImmutable == null ? null : convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(nullableFirstPartyImmutable));
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link GuavaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutableBuilder() {
      if (this.nullableFirstPartyImmutable == null) {
        this.nullableFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
      }

      return this.nullableFirstPartyImmutable;
    }

    /**
     * Sets {@link GuavaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder nullableFirstPartyImmutableBuilder(@Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutable) {
      this.nullableFirstPartyImmutable = nullableFirstPartyImmutable;
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds one element to {@link GuavaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param element A firstPartyImmutableList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder addFirstPartyImmutable(FirstPartyImmutable element) {
      element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
      this.firstPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link GuavaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An array of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder addFirstPartyImmutableList(FirstPartyImmutable... elements) {
      for (FirstPartyImmutable element : elements) {
        element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
        this.firstPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(element, "firstPartyImmutableList element")));
      }
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds a new builder to the {@link GuavaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list and returns
     * the builder.
     */
    @CanIgnoreReturnValue 
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder addFirstPartyImmutableBuilder() {
      org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder builder = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
      this.firstPartyImmutableList.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link GuavaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An array of firstPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder addAllFirstPartyImmutableBuilders(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder... elements) {
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : elements) {
        this.firstPartyImmutableList.add(Objects.requireNonNull(element, "firstPartyImmutableList element"));
      }
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Gets the builder elements to {@link GuavaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> firstPartyImmutableBuilders() {
      return this.firstPartyImmutableList.build();
    }

    /**
     * Sets or replaces all elements for {@link GuavaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder firstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
      this.firstPartyImmutableList = ImmutableList.builder();
      return addAllFirstPartyImmutableList(elements);
    }

    /**
     * Adds elements to {@link GuavaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder addAllFirstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
      for (FirstPartyImmutable element : elements) {
        element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
        this.firstPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(element, "firstPartyImmutableList element")));
      }
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link GuavaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder addAllFirstPartyImmutableBuilders(Iterable<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> elements) {
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : elements) {
        this.firstPartyImmutableList.add(Objects.requireNonNull(element, "firstPartyImmutableList element"));
      }
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds one element to {@link GuavaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param element A thirdPartyImmutableList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder addThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element) {
      this.thirdPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link GuavaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An array of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder addThirdPartyImmutableList(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... elements) {
      this.thirdPartyImmutableList.addAll(convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(elements));
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds a new builder to the {@link GuavaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list and returns
     * the builder.
     */
    @CanIgnoreReturnValue 
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder addThirdPartyImmutableBuilder() {
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder builder = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder();
      this.thirdPartyImmutableList.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link GuavaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An array of thirdPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder addAllThirdPartyImmutableBuilders(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder... elements) {
      this.thirdPartyImmutableList.add(elements);
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Gets the builder elements to {@link GuavaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> thirdPartyImmutableBuilders() {
      return this.thirdPartyImmutableList.build();
    }

    /**
     * Sets or replaces all elements for {@link GuavaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder thirdPartyImmutableList(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> elements) {
      this.thirdPartyImmutableList = ImmutableList.builder();
      return addAllThirdPartyImmutableList(elements);
    }

    /**
     * Adds elements to {@link GuavaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder addAllThirdPartyImmutableList(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> elements) {
      this.thirdPartyImmutableList.addAll(convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(elements));
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link GuavaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final GuavaAttributeBuilderParent.Builder addAllThirdPartyImmutableBuilders(Iterable<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> elements) {
      this.thirdPartyImmutableList.addAll(elements);
      return (GuavaAttributeBuilderParent.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableGuavaAttributeBuilderParent ImmutableGuavaAttributeBuilderParent}.
     * @return An immutable instance of GuavaAttributeBuilderParent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGuavaAttributeBuilderParent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGuavaAttributeBuilderParent(
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutable),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(firstPartyImmutableWithDifferentStyle),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(thirdPartyImmutable),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(thirdPartyImmutableWithPrimitive),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(optionalFirstPartyImmutable),
          nullableFirstPartyImmutable == null ? null : convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(nullableFirstPartyImmutable),
          ImmutableList.copyOf(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutableList.build())),
          ImmutableList.copyOf(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(thirdPartyImmutableList.build())));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FIRST_PARTY_IMMUTABLE) != 0) attributes.add("firstPartyImmutable");
      if ((initBits & INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE) != 0) attributes.add("firstPartyImmutableWithDifferentStyle");
      if ((initBits & INIT_BIT_THIRD_PARTY_IMMUTABLE) != 0) attributes.add("thirdPartyImmutable");
      if ((initBits & INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE) != 0) attributes.add("thirdPartyImmutableWithPrimitive");
      return "Cannot build GuavaAttributeBuilderParent, some of required attributes are not set " + attributes;
    }



    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static FirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon builder) {
      if (builder == null) return null;
      return builder.doIIT();
    }

    @Nullable 
    private static FirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value).doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value).doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value);
    }

    private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> builderList) {
      ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderList) {
        list.add(element.build());
      }
      return list.build();
    }

    private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder... builderArray) {
      ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderArray) {
        list.add(element.build());
      }
      return list.build();
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable> valueList) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueList) {
        list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
      }
      return list.build();
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable... valueArray) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueArray) {
        list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
      }
      return list.build();
    }
    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> builderList) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderList) {
        list.add(element.doTheBuild());
      }
      return list.build();
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder... builderArray) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderArray) {
        list.add(element.doTheBuild());
      }
      return list.build();
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> valueList) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueList) {
        list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
      }
      return list.build();
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... valueArray) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueArray) {
        list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
      }
      return list.build();
    }
  }



  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static FirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon builder) {
    if (builder == null) return null;
    return builder.doIIT();
  }

  @Nullable 
  private static FirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value).doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value).doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value);
  }

  private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> builderList) {
    ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderList) {
      list.add(element.build());
    }
    return list.build();
  }

  private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder... builderArray) {
    ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderArray) {
      list.add(element.build());
    }
    return list.build();
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable> valueList) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueList) {
      list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
    }
    return list.build();
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable... valueArray) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueArray) {
      list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
    }
    return list.build();
  }
  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> builderList) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderList) {
      list.add(element.doTheBuild());
    }
    return list.build();
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder... builderArray) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderArray) {
      list.add(element.doTheBuild());
    }
    return list.build();
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> valueList) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueList) {
      list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
    }
    return list.build();
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... valueArray) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueArray) {
      list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
    }
    return list.build();
  }
}
