package org.immutables.fixture.builder;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AccessBuilderFields}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new AccessBuilderFields.Builder()}.
 */
@Generated(from = "AccessBuilderFields", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAccessBuilderFields extends AccessBuilderFields {
  private final int a;
  private final String b;
  private final EnumSet<AccessBuilderFields.T> c;
  private final EnumMap<AccessBuilderFields.T, String> d;
  private final ImmutableList<String> e;
  private final ImmutableMap<String, String> f;
  private final @Nullable String g;

  private ImmutableAccessBuilderFields(
      int a,
      String b,
      EnumSet<AccessBuilderFields.T> c,
      EnumMap<AccessBuilderFields.T, String> d,
      ImmutableList<String> e,
      ImmutableMap<String, String> f,
      @Nullable String g) {
    this.a = a;
    this.b = b;
    this.c = c;
    this.d = d;
    this.e = e;
    this.f = f;
    this.g = g;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  String b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  EnumSet<AccessBuilderFields.T> c() {
    return c;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  EnumMap<AccessBuilderFields.T, String> d() {
    return d;
  }

  /**
   * @return The value of the {@code e} attribute
   */
  @Override
  ImmutableList<String> e() {
    return e;
  }

  /**
   * @return The value of the {@code f} attribute
   */
  @Override
  ImmutableMap<String, String> f() {
    return f;
  }

  /**
   * @return The value of the {@code g} attribute
   */
  @Override
  Optional<String> g() {
    return Optional.ofNullable(g);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessBuilderFields#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessBuilderFields withA(int value) {
    if (this.a == value) return this;
    return new ImmutableAccessBuilderFields(value, this.b, this.c, this.d, this.e, this.f, this.g);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessBuilderFields#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessBuilderFields withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableAccessBuilderFields(this.a, newValue, this.c, this.d, this.e, this.f, this.g);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessBuilderFields#c() c} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessBuilderFields withC(EnumSet<AccessBuilderFields.T> value) {
    if (this.c == value) return this;
    EnumSet<AccessBuilderFields.T> newValue = Objects.requireNonNull(value, "c");
    return new ImmutableAccessBuilderFields(this.a, this.b, newValue, this.d, this.e, this.f, this.g);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessBuilderFields#d() d} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessBuilderFields withD(EnumMap<AccessBuilderFields.T, String> value) {
    if (this.d == value) return this;
    EnumMap<AccessBuilderFields.T, String> newValue = Objects.requireNonNull(value, "d");
    return new ImmutableAccessBuilderFields(this.a, this.b, this.c, newValue, this.e, this.f, this.g);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AccessBuilderFields#e() e}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccessBuilderFields withE(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAccessBuilderFields(this.a, this.b, this.c, this.d, newValue, this.f, this.g);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AccessBuilderFields#e() e}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of e elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccessBuilderFields withE(Iterable<String> elements) {
    if (this.e == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAccessBuilderFields(this.a, this.b, this.c, this.d, newValue, this.f, this.g);
  }

  /**
   * Copy the current immutable object by replacing the {@link AccessBuilderFields#f() f} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the f map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccessBuilderFields withF(Map<String, ? extends String> entries) {
    if (this.f == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableAccessBuilderFields(this.a, this.b, this.c, this.d, this.e, newValue, this.g);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AccessBuilderFields#g() g} attribute.
   * @param value The value for g
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccessBuilderFields withG(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "g");
    if (Objects.equals(this.g, newValue)) return this;
    return new ImmutableAccessBuilderFields(this.a, this.b, this.c, this.d, this.e, this.f, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AccessBuilderFields#g() g} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for g
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccessBuilderFields withG(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.g, value)) return this;
    return new ImmutableAccessBuilderFields(this.a, this.b, this.c, this.d, this.e, this.f, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAccessBuilderFields} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAccessBuilderFields
        && equalTo(0, (ImmutableAccessBuilderFields) another);
  }

  private boolean equalTo(int synthetic, ImmutableAccessBuilderFields another) {
    return a == another.a
        && b.equals(another.b)
        && c.equals(another.c)
        && d.equals(another.d)
        && e.equals(another.e)
        && f.equals(another.f)
        && Objects.equals(g, another.g);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}, {@code d}, {@code e}, {@code f}, {@code g}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    h += (h << 5) + d.hashCode();
    h += (h << 5) + e.hashCode();
    h += (h << 5) + f.hashCode();
    h += (h << 5) + Objects.hashCode(g);
    return h;
  }

  /**
   * Prints the immutable value {@code AccessBuilderFields} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AccessBuilderFields")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .add("d", d)
        .add("e", e)
        .add("f", f)
        .add("g", g)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AccessBuilderFields} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AccessBuilderFields instance
   */
  public static ImmutableAccessBuilderFields copyOf(AccessBuilderFields instance) {
    if (instance instanceof ImmutableAccessBuilderFields) {
      return (ImmutableAccessBuilderFields) instance;
    }
    return new AccessBuilderFields.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableAccessBuilderFields ImmutableAccessBuilderFields}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AccessBuilderFields", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long INIT_BIT_C = 0x4L;
    private static final long INIT_BIT_D = 0x8L;
    private long initBits = 0xfL;

    protected int a;
    protected @Nullable String b;
    protected @Nullable EnumSet<AccessBuilderFields.T> c;
    protected @Nullable EnumMap<AccessBuilderFields.T, String> d;
    protected ImmutableList.Builder<String> e = ImmutableList.builder();
    protected ImmutableMap.Builder<String, String> f = ImmutableMap.builder();
    protected @Nullable String g;

    /**
     * Creates a builder for {@link ImmutableAccessBuilderFields ImmutableAccessBuilderFields} instances.
     * <pre>
     * new AccessBuilderFields.Builder()
     *    .a(int) // required {@link AccessBuilderFields#a() a}
     *    .b(String) // required {@link AccessBuilderFields#b() b}
     *    .c(EnumSet&amp;lt;org.immutables.fixture.builder.AccessBuilderFields.T&amp;gt;) // required {@link AccessBuilderFields#c() c}
     *    .d(EnumMap&amp;lt;org.immutables.fixture.builder.AccessBuilderFields.T, String&amp;gt;) // required {@link AccessBuilderFields#d() d}
     *    .addE|addAllE(String) // {@link AccessBuilderFields#e() e} elements
     *    .putF|putAllF(String =&gt; String) // {@link AccessBuilderFields#f() f} mappings
     *    .g(String) // optional {@link AccessBuilderFields#g() g}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof AccessBuilderFields.Builder)) {
        throw new UnsupportedOperationException("Use: new AccessBuilderFields.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code AccessBuilderFields} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder from(AccessBuilderFields instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      c(instance.c());
      d(instance.d());
      addAllE(instance.e());
      putAllF(instance.f());
      Optional<String> gOptional = instance.g();
      if (gOptional.isPresent()) {
        g(gOptional);
      }
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Initializes the value for the {@link AccessBuilderFields#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Initializes the value for the {@link AccessBuilderFields#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Initializes the value for the {@link AccessBuilderFields#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder c(EnumSet<AccessBuilderFields.T> c) {
      this.c = Objects.requireNonNull(c, "c");
      initBits &= ~INIT_BIT_C;
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Initializes the value for the {@link AccessBuilderFields#d() d} attribute.
     * @param d The value for d 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder d(EnumMap<AccessBuilderFields.T, String> d) {
      this.d = Objects.requireNonNull(d, "d");
      initBits &= ~INIT_BIT_D;
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Adds one element to {@link AccessBuilderFields#e() e} list.
     * @param element A e element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder addE(String element) {
      this.e.add(element);
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Adds elements to {@link AccessBuilderFields#e() e} list.
     * @param elements An array of e elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder addE(String... elements) {
      this.e.add(elements);
      return (AccessBuilderFields.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link AccessBuilderFields#e() e} list.
     * @param elements An iterable of e elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder e(Iterable<String> elements) {
      this.e = ImmutableList.builder();
      return addAllE(elements);
    }

    /**
     * Adds elements to {@link AccessBuilderFields#e() e} list.
     * @param elements An iterable of e elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder addAllE(Iterable<String> elements) {
      this.e.addAll(elements);
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Put one entry to the {@link AccessBuilderFields#f() f} map.
     * @param key The key in the f map
     * @param value The associated value in the f map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder putF(String key, String value) {
      this.f.put(key, value);
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Put one entry to the {@link AccessBuilderFields#f() f} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder putF(Map.Entry<String, ? extends String> entry) {
      this.f.put(entry);
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link AccessBuilderFields#f() f} map. Nulls are not permitted
     * @param entries The entries that will be added to the f map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder f(Map<String, ? extends String> entries) {
      this.f = ImmutableMap.builder();
      return putAllF(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link AccessBuilderFields#f() f} map. Nulls are not permitted
     * @param entries The entries that will be added to the f map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder putAllF(Map<String, ? extends String> entries) {
      this.f.putAll(entries);
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Initializes the optional value {@link AccessBuilderFields#g() g} to g.
     * @param g The value for g
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder g(String g) {
      this.g = Objects.requireNonNull(g, "g");
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Initializes the optional value {@link AccessBuilderFields#g() g} to g.
     * @param g The value for g
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final AccessBuilderFields.Builder g(Optional<String> g) {
      this.g = g.orElse(null);
      return (AccessBuilderFields.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableAccessBuilderFields ImmutableAccessBuilderFields}.
     * @return An immutable instance of AccessBuilderFields
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAccessBuilderFields build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAccessBuilderFields(a, b, c, d, e.build(), f.build(), g);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      if ((initBits & INIT_BIT_D) != 0) attributes.add("d");
      return "Cannot build AccessBuilderFields, some of required attributes are not set " + attributes;
    }
  }
}
