package org.immutables.fixture.ast;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InstantiationGenerics.StringLeaf}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStringLeaf.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStringLeaf.of()}.
 */
@Generated(from = "InstantiationGenerics.StringLeaf", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStringLeaf implements InstantiationGenerics.StringLeaf {
  private final String value;

  private ImmutableStringLeaf(String value) {
    this.value = Objects.requireNonNull(value, "value");
  }

  private ImmutableStringLeaf(ImmutableStringLeaf original, String value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InstantiationGenerics.StringLeaf#value() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStringLeaf withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableStringLeaf(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStringLeaf} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStringLeaf
        && equalTo(0, (ImmutableStringLeaf) another);
  }

  private boolean equalTo(int synthetic, ImmutableStringLeaf another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StringLeaf} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StringLeaf")
        .omitNullValues()
        .add("value", value)
        .toString();
  }

  /**
   * Construct a new immutable {@code StringLeaf} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable StringLeaf instance
   */
  public static ImmutableStringLeaf of(String value) {
    return new ImmutableStringLeaf(value);
  }

  /**
   * Creates an immutable copy of a {@link InstantiationGenerics.StringLeaf} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StringLeaf instance
   */
  public static ImmutableStringLeaf copyOf(InstantiationGenerics.StringLeaf instance) {
    if (instance instanceof ImmutableStringLeaf) {
      return (ImmutableStringLeaf) instance;
    }
    return ImmutableStringLeaf.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStringLeaf ImmutableStringLeaf}.
   * <pre>
   * ImmutableStringLeaf.builder()
   *    .value(String) // required {@link InstantiationGenerics.StringLeaf#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableStringLeaf builder
   */
  public static ImmutableStringLeaf.Builder builder() {
    return new ImmutableStringLeaf.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStringLeaf ImmutableStringLeaf}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InstantiationGenerics.StringLeaf", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StringLeaf} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(InstantiationGenerics.StringLeaf instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link InstantiationGenerics.StringLeaf#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStringLeaf ImmutableStringLeaf}.
     * @return An immutable instance of StringLeaf
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStringLeaf build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStringLeaf(null, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build StringLeaf, some of required attributes are not set " + attributes;
    }
  }
}
