package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.A1;
import nonimmutables.A2;
import nonimmutables.B1;
import nonimmutables.C1;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractValForPass}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValForPass.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code new ImmutableValForPass()}.
 */
@Generated(from = "AbstractValForPass", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@A1
@A2
final class ImmutableValForPass extends AbstractValForPass {
  private final int p1;

  /**
   * Construct a new immutable {@code ValForPass} instance.
   * @param p1 The value for the {@code p1} attribute
   */
  @B1
  @C1
  public ImmutableValForPass(@A1 @A2 int p1) {
    this.p1 = p1;
  }

  /**
   * @return The value of the {@code p1} attribute
   */
  @A1
  @A2
  @Override
  int p1() {
    return p1;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractValForPass#p1() p1} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for p1
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValForPass withP1(int value) {
    if (this.p1 == value) return this;
    return new ImmutableValForPass(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValForPass} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValForPass
        && equalTo(0, (ImmutableValForPass) another);
  }

  private boolean equalTo(int synthetic, ImmutableValForPass another) {
    return p1 == another.p1;
  }

  /**
   * Computes a hash code from attributes: {@code p1}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + p1;
    return h;
  }

  /**
   * Prints the immutable value {@code ValForPass} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValForPass")
        .omitNullValues()
        .add("p1", p1)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AbstractValForPass} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValForPass instance
   */
  public static ImmutableValForPass copyOf(AbstractValForPass instance) {
    if (instance instanceof ImmutableValForPass) {
      return (ImmutableValForPass) instance;
    }
    return ImmutableValForPass.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValForPass ImmutableValForPass}.
   * <pre>
   * ImmutableValForPass.builder()
   *    .p1(int) // required {@link AbstractValForPass#p1() p1}
   *    .build();
   * </pre>
   * @return A new ImmutableValForPass builder
   */
  public static ImmutableValForPass.Builder builder() {
    return new ImmutableValForPass.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValForPass ImmutableValForPass}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractValForPass", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_P1 = 0x1L;
    private long initBits = 0x1L;

    private int p1;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractValForPass} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractValForPass instance) {
      Objects.requireNonNull(instance, "instance");
      p1(instance.p1());
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractValForPass#p1() p1} attribute.
     * @param p1 The value for p1 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder p1(int p1) {
      this.p1 = p1;
      initBits &= ~INIT_BIT_P1;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValForPass ImmutableValForPass}.
     * @return An immutable instance of ValForPass
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValForPass build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValForPass(p1);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_P1) != 0) attributes.add("p1");
      return "Cannot build ValForPass, some of required attributes are not set " + attributes;
    }
  }
}
