package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NoDefault}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNoDefault.builder()}.
 */
@Generated(from = "NoDefault", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableNoDefault implements NoDefault {
  private final int value;
  private final String otherValue;

  private ImmutableNoDefault(int value, String otherValue) {
    this.value = value;
    this.otherValue = otherValue;
  }

  /** {@inheritDoc} */
  @Override
  public Class<? extends Annotation> annotationType() {
    return NoDefault.class;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public int value() {
    return value;
  }

  /**
   * @return The value of the {@code otherValue} attribute
   */
  @Override
  public String otherValue() {
    return otherValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoDefault#value() value} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoDefault withValue(int value) {
    if (this.value == value) return this;
    return new ImmutableNoDefault(value, this.otherValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoDefault#otherValue() otherValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for otherValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoDefault withOtherValue(String value) {
    String newValue = Objects.requireNonNull(value, "otherValue");
    if (this.otherValue.equals(newValue)) return this;
    return new ImmutableNoDefault(this.value, newValue);
  }

  /**
   * This instance is equal to any implementation of the {@link ImmutableNoDefault} type with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof NoDefault
        && equalTo(0, (NoDefault) another);
  }

  private boolean equalTo(int synthetic, NoDefault another) {
    return value == another.value()
        && otherValue.equals(another.otherValue());
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code otherValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 0;
    h += 127 * "value".hashCode() ^ value;
    h += 127 * "otherValue".hashCode() ^ otherValue.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NoDefault} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("@NoDefault")
        .omitNullValues()
        .add("value", value)
        .add("otherValue", otherValue)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NoDefault} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NoDefault instance
   */
  public static ImmutableNoDefault copyOf(NoDefault instance) {
    if (instance instanceof ImmutableNoDefault) {
      return (ImmutableNoDefault) instance;
    }
    return ImmutableNoDefault.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNoDefault ImmutableNoDefault}.
   * <pre>
   * ImmutableNoDefault.builder()
   *    .value(int) // required {@link NoDefault#value() value}
   *    .otherValue(String) // required {@link NoDefault#otherValue() otherValue}
   *    .build();
   * </pre>
   * @return A new ImmutableNoDefault builder
   */
  public static ImmutableNoDefault.Builder builder() {
    return new ImmutableNoDefault.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNoDefault ImmutableNoDefault}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NoDefault", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_OTHER_VALUE = 0x2L;
    private long initBits = 0x3L;

    private int value;
    private @Nullable String otherValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NoDefault} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NoDefault instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      otherValue(instance.otherValue());
      return this;
    }

    /**
     * Initializes the value for the {@link NoDefault#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(int value) {
      this.value = value;
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link NoDefault#otherValue() otherValue} attribute.
     * @param otherValue The value for otherValue 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder otherValue(String otherValue) {
      this.otherValue = Objects.requireNonNull(otherValue, "otherValue");
      initBits &= ~INIT_BIT_OTHER_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNoDefault ImmutableNoDefault}.
     * @return An immutable instance of NoDefault
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNoDefault build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNoDefault(value, otherValue);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_OTHER_VALUE) != 0) attributes.add("otherValue");
      return "Cannot build NoDefault, some of required attributes are not set " + attributes;
    }
  }
}
