package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DoNotPropagateTypeAnnotation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDoNotPropagateTypeAnnotation.builder()}.
 */
@Generated(from = "DoNotPropagateTypeAnnotation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDoNotPropagateTypeAnnotation
    implements DoNotPropagateTypeAnnotation {
  private final int a;
  private final Object b;
  private final java.lang.@TypeUseOnly String c;

  private ImmutableDoNotPropagateTypeAnnotation(int a, Object b, java.lang.@TypeUseOnly String c) {
    this.a = a;
    this.b = b;
    this.c = c;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public Object b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public java.lang.@TypeUseOnly String c() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DoNotPropagateTypeAnnotation#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDoNotPropagateTypeAnnotation withA(int value) {
    if (this.a == value) return this;
    return new ImmutableDoNotPropagateTypeAnnotation(value, this.b, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DoNotPropagateTypeAnnotation#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDoNotPropagateTypeAnnotation withB(Object value) {
    if (this.b == value) return this;
    Object newValue = Objects.requireNonNull(value, "b");
    return new ImmutableDoNotPropagateTypeAnnotation(this.a, newValue, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DoNotPropagateTypeAnnotation#c() c} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDoNotPropagateTypeAnnotation withC(java.lang.@TypeUseOnly String value) {
    java.lang.@TypeUseOnly String newValue = Objects.requireNonNull(value, "c");
    if (this.c.equals(newValue)) return this;
    return new ImmutableDoNotPropagateTypeAnnotation(this.a, this.b, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDoNotPropagateTypeAnnotation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDoNotPropagateTypeAnnotation
        && equalTo(0, (ImmutableDoNotPropagateTypeAnnotation) another);
  }

  private boolean equalTo(int synthetic, ImmutableDoNotPropagateTypeAnnotation another) {
    return a == another.a
        && b.equals(another.b)
        && c.equals(another.c);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DoNotPropagateTypeAnnotation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DoNotPropagateTypeAnnotation")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DoNotPropagateTypeAnnotation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DoNotPropagateTypeAnnotation instance
   */
  public static ImmutableDoNotPropagateTypeAnnotation copyOf(DoNotPropagateTypeAnnotation instance) {
    if (instance instanceof ImmutableDoNotPropagateTypeAnnotation) {
      return (ImmutableDoNotPropagateTypeAnnotation) instance;
    }
    return ImmutableDoNotPropagateTypeAnnotation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDoNotPropagateTypeAnnotation ImmutableDoNotPropagateTypeAnnotation}.
   * <pre>
   * ImmutableDoNotPropagateTypeAnnotation.builder()
   *    .a(int) // required {@link DoNotPropagateTypeAnnotation#a() a}
   *    .b(Object) // required {@link DoNotPropagateTypeAnnotation#b() b}
   *    .c(@org.immutables.fixture.annotation.TypeUseOnly String) // required {@link DoNotPropagateTypeAnnotation#c() c}
   *    .build();
   * </pre>
   * @return A new ImmutableDoNotPropagateTypeAnnotation builder
   */
  public static ImmutableDoNotPropagateTypeAnnotation.Builder builder() {
    return new ImmutableDoNotPropagateTypeAnnotation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDoNotPropagateTypeAnnotation ImmutableDoNotPropagateTypeAnnotation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DoNotPropagateTypeAnnotation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long INIT_BIT_C = 0x4L;
    private long initBits = 0x7L;

    private int a;
    private @Nullable Object b;
    private @Nullable java.lang.@TypeUseOnly String c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DoNotPropagateTypeAnnotation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DoNotPropagateTypeAnnotation instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      c(instance.c());
      return this;
    }

    /**
     * Initializes the value for the {@link DoNotPropagateTypeAnnotation#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link DoNotPropagateTypeAnnotation#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(Object b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link DoNotPropagateTypeAnnotation#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(java.lang.@TypeUseOnly String c) {
      this.c = Objects.requireNonNull(c, "c");
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDoNotPropagateTypeAnnotation ImmutableDoNotPropagateTypeAnnotation}.
     * @return An immutable instance of DoNotPropagateTypeAnnotation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDoNotPropagateTypeAnnotation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDoNotPropagateTypeAnnotation(a, b, c);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      return "Cannot build DoNotPropagateTypeAnnotation, some of required attributes are not set " + attributes;
    }
  }
}
