package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _UnderNaming}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UnderNaming.builder()}.
 */
@Generated(from = "_UnderNaming", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class UnderNaming implements org.immutables.fixture._UnderNaming {

  private UnderNaming(UnderNaming.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code UnderNaming} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UnderNaming
        && equalTo(0, (UnderNaming) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, UnderNaming another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1463217384;
  }

  /**
   * Prints the immutable value {@code UnderNaming}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnderNaming{}";
  }

  /**
   * Creates an immutable copy of a {@link _UnderNaming} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UnderNaming instance
   */
  public static UnderNaming copyOf(_UnderNaming instance) {
    if (instance instanceof UnderNaming) {
      return (UnderNaming) instance;
    }
    return UnderNaming.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UnderNaming UnderNaming}.
   * <pre>
   * UnderNaming.builder()
   *    .build();
   * </pre>
   * @return A new UnderNaming builder
   */
  public static UnderNaming.Builder builder() {
    return new UnderNaming.Builder();
  }

  /**
   * Builds instances of type {@link UnderNaming UnderNaming}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UnderNaming", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code _UnderNaming} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(_UnderNaming instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link UnderNaming UnderNaming}.
     * @return An immutable instance of UnderNaming
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnderNaming build() {
      return new UnderNaming(this);
    }
  }
}
