package org.immutables.fixture;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.fixture.subpack.SillySubstructure;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

/**
 * A {@code SillyStructureWithIdRepository} provides type-safe access for storing and retrieving documents
 * from the MongoDB collection {@code "sillyStructureWithId"}.
 */
@Generated(from = "SillyStructureWithId", generator = "Repositories")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@ThreadSafe
public class SillyStructureWithIdRepository extends Repositories.Repository<SillyStructureWithId> {
  private static final String DOCUMENT_COLLECTION_NAME = "sillyStructureWithId";

  private final Serialization serialization;
  private final Criteria anyCriteria;

  /**
   * Constructs a {@link SillyStructureWithId} repository using {@link RepositorySetup configuration}.
   * @param configuration The repository configuration
   */
  public SillyStructureWithIdRepository(RepositorySetup configuration) {
    super(configuration, DOCUMENT_COLLECTION_NAME, SillyStructureWithId.class);
    this.serialization = new Serialization(codecRegistry(), fieldNamingStrategy());
    this.anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());
  }

  /**
   * Inserts a single document into the collection.
   * @param document The sillyStructureWithId to insert
   * @return A future representing the number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(SillyStructureWithId document) {
    return super.doInsert(ImmutableList.of(document));
  }

  /**
   * Insert documents into the collection.
   * @param documents The documents to insert
   * @return A future representing the number of inserted documents if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(Iterable<? extends SillyStructureWithId> documents) {
    return super.doInsert(ImmutableList.copyOf(documents));
  }

  /**
   * Finds all documents. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch all} or other operations.
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findAll() {
    return find(criteria());
  }

  /**
   * Find documents by the criteria expressed as a JSON string. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch} or {@link Finder#fetchFirst() fetch} operations.
   * @param jsonCriteria A JSON string for native criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(String jsonCriteria) {
    return new Finder(this, Support.jsonQuery(jsonCriteria));
  }

  /**
   * Find documents by the {@link SillyStructureWithId#id() id} identity attribute. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchFirst() fetch} or {@link Finder#fetchAll() fetchAll} read operations.
   * You can also use {@link Finder#andModifyFirst() modify}, {@link Finder#andReplaceFirst(SillyStructureWithId) replace}
   * or {@link Finder#deleteFirst() delete} operations to update / delete the document.
   * @param id The exact {@code id} value
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findById(java.lang.String id) {
    return find(criteria().id(id));
  }

  /**
   * Update or insert a document, matched by the identifier value of the 'id' attribute.
   * @param document The sillyStructureWithId to upsert
   * @return A future representing the of number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> upsert(SillyStructureWithId document) {
    Criteria byId = criteria().id(document.id());
    return super.doUpsert(byId.constraint, document);
  }

  /**
   * Find a document by the given {@link SillyStructureWithIdRepository#criteria() criteria}. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch}  operations.
   * You can also use {@link Finder#andModifyFirst() modify} or {@link Finder#deleteFirst() delete}
   * operations to update / delete the document(s).
   * @param criteria The search criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(Criteria criteria) {
    return new Finder(this, criteria.constraint);
  }

  /**
   * The finder object used to proceed with find operations via the
   * {@link Finder#fetchAll()}, {@link Finder#fetchFirst()}, {@link Finder#andModifyFirst()}, or {@link Finder#deleteFirst()} methods.
   * Configure exclusion and sort ordering for results using the family of {@code exclude*()} and {@code orderBy*()} attribute-specific methods.
   * @see SillyStructureWithIdRepository#find(Criteria)
   */
  @Generated(from = "SillyStructureWithId", generator = "Repositories")
  @NotThreadSafe
  public static final class Finder extends Repositories.FinderWithDelete<SillyStructureWithId, Finder> {
    private final Serialization serialization;

    private Finder(SillyStructureWithIdRepository repository, Constraints.ConstraintHost criteria) {
      super(repository);
      this.criteria = criteria;
      this.serialization = repository.serialization;
    }

    /**
     * Order by {@link SillyStructureWithId#id() id} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#id() id} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderById() {
      ordering = ordering.equal(serialization.idName, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#id() id} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#id() id} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByIdDesceding() {
      ordering = ordering.equal(serialization.idName, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#attr1() attr1} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#attr1() attr1} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByAttr1() {
      ordering = ordering.equal(serialization.attr1Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#attr1() attr1} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#attr1() attr1} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByAttr1Desceding() {
      ordering = ordering.equal(serialization.attr1Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#flag2() flag2} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#flag2() flag2} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByFlag2() {
      ordering = ordering.equal(serialization.flag2Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#flag2() flag2} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#flag2() flag2} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByFlag2Desceding() {
      ordering = ordering.equal(serialization.flag2Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#opt3() opt3} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#opt3() opt3} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByOpt3() {
      ordering = ordering.equal(serialization.opt3Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#opt3() opt3} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#opt3() opt3} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByOpt3Desceding() {
      ordering = ordering.equal(serialization.opt3Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#opt5() opt5} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#opt5() opt5} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByOpt5() {
      ordering = ordering.equal(serialization.opt5Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#opt5() opt5} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#opt5() opt5} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByOpt5Desceding() {
      ordering = ordering.equal(serialization.opt5Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#very4() very4} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#very4() very4} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByVery4() {
      ordering = ordering.equal(serialization.very4Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#very4() very4} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#very4() very4} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByVery4Desceding() {
      ordering = ordering.equal(serialization.very4Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#wet5() wet5} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#wet5() wet5} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByWet5() {
      ordering = ordering.equal(serialization.wet5Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#wet5() wet5} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#wet5() wet5} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByWet5Desceding() {
      ordering = ordering.equal(serialization.wet5Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#subs6() subs6} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#subs6() subs6} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderBySubs6() {
      ordering = ordering.equal(serialization.subs6Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#subs6() subs6} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#subs6() subs6} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderBySubs6Desceding() {
      ordering = ordering.equal(serialization.subs6Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#nest7() nest7} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#nest7() nest7} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByNest7() {
      ordering = ordering.equal(serialization.nest7Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#nest7() nest7} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#nest7() nest7} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByNest7Desceding() {
      ordering = ordering.equal(serialization.nest7Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#tup3() tup3} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#tup3() tup3} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByTup3() {
      ordering = ordering.equal(serialization.tup3Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#tup3() tup3} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#tup3() tup3} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByTup3Desceding() {
      ordering = ordering.equal(serialization.tup3Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#int9() int9} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#int9() int9} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByInt9() {
      ordering = ordering.equal(serialization.int9Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyStructureWithId#int9() int9} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyStructureWithId#int9() int9} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByInt9Desceding() {
      ordering = ordering.equal(serialization.int9Name, false, -1);
      return this;
    }

    /**
     * Exclude the {@link SillyStructureWithId#opt3() opt3} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeOpt3() {
      exclusion = exclusion.equal(serialization.opt3Name, false, -1);
      return this;
    }

    /**
     * Exclude the {@link SillyStructureWithId#opt5() opt5} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeOpt5() {
      exclusion = exclusion.equal(serialization.opt5Name, false, -1);
      return this;
    }

    /**
     * Exclude the {@link SillyStructureWithId#subs6() subs6} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeSubs6() {
      exclusion = exclusion.equal(serialization.subs6Name, false, -1);
      return this;
    }

    /**
     * Exclude the {@link SillyStructureWithId#tup3() tup3} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeTup3() {
      exclusion = exclusion.equal(serialization.tup3Name, false, -1);
      return this;
    }

    /**
     * Turn a find operation into an atomic {@link DBCollection#findAndModify(DBObject, DBObject, DBObject, boolean, DBObject, boolean, boolean) findAndModify}
     * operation. Use the family of {@code set*()}, {@code unset*()}, {@code add*()}, {@code remove*()}, {@code put*()}m and {@code init*()}
     * (and other attribute-specific) methods to describe the modification.
     * @return A modifier object to complete the {@code findAndModify} operation
     */
    @CheckReturnValue
    public Modifier andModifyFirst() {
      return new Modifier((SillyStructureWithIdRepository) repository, criteria, ordering, exclusion);
    }

    /**
     * Used to replace in-place existing version of the document
     */
    @CheckReturnValue
    public Replacer andReplaceFirst(SillyStructureWithId document) {
      return new Replacer((SillyStructureWithIdRepository) repository, document, criteria, ordering);
    }
  }

  /**
   * Update the set of {@code "sillyStructureWithId"} documents.
   * @param criteria The search criteria for update
   * @return An updater object that will be used to complete the update.
   */
  @CheckReturnValue
  public Updater update(Criteria criteria) {
    return new Updater(this, criteria);
  }

  /**
   * {@link #update(Criteria) Given} the criteria updater describes how to perform
   * update operations on sets of documents.
   */
  @Generated(from = "SillyStructureWithId", generator = "Repositories")
  @NotThreadSafe
  public static final class Updater extends Repositories.Updater<SillyStructureWithId> {
    private final Serialization serialization;

    private Updater(SillyStructureWithIdRepository repository, Criteria criteria) {
      super(repository);
      this.criteria = criteria.constraint;
      this.serialization = repository.serialization;
    }

    /**
     * Specify a new value for the {@code id} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code id} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setId(java.lang.String value) {
      setFields = setFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code id} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code id} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initId(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }


    /**
     * Specify a new value for the {@code attr1} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code attr1} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setAttr1(java.lang.String value) {
      setFields = setFields.equal(serialization.attr1Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code attr1} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code attr1} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initAttr1(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.attr1Name, false, Support.writable(value));
      return this;
    }


    /**
     * Specify a new value for the {@code flag2} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code flag2} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setFlag2(boolean value) {
      setFields = setFields.equal(serialization.flag2Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code flag2} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code flag2} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initFlag2(boolean value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.flag2Name, false, Support.writable(value));
      return this;
    }


    /**
     * Clear the optional {@code opt3} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to {@code null}
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater emptyOpt3() {
      setFields = setFields.equal(serialization.opt3Name, false, null);
      return this;
    }

    /**
     * Specify a new value for the {@code opt3} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code opt3} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setOpt3(int value) {
      setFields = setFields.equal(serialization.opt3Name, false, Support.writable(serialization.opt3Encoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code opt3} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code opt3} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initOpt3(int value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.opt3Name, false, Support.writable(serialization.opt3Encoder, value));
      return this;
    }


    /**
     * Clear the optional {@code opt5} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to {@code null}
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater emptyOpt5() {
      setFields = setFields.equal(serialization.opt5Name, false, null);
      return this;
    }

    /**
     * Specify a new value for the {@code opt5} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code opt5} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setOpt5(int value) {
      setFields = setFields.equal(serialization.opt5Name, false, Support.writable(serialization.opt5Encoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code opt5} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code opt5} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initOpt5(int value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.opt5Name, false, Support.writable(serialization.opt5Encoder, value));
      return this;
    }


    /**
     * Specify a new value for the {@code very4} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code very4} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setVery4(long value) {
      setFields = setFields.equal(serialization.very4Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code very4} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code very4} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initVery4(long value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.very4Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an increment amount for the {@code very4} attribute. If the document is to inserted
     * and no initial value has been provided, then {@code 0} will be the default value and the increment will adjust it.
     * <p>
     * Corresponds to the MongoDB {@code $inc} operator.
     * @param increment An amount by which to increment the {@code very4} attribute (may be negative)
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater incrementVery4(long increment) {
      incrementFields = incrementFields.equal(serialization.very4Name, false, increment);
      return this;
    }

    /**
     * Specify a new value for the {@code wet5} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code wet5} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setWet5(double value) {
      setFields = setFields.equal(serialization.wet5Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code wet5} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code wet5} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initWet5(double value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.wet5Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an increment amount for the {@code wet5} attribute. If the document is to inserted
     * and no initial value has been provided, then {@code 0} will be the default value and the increment will adjust it.
     * <p>
     * Corresponds to the MongoDB {@code $inc} operator.
     * @param increment An amount by which to increment the {@code wet5} attribute (may be negative)
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater incrementWet5(double increment) {
      incrementFields = incrementFields.equal(serialization.wet5Name, false, increment);
      return this;
    }

    /**
     * Clear the {@code subs6} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to empty array
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearSubs6() {
      setFields = setFields.equal(serialization.subs6Name, false, ImmutableList.<Object>of());
      return this;
    }

    /**
     * Remove a value from the {@code subs6} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeSubs6(SillySubstructure value) {
      pullFields = pullFields.equal(serialization.subs6Name, false, Support.writable(serialization.subs6Encoder, value));
      return this;
    }

    /**
     * Add a value to the {@code subs6} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addSubs6(SillySubstructure value) {
      pushFields = pushFields.equal(serialization.subs6Name, false, Support.writable(serialization.subs6Encoder, value));
      return this;
    }

    /**
     * Override all values of {@code subs6} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setSubs6(Iterable<? extends SillySubstructure> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (SillySubstructure value : values) {
         wrappedValues.add(Support.writable(serialization.subs6Encoder, value));
       }

       setFields = setFields.equal(serialization.subs6Name, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code subs6} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllSubs6(Iterable<? extends SillySubstructure> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (SillySubstructure value : values) {
        wrappedValues.add(Support.writable(serialization.subs6Encoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.subs6Name, false, v);
      return this;
    }


    /**
     * Specify a new value for the {@code nest7} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code nest7} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setNest7(SillySubstructure value) {
      setFields = setFields.equal(serialization.nest7Name, false, Support.writable(serialization.nest7Encoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code nest7} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code nest7} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initNest7(SillySubstructure value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.nest7Name, false, Support.writable(serialization.nest7Encoder, value));
      return this;
    }


    /**
     * Clear the optional {@code tup3} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to {@code null}
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater emptyTup3() {
      setFields = setFields.equal(serialization.tup3Name, false, null);
      return this;
    }

    /**
     * Specify a new value for the {@code tup3} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code tup3} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setTup3(SillyTuplie value) {
      setFields = setFields.equal(serialization.tup3Name, false, Support.writable(serialization.tup3Encoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code tup3} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code tup3} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initTup3(SillyTuplie value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.tup3Name, false, Support.writable(serialization.tup3Encoder, value));
      return this;
    }


    /**
     * Specify a new value for the {@code int9} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code int9} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setInt9(int value) {
      setFields = setFields.equal(serialization.int9Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code int9} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code int9} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initInt9(int value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.int9Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an increment amount for the {@code int9} attribute. If the document is to inserted
     * and no initial value has been provided, then {@code 0} will be the default value and the increment will adjust it.
     * <p>
     * Corresponds to the MongoDB {@code $inc} operator.
     * @param increment An amount by which to increment the {@code int9} attribute (may be negative)
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater incrementInt9(int increment) {
      incrementFields = incrementFields.equal(serialization.int9Name, false, increment);
      return this;
    }
  }

  @Generated(from = "SillyStructureWithId", generator = "Repositories")
  @NotThreadSafe
  public static final class Modifier extends Repositories.Modifier<SillyStructureWithId, Modifier> {
    private final Serialization serialization;

    private Modifier(
        SillyStructureWithIdRepository repository,
        Constraints.ConstraintHost criteria,
        Constraints.Constraint ordering,
        Constraints.Constraint exclusion) {
      super(repository);
      this.serialization = repository.serialization;
      this.criteria = criteria;
      this.ordering = ordering;
      this.exclusion = exclusion;
    }

    /**
     * Specify a new value for the {@code id} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code id} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setId(java.lang.String value) {
      setFields = setFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code id} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code id} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initId(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }


    /**
     * Specify a new value for the {@code attr1} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code attr1} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setAttr1(java.lang.String value) {
      setFields = setFields.equal(serialization.attr1Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code attr1} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code attr1} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initAttr1(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.attr1Name, false, Support.writable(value));
      return this;
    }


    /**
     * Specify a new value for the {@code flag2} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code flag2} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setFlag2(boolean value) {
      setFields = setFields.equal(serialization.flag2Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code flag2} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code flag2} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initFlag2(boolean value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.flag2Name, false, Support.writable(value));
      return this;
    }


    /**
     * Clear the optional {@code opt3} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to {@code null}
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier emptyOpt3() {
      setFields = setFields.equal(serialization.opt3Name, false, null);
      return this;
    }

    /**
     * Specify a new value for the {@code opt3} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code opt3} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setOpt3(int value) {
      setFields = setFields.equal(serialization.opt3Name, false, Support.writable(serialization.opt3Encoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code opt3} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code opt3} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initOpt3(int value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.opt3Name, false, Support.writable(serialization.opt3Encoder, value));
      return this;
    }


    /**
     * Clear the optional {@code opt5} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to {@code null}
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier emptyOpt5() {
      setFields = setFields.equal(serialization.opt5Name, false, null);
      return this;
    }

    /**
     * Specify a new value for the {@code opt5} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code opt5} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setOpt5(int value) {
      setFields = setFields.equal(serialization.opt5Name, false, Support.writable(serialization.opt5Encoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code opt5} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code opt5} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initOpt5(int value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.opt5Name, false, Support.writable(serialization.opt5Encoder, value));
      return this;
    }


    /**
     * Specify a new value for the {@code very4} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code very4} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setVery4(long value) {
      setFields = setFields.equal(serialization.very4Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code very4} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code very4} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initVery4(long value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.very4Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an increment amount for the {@code very4} attribute. If the document is to inserted
     * and no initial value has been provided, then {@code 0} will be the default value and the increment will adjust it.
     * <p>
     * Corresponds to the MongoDB {@code $inc} operator.
     * @param increment An amount by which to increment the {@code very4} attribute (may be negative)
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier incrementVery4(long increment) {
      incrementFields = incrementFields.equal(serialization.very4Name, false, increment);
      return this;
    }

    /**
     * Specify a new value for the {@code wet5} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code wet5} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setWet5(double value) {
      setFields = setFields.equal(serialization.wet5Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code wet5} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code wet5} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initWet5(double value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.wet5Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an increment amount for the {@code wet5} attribute. If the document is to inserted
     * and no initial value has been provided, then {@code 0} will be the default value and the increment will adjust it.
     * <p>
     * Corresponds to the MongoDB {@code $inc} operator.
     * @param increment An amount by which to increment the {@code wet5} attribute (may be negative)
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier incrementWet5(double increment) {
      incrementFields = incrementFields.equal(serialization.wet5Name, false, increment);
      return this;
    }

    /**
     * Clear the {@code subs6} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to empty array
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearSubs6() {
      setFields = setFields.equal(serialization.subs6Name, false, ImmutableList.<Object>of());
      return this;
    }

    /**
     * Remove a value from the {@code subs6} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeSubs6(SillySubstructure value) {
      pullFields = pullFields.equal(serialization.subs6Name, false, Support.writable(serialization.subs6Encoder, value));
      return this;
    }

    /**
     * Add a value to the {@code subs6} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addSubs6(SillySubstructure value) {
      pushFields = pushFields.equal(serialization.subs6Name, false, Support.writable(serialization.subs6Encoder, value));
      return this;
    }

    /**
     * Override all values of {@code subs6} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setSubs6(Iterable<? extends SillySubstructure> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (SillySubstructure value : values) {
         wrappedValues.add(Support.writable(serialization.subs6Encoder, value));
       }

       setFields = setFields.equal(serialization.subs6Name, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code subs6} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllSubs6(Iterable<? extends SillySubstructure> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (SillySubstructure value : values) {
        wrappedValues.add(Support.writable(serialization.subs6Encoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.subs6Name, false, v);
      return this;
    }


    /**
     * Specify a new value for the {@code nest7} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code nest7} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setNest7(SillySubstructure value) {
      setFields = setFields.equal(serialization.nest7Name, false, Support.writable(serialization.nest7Encoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code nest7} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code nest7} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initNest7(SillySubstructure value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.nest7Name, false, Support.writable(serialization.nest7Encoder, value));
      return this;
    }


    /**
     * Clear the optional {@code tup3} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to {@code null}
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier emptyTup3() {
      setFields = setFields.equal(serialization.tup3Name, false, null);
      return this;
    }

    /**
     * Specify a new value for the {@code tup3} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code tup3} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setTup3(SillyTuplie value) {
      setFields = setFields.equal(serialization.tup3Name, false, Support.writable(serialization.tup3Encoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code tup3} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code tup3} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initTup3(SillyTuplie value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.tup3Name, false, Support.writable(serialization.tup3Encoder, value));
      return this;
    }


    /**
     * Specify a new value for the {@code int9} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code int9} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setInt9(int value) {
      setFields = setFields.equal(serialization.int9Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code int9} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code int9} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initInt9(int value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.int9Name, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an increment amount for the {@code int9} attribute. If the document is to inserted
     * and no initial value has been provided, then {@code 0} will be the default value and the increment will adjust it.
     * <p>
     * Corresponds to the MongoDB {@code $inc} operator.
     * @param increment An amount by which to increment the {@code int9} attribute (may be negative)
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier incrementInt9(int increment) {
      incrementFields = incrementFields.equal(serialization.int9Name, false, increment);
      return this;
    }
  }

  @Generated(from = "SillyStructureWithId", generator = "Repositories")
  @NotThreadSafe
  public static final class Replacer extends Repositories.Replacer<SillyStructureWithId, Replacer> {
    protected Replacer(SillyStructureWithIdRepository repository, SillyStructureWithId document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
      super(repository, document, criteria, ordering);
    }
  }

  /**
   * {@link DBCollection#createIndex(DBObject, DBObject) Ensure an index} on collection sillyStructureWithId by one or
   * more attributes using the family of {@code with*()} attribute-specific methods.
   * While indexes will usually be maintained by special administration scripts, for simple cases it is convenient
   * to ensure an index on application startup.
   * @see Indexer#named(String)
   * @see Indexer#unique()
   * @return An indexer object to be completed with the {@link Indexer#ensure()} operation.
   */
  @CheckReturnValue
  public Indexer index() {
    return new Indexer(this);
  }

  /**
   * An indexer used to create an index on the {@code "sillyStructureWithId"} collection if it does not exist by one or more attributes.
   * @see DBCollection#createIndex(DBObject, DBObject)
   */
  @Generated(from = "SillyStructureWithId", generator = "Repositories")
  @NotThreadSafe
  public static final class Indexer extends Repositories.Indexer<SillyStructureWithId, Indexer> {
    private final Serialization serialization;

    private Indexer(SillyStructureWithIdRepository repository) {
      super(repository);
      this.serialization = repository.serialization;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#id() id}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withId() {
      fields = fields.equal(serialization.idName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#id() id}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withIdDesceding() {
      fields = fields.equal(serialization.idName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#attr1() attr1}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withAttr1() {
      fields = fields.equal(serialization.attr1Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#attr1() attr1}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withAttr1Desceding() {
      fields = fields.equal(serialization.attr1Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#flag2() flag2}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withFlag2() {
      fields = fields.equal(serialization.flag2Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#flag2() flag2}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withFlag2Desceding() {
      fields = fields.equal(serialization.flag2Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#opt3() opt3}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withOpt3() {
      fields = fields.equal(serialization.opt3Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#opt3() opt3}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withOpt3Desceding() {
      fields = fields.equal(serialization.opt3Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#opt5() opt5}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withOpt5() {
      fields = fields.equal(serialization.opt5Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#opt5() opt5}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withOpt5Desceding() {
      fields = fields.equal(serialization.opt5Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#very4() very4}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withVery4() {
      fields = fields.equal(serialization.very4Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#very4() very4}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withVery4Desceding() {
      fields = fields.equal(serialization.very4Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#wet5() wet5}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withWet5() {
      fields = fields.equal(serialization.wet5Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#wet5() wet5}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withWet5Desceding() {
      fields = fields.equal(serialization.wet5Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#subs6() subs6}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withSubs6() {
      fields = fields.equal(serialization.subs6Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#subs6() subs6}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withSubs6Desceding() {
      fields = fields.equal(serialization.subs6Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#nest7() nest7}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withNest7() {
      fields = fields.equal(serialization.nest7Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#nest7() nest7}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withNest7Desceding() {
      fields = fields.equal(serialization.nest7Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#tup3() tup3}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withTup3() {
      fields = fields.equal(serialization.tup3Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#tup3() tup3}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withTup3Desceding() {
      fields = fields.equal(serialization.tup3Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#int9() int9}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withInt9() {
      fields = fields.equal(serialization.int9Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyStructureWithId#int9() int9}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withInt9Desceding() {
      fields = fields.equal(serialization.int9Name, false, -1);
      return this;
    }
  }

  /**
   * Search criteria.
   * Returns an initial object to create criteria by invoking methods that describe attribute specific constraints.
   * @return An empty immutable criteria
   */
  public Criteria criteria() {
    return anyCriteria;
  }

  @Beta
  Bson toBson(Criteria criteria) {
    return Support.convertToBson(criteria.constraint);
  }

  /**
   * {@code SillyStructureWithIdRepository.Criteria} is a SillyStructureWithId document search query.
   * Call methods on the criteria to add constraints for search queries.
   */
  @Generated(from = "SillyStructureWithId", generator = "Repositories")
  @Immutable
  @SuppressWarnings("unchecked")
  public static final class Criteria extends Repositories.Criteria {
    private final Constraints.Constraint constraint;
    private final Serialization serialization;

    Criteria(Serialization serialization, Constraints.Constraint constraint) {
      this.constraint = constraint;
      this.serialization = serialization;
    }

    public Criteria id(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.idName, false, Support.writable(value)));
    }

    public Criteria idNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.idName, true, Support.writable(value)));
    }

    public Criteria idIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, false, wrappedValues));
    }

    public Criteria idIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, false, values));
    }

    public Criteria idNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, true, wrappedValues));
    }

    public Criteria idNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, true, values));
    }

    public Criteria idStartsWith(String prefix) {
      return new Criteria(serialization, constraint.match(serialization.idName, false, Constraints.prefixPatternOf(prefix)));
    }

    public Criteria idMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.idName, false, pattern));
    }

    public Criteria idNotMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.idName, true, pattern));
    }

    public Criteria idGreaterThan(java.lang.String lower) {
      return idIn(Range.greaterThan(lower));
    }

    public Criteria idLessThan(java.lang.String upper) {
      return idIn(Range.lessThan(upper));
    }

    public Criteria idAtMost(java.lang.String upperInclusive) {
      return idIn(Range.atMost(upperInclusive));
    }

    public Criteria idAtLeast(java.lang.String lowerInclusive) {
      return idIn(Range.atLeast(lowerInclusive));
    }

    public Criteria idIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.idName, false, Support.writable(range)));
    }

    public Criteria idNotIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.idName, true, Support.writable(range)));
    }

    public Criteria attr1(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.attr1Name, false, Support.writable(value)));
    }

    public Criteria attr1Not(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.attr1Name, true, Support.writable(value)));
    }

    public Criteria attr1In(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.attr1Name, false, wrappedValues));
    }

    public Criteria attr1In(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.attr1Name, false, values));
    }

    public Criteria attr1NotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.attr1Name, true, wrappedValues));
    }

    public Criteria attr1NotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.attr1Name, true, values));
    }

    public Criteria attr1StartsWith(String prefix) {
      return new Criteria(serialization, constraint.match(serialization.attr1Name, false, Constraints.prefixPatternOf(prefix)));
    }

    public Criteria attr1Matches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.attr1Name, false, pattern));
    }

    public Criteria attr1NotMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.attr1Name, true, pattern));
    }

    public Criteria attr1GreaterThan(java.lang.String lower) {
      return attr1In(Range.greaterThan(lower));
    }

    public Criteria attr1LessThan(java.lang.String upper) {
      return attr1In(Range.lessThan(upper));
    }

    public Criteria attr1AtMost(java.lang.String upperInclusive) {
      return attr1In(Range.atMost(upperInclusive));
    }

    public Criteria attr1AtLeast(java.lang.String lowerInclusive) {
      return attr1In(Range.atLeast(lowerInclusive));
    }

    public Criteria attr1In(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.attr1Name, false, Support.writable(range)));
    }

    public Criteria attr1NotIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.attr1Name, true, Support.writable(range)));
    }

    public Criteria flag2(boolean value) {
      return new Criteria(serialization, constraint.equal(serialization.flag2Name, false, Support.writable(value)));
    }

    public Criteria opt3(int value) {
      return new Criteria(serialization, constraint.equal(serialization.opt3Name, false, Support.writable(serialization.opt3Encoder, value)));
    }

    public Criteria opt3Not(int value) {
      return new Criteria(serialization, constraint.equal(serialization.opt3Name, true, Support.writable(serialization.opt3Encoder, value)));
    }

    public Criteria opt3In(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(serialization.opt3Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.opt3Name, false, wrappedValues));
    }

    public Criteria opt3In(int first, int second, int... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.opt3Encoder, first));
      values.add(Support.writable(serialization.opt3Encoder, second));
      for (int value : rest) {
        values.add(Support.writable(serialization.opt3Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.opt3Name, false, values));
    }

    public Criteria opt3NotIn(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(serialization.opt3Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.opt3Name, true, wrappedValues));
    }

    public Criteria opt3NotIn(int first, int second, int... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.opt3Encoder, first));
      values.add(Support.writable(serialization.opt3Encoder, second));
      for (int value : rest) {
        values.add(Support.writable(serialization.opt3Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.opt3Name, true, values));
    }

    public Criteria opt3Present() {
      return new Criteria(serialization, constraint.present(serialization.opt3Name, false));
    }

    public Criteria opt3Absent() {
      return new Criteria(serialization, constraint.present(serialization.opt3Name, true));
    }

    public Criteria opt3GreaterThan(int lower) {
      return opt3In(Range.greaterThan(lower));
    }

    public Criteria opt3LessThan(int upper) {
      return opt3In(Range.lessThan(upper));
    }

    public Criteria opt3AtMost(int upperInclusive) {
      return opt3In(Range.atMost(upperInclusive));
    }

    public Criteria opt3AtLeast(int lowerInclusive) {
      return opt3In(Range.atLeast(lowerInclusive));
    }

    public Criteria opt3In(Range<java.lang.Integer> range) {
      return new Criteria(serialization, constraint.range(serialization.opt3Name, false, Support.writable(serialization.opt3Encoder, range)));
    }

    public Criteria opt3NotIn(Range<java.lang.Integer> range) {
      return new Criteria(serialization, constraint.range(serialization.opt3Name, true, Support.writable(serialization.opt3Encoder, range)));
    }

    public Criteria opt5(int value) {
      return new Criteria(serialization, constraint.equal(serialization.opt5Name, false, Support.writable(serialization.opt5Encoder, value)));
    }

    public Criteria opt5Not(int value) {
      return new Criteria(serialization, constraint.equal(serialization.opt5Name, true, Support.writable(serialization.opt5Encoder, value)));
    }

    public Criteria opt5In(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(serialization.opt5Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.opt5Name, false, wrappedValues));
    }

    public Criteria opt5In(int first, int second, int... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.opt5Encoder, first));
      values.add(Support.writable(serialization.opt5Encoder, second));
      for (int value : rest) {
        values.add(Support.writable(serialization.opt5Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.opt5Name, false, values));
    }

    public Criteria opt5NotIn(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(serialization.opt5Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.opt5Name, true, wrappedValues));
    }

    public Criteria opt5NotIn(int first, int second, int... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.opt5Encoder, first));
      values.add(Support.writable(serialization.opt5Encoder, second));
      for (int value : rest) {
        values.add(Support.writable(serialization.opt5Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.opt5Name, true, values));
    }

    public Criteria opt5Present() {
      return new Criteria(serialization, constraint.present(serialization.opt5Name, false));
    }

    public Criteria opt5Absent() {
      return new Criteria(serialization, constraint.present(serialization.opt5Name, true));
    }

    public Criteria opt5GreaterThan(int lower) {
      return opt5In(Range.greaterThan(lower));
    }

    public Criteria opt5LessThan(int upper) {
      return opt5In(Range.lessThan(upper));
    }

    public Criteria opt5AtMost(int upperInclusive) {
      return opt5In(Range.atMost(upperInclusive));
    }

    public Criteria opt5AtLeast(int lowerInclusive) {
      return opt5In(Range.atLeast(lowerInclusive));
    }

    public Criteria opt5In(Range<java.lang.Integer> range) {
      return new Criteria(serialization, constraint.range(serialization.opt5Name, false, Support.writable(serialization.opt5Encoder, range)));
    }

    public Criteria opt5NotIn(Range<java.lang.Integer> range) {
      return new Criteria(serialization, constraint.range(serialization.opt5Name, true, Support.writable(serialization.opt5Encoder, range)));
    }

    public Criteria very4(long value) {
      return new Criteria(serialization, constraint.equal(serialization.very4Name, false, Support.writable(value)));
    }

    public Criteria very4Not(long value) {
      return new Criteria(serialization, constraint.equal(serialization.very4Name, true, Support.writable(value)));
    }

    public Criteria very4In(Iterable<Long> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Long value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.very4Name, false, wrappedValues));
    }

    public Criteria very4In(long first, long second, long... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (long value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.very4Name, false, values));
    }

    public Criteria very4NotIn(Iterable<Long> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Long value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.very4Name, true, wrappedValues));
    }

    public Criteria very4NotIn(long first, long second, long... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (long value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.very4Name, true, values));
    }

    public Criteria very4GreaterThan(long lower) {
      return very4In(Range.greaterThan(lower));
    }

    public Criteria very4LessThan(long upper) {
      return very4In(Range.lessThan(upper));
    }

    public Criteria very4AtMost(long upperInclusive) {
      return very4In(Range.atMost(upperInclusive));
    }

    public Criteria very4AtLeast(long lowerInclusive) {
      return very4In(Range.atLeast(lowerInclusive));
    }

    public Criteria very4In(Range<Long> range) {
      return new Criteria(serialization, constraint.range(serialization.very4Name, false, Support.writable(range)));
    }

    public Criteria very4NotIn(Range<Long> range) {
      return new Criteria(serialization, constraint.range(serialization.very4Name, true, Support.writable(range)));
    }

    public Criteria wet5(double value) {
      return new Criteria(serialization, constraint.equal(serialization.wet5Name, false, Support.writable(value)));
    }

    public Criteria wet5Not(double value) {
      return new Criteria(serialization, constraint.equal(serialization.wet5Name, true, Support.writable(value)));
    }

    public Criteria wet5In(Iterable<Double> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Double value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.wet5Name, false, wrappedValues));
    }

    public Criteria wet5In(double first, double second, double... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (double value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.wet5Name, false, values));
    }

    public Criteria wet5NotIn(Iterable<Double> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Double value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.wet5Name, true, wrappedValues));
    }

    public Criteria wet5NotIn(double first, double second, double... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (double value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.wet5Name, true, values));
    }

    public Criteria wet5GreaterThan(double lower) {
      return wet5In(Range.greaterThan(lower));
    }

    public Criteria wet5LessThan(double upper) {
      return wet5In(Range.lessThan(upper));
    }

    public Criteria wet5AtMost(double upperInclusive) {
      return wet5In(Range.atMost(upperInclusive));
    }

    public Criteria wet5AtLeast(double lowerInclusive) {
      return wet5In(Range.atLeast(lowerInclusive));
    }

    public Criteria wet5In(Range<Double> range) {
      return new Criteria(serialization, constraint.range(serialization.wet5Name, false, Support.writable(range)));
    }

    public Criteria wet5NotIn(Range<Double> range) {
      return new Criteria(serialization, constraint.range(serialization.wet5Name, true, Support.writable(range)));
    }

    public Criteria subs6Empty() {
      return new Criteria(serialization, constraint.size(serialization.subs6Name, false, 0));
    }

    public Criteria subs6NonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.subs6Name, true, 0));
    }

    public Criteria subs6Size(int size) {
      return new Criteria(serialization, constraint.size(serialization.subs6Name, false, size));
    }

    public Criteria subs6Contains(SillySubstructure value) {
      return new Criteria(serialization, constraint.equal(serialization.subs6Name, false, Support.writable(serialization.subs6Encoder, value)));
    }

    public Criteria subs6ContainsAll(Iterable<SillySubstructure> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (SillySubstructure value : values) {
        wrappedValues.add(Support.writable(serialization.subs6Encoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.subs6Name, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    public Criteria nest7(SillySubstructure value) {
      return new Criteria(serialization, constraint.equal(serialization.nest7Name, false, Support.writable(serialization.nest7Encoder, value)));
    }

    public Criteria nest7Not(SillySubstructure value) {
      return new Criteria(serialization, constraint.equal(serialization.nest7Name, true, Support.writable(serialization.nest7Encoder, value)));
    }

    public Criteria nest7In(Iterable<SillySubstructure> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (SillySubstructure value : values) {
        wrappedValues.add(Support.writable(serialization.nest7Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.nest7Name, false, wrappedValues));
    }

    public Criteria nest7In(SillySubstructure first, SillySubstructure second, SillySubstructure... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.nest7Encoder, first));
      values.add(Support.writable(serialization.nest7Encoder, second));
      for (SillySubstructure value : rest) {
        values.add(Support.writable(serialization.nest7Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.nest7Name, false, values));
    }

    public Criteria nest7NotIn(Iterable<SillySubstructure> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (SillySubstructure value : values) {
        wrappedValues.add(Support.writable(serialization.nest7Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.nest7Name, true, wrappedValues));
    }

    public Criteria nest7NotIn(SillySubstructure first, SillySubstructure second, SillySubstructure... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.nest7Encoder, first));
      values.add(Support.writable(serialization.nest7Encoder, second));
      for (SillySubstructure value : rest) {
        values.add(Support.writable(serialization.nest7Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.nest7Name, true, values));
    }

    public Criteria tup3(SillyTuplie value) {
      return new Criteria(serialization, constraint.equal(serialization.tup3Name, false, Support.writable(serialization.tup3Encoder, value)));
    }

    public Criteria tup3Not(SillyTuplie value) {
      return new Criteria(serialization, constraint.equal(serialization.tup3Name, true, Support.writable(serialization.tup3Encoder, value)));
    }

    public Criteria tup3In(Iterable<SillyTuplie> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (SillyTuplie value : values) {
        wrappedValues.add(Support.writable(serialization.tup3Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.tup3Name, false, wrappedValues));
    }

    public Criteria tup3In(SillyTuplie first, SillyTuplie second, SillyTuplie... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.tup3Encoder, first));
      values.add(Support.writable(serialization.tup3Encoder, second));
      for (SillyTuplie value : rest) {
        values.add(Support.writable(serialization.tup3Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.tup3Name, false, values));
    }

    public Criteria tup3NotIn(Iterable<SillyTuplie> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (SillyTuplie value : values) {
        wrappedValues.add(Support.writable(serialization.tup3Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.tup3Name, true, wrappedValues));
    }

    public Criteria tup3NotIn(SillyTuplie first, SillyTuplie second, SillyTuplie... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.tup3Encoder, first));
      values.add(Support.writable(serialization.tup3Encoder, second));
      for (SillyTuplie value : rest) {
        values.add(Support.writable(serialization.tup3Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.tup3Name, true, values));
    }

    public Criteria tup3Present() {
      return new Criteria(serialization, constraint.present(serialization.tup3Name, false));
    }

    public Criteria tup3Absent() {
      return new Criteria(serialization, constraint.present(serialization.tup3Name, true));
    }

    public Criteria int9(int value) {
      return new Criteria(serialization, constraint.equal(serialization.int9Name, false, Support.writable(value)));
    }

    public Criteria int9Not(int value) {
      return new Criteria(serialization, constraint.equal(serialization.int9Name, true, Support.writable(value)));
    }

    public Criteria int9In(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.int9Name, false, wrappedValues));
    }

    public Criteria int9In(int first, int second, int... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (int value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.int9Name, false, values));
    }

    public Criteria int9NotIn(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.int9Name, true, wrappedValues));
    }

    public Criteria int9NotIn(int first, int second, int... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (int value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.int9Name, true, values));
    }

    public Criteria int9GreaterThan(int lower) {
      return int9In(Range.greaterThan(lower));
    }

    public Criteria int9LessThan(int upper) {
      return int9In(Range.lessThan(upper));
    }

    public Criteria int9AtMost(int upperInclusive) {
      return int9In(Range.atMost(upperInclusive));
    }

    public Criteria int9AtLeast(int lowerInclusive) {
      return int9In(Range.atLeast(lowerInclusive));
    }

    public Criteria int9In(Range<java.lang.Integer> range) {
      return new Criteria(serialization, constraint.range(serialization.int9Name, false, Support.writable(range)));
    }

    public Criteria int9NotIn(Range<java.lang.Integer> range) {
      return new Criteria(serialization, constraint.range(serialization.int9Name, true, Support.writable(range)));
    }

    @Override
    public Criteria or() {
      return new Criteria(serialization, constraint.disjunction());
    }

    public Criteria with(Criteria criteria) {
      return new Criteria(serialization, criteria.constraint.accept(constraint));
    }

    @Override
    public String toString() {
      return "SillyStructureWithIdRepository.criteria(" + Support.stringify(constraint) + ")";
    }
  }

  @Generated(from = "SillyStructureWithId", generator = "Repositories")
  private static class Serialization {
    final Encoder<java.lang.Integer> opt3Encoder;
    final Encoder<java.lang.Integer> opt5Encoder;
    final Encoder<SillySubstructure> subs6Encoder;
    final Encoder<SillySubstructure> nest7Encoder;
    final Encoder<SillyTuplie> tup3Encoder;
    final CodecRegistry registry;
    final String idName;
    final String attr1Name;
    final String flag2Name;
    final String opt3Name;
    final String opt5Name;
    final String very4Name;
    final String wet5Name;
    final String subs6Name;
    final String nest7Name;
    final String tup3Name;
    final String int9Name;

    Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
      this.registry = registry;
      this.opt3Encoder = this.registry.get(java.lang.Integer.class);
      this.opt5Encoder = this.registry.get(java.lang.Integer.class);
      this.subs6Encoder = this.registry.get(SillySubstructure.class);
      this.nest7Encoder = this.registry.get(SillySubstructure.class);
      this.tup3Encoder = this.registry.get(SillyTuplie.class);
      this.idName = "_id";
      this.attr1Name = translateName(fieldNamingStrategy, "attr1");
      this.flag2Name = translateName(fieldNamingStrategy, "flag2");
      this.opt3Name = translateName(fieldNamingStrategy, "opt3");
      this.opt5Name = translateName(fieldNamingStrategy, "opt5");
      this.very4Name = translateName(fieldNamingStrategy, "very4");
      this.wet5Name = translateName(fieldNamingStrategy, "wet5");
      this.subs6Name = translateName(fieldNamingStrategy, "subs6");
      this.nest7Name = translateName(fieldNamingStrategy, "nest7");
      this.tup3Name = translateName(fieldNamingStrategy, "tup3");
      this.int9Name = translateName(fieldNamingStrategy, "int9");
    }

    @Generated(from = "SillyStructureWithId", generator = "Repositories")
    static final class SillyStructureWithIdNamingFields {
      public java.lang.String id;
      public java.lang.String attr1;
      public boolean flag2;
      public Optional<java.lang.Integer> opt3;
      public Option<java.lang.Integer> opt5;
      public long very4;
      public double wet5;
      public List<SillySubstructure> subs6;
      public SillySubstructure nest7;
      public Optional<SillyTuplie> tup3;
      public int int9;
    }

    private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
      try {
        return fieldNamingStrategy.translateName(
            SillyStructureWithIdNamingFields.class.getField(fieldName));
      } catch (NoSuchFieldException noSuchField) {
        throw new AssertionError(noSuchField);
      }
    }
  }
}
