package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link IncludeHashCode IncludeHashCode} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableIncludeHashCode is not thread-safe</em>
 * @see ImmutableIncludeHashCode
 */
@Generated(from = "IncludeHashCode", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "IncludeHashCode"})
@NotThreadSafe
public final class ModifiableIncludeHashCode extends IncludeHashCode {

  private ModifiableIncludeHashCode() {}

  /**
   * Construct a modifiable instance of {@code IncludeHashCode}.
   * @return A new modifiable instance
   */
  public static ModifiableIncludeHashCode create() {
    return new ModifiableIncludeHashCode();
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableIncludeHashCode clear() {
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link IncludeHashCode} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableIncludeHashCode from(IncludeHashCode instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableIncludeHashCode) {
      from((ModifiableIncludeHashCode) instance);
      return this;
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link IncludeHashCode} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableIncludeHashCode from(ModifiableIncludeHashCode instance) {
    Objects.requireNonNull(instance, "instance");
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableIncludeHashCode ImmutableIncludeHashCode}.
   * @return An immutable instance of IncludeHashCode
   */
  public final ImmutableIncludeHashCode toImmutable() {
    return ImmutableIncludeHashCode.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableIncludeHashCode} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableIncludeHashCode)) return false;
    ModifiableIncludeHashCode other = (ModifiableIncludeHashCode) another;
    return equalTo(other);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(ModifiableIncludeHashCode another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return (IncludeHashCode.class.hashCode() + 42);
  }

  /**
   * Generates a string representation of this {@code IncludeHashCode}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableIncludeHashCode{}";
  }
}
