package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WitherDerived}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWitherDerived.builder()}.
 */
@Generated(from = "WitherDerived", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWitherDerived extends WitherDerived {
  private final int set;
  private transient final int derived;

  private ImmutableWitherDerived(int set) {
    this.set = set;
    this.derived = super.derived();
  }

  /**
   * @return The value of the {@code set} attribute
   */
  @Override
  int set() {
    return set;
  }

  /**
   * @return The computed-at-construction value of the {@code derived} attribute
   */
  @Override
  int derived() {
    return derived;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WitherDerived#set() set} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for set
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWitherDerived withSet(int value) {
    if (this.set == value) return this;
    return new ImmutableWitherDerived(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWitherDerived} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWitherDerived
        && equalTo(0, (ImmutableWitherDerived) another);
  }

  private boolean equalTo(int synthetic, ImmutableWitherDerived another) {
    return set == another.set
        && derived == another.derived;
  }

  /**
   * Computes a hash code from attributes: {@code set}, {@code derived}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + set;
    h += (h << 5) + derived;
    return h;
  }

  /**
   * Prints the immutable value {@code WitherDerived} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WitherDerived")
        .omitNullValues()
        .add("set", set)
        .add("derived", derived)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link WitherDerived} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WitherDerived instance
   */
  public static ImmutableWitherDerived copyOf(WitherDerived instance) {
    if (instance instanceof ImmutableWitherDerived) {
      return (ImmutableWitherDerived) instance;
    }
    return ImmutableWitherDerived.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWitherDerived ImmutableWitherDerived}.
   * <pre>
   * ImmutableWitherDerived.builder()
   *    .set(int) // required {@link WitherDerived#set() set}
   *    .build();
   * </pre>
   * @return A new ImmutableWitherDerived builder
   */
  public static ImmutableWitherDerived.Builder builder() {
    return new ImmutableWitherDerived.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWitherDerived ImmutableWitherDerived}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WitherDerived", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SET = 0x1L;
    private long initBits = 0x1L;

    private int set;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WitherDerived} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WitherDerived instance) {
      Objects.requireNonNull(instance, "instance");
      set(instance.set());
      return this;
    }

    /**
     * Initializes the value for the {@link WitherDerived#set() set} attribute.
     * @param set The value for set 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder set(int set) {
      this.set = set;
      initBits &= ~INIT_BIT_SET;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWitherDerived ImmutableWitherDerived}.
     * @return An immutable instance of WitherDerived
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWitherDerived build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWitherDerived(set);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SET) != 0) attributes.add("set");
      return "Cannot build WitherDerived, some of required attributes are not set " + attributes;
    }
  }
}
