package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javaslang.control.Option;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Wildcards}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWildcards.builder()}.
 */
@Generated(from = "Wildcards", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWildcards implements Wildcards {
  private final List<?> wilcards;
  private final Option<? super String> option;

  private ImmutableWildcards(List<?> wilcards, Option<? super String> option) {
    this.wilcards = wilcards;
    this.option = option;
  }

  /**
   * @return The value of the {@code wilcards} attribute
   */
  @Override
  public List<?> wilcards() {
    return wilcards;
  }

  /**
   * @return The value of the {@code option} attribute
   */
  @Override
  public Option<? super String> option() {
    return option;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Wildcards#wilcards() wilcards} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wilcards
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWildcards withWilcards(List<?> value) {
    if (this.wilcards == value) return this;
    List<?> newValue = Objects.requireNonNull(value, "wilcards");
    return new ImmutableWildcards(newValue, this.option);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Wildcards#option() option} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for option
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWildcards withOption(Option<? super String> value) {
    Option<? super String> newValue = Objects.requireNonNull(value, "option");
    if (this.option.equals(newValue)) return this;
    return new ImmutableWildcards(this.wilcards, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWildcards} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWildcards
        && equalTo(0, (ImmutableWildcards) another);
  }

  private boolean equalTo(int synthetic, ImmutableWildcards another) {
    return wilcards.equals(another.wilcards)
        && option.equals(another.option);
  }

  /**
   * Computes a hash code from attributes: {@code wilcards}, {@code option}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + wilcards.hashCode();
    h += (h << 5) + option.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Wildcards} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Wildcards")
        .omitNullValues()
        .add("wilcards", wilcards)
        .add("option", option)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Wildcards} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Wildcards instance
   */
  public static ImmutableWildcards copyOf(Wildcards instance) {
    if (instance instanceof ImmutableWildcards) {
      return (ImmutableWildcards) instance;
    }
    return ImmutableWildcards.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWildcards ImmutableWildcards}.
   * <pre>
   * ImmutableWildcards.builder()
   *    .wilcards(List&amp;lt;?&amp;gt;) // required {@link Wildcards#wilcards() wilcards}
   *    .option(javaslang.control.Option&amp;lt;? super String&amp;gt;) // required {@link Wildcards#option() option}
   *    .build();
   * </pre>
   * @return A new ImmutableWildcards builder
   */
  public static ImmutableWildcards.Builder builder() {
    return new ImmutableWildcards.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWildcards ImmutableWildcards}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Wildcards", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_WILCARDS = 0x1L;
    private static final long INIT_BIT_OPTION = 0x2L;
    private long initBits = 0x3L;

    private @Nullable List<?> wilcards;
    private @Nullable Option<? super String> option;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Wildcards} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Wildcards instance) {
      Objects.requireNonNull(instance, "instance");
      wilcards(instance.wilcards());
      option(instance.option());
      return this;
    }

    /**
     * Initializes the value for the {@link Wildcards#wilcards() wilcards} attribute.
     * @param wilcards The value for wilcards 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder wilcards(List<?> wilcards) {
      this.wilcards = Objects.requireNonNull(wilcards, "wilcards");
      initBits &= ~INIT_BIT_WILCARDS;
      return this;
    }

    /**
     * Initializes the value for the {@link Wildcards#option() option} attribute.
     * @param option The value for option 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder option(Option<? super String> option) {
      this.option = Objects.requireNonNull(option, "option");
      initBits &= ~INIT_BIT_OPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWildcards ImmutableWildcards}.
     * @return An immutable instance of Wildcards
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWildcards build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWildcards(wilcards, option);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WILCARDS) != 0) attributes.add("wilcards");
      if ((initBits & INIT_BIT_OPTION) != 0) attributes.add("option");
      return "Cannot build Wildcards, some of required attributes are not set " + attributes;
    }
  }
}
