package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NoWarningFromSupertypesTypeAnnotations.Sub}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSub.builder()}.
 */
@Generated(from = "NoWarningFromSupertypesTypeAnnotations.Sub", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSub implements NoWarningFromSupertypesTypeAnnotations.Sub {
  private final @NoWarningFromSupertypesTypeAnnotations.Tann("b") int x;

  private ImmutableSub(@NoWarningFromSupertypesTypeAnnotations.Tann("b") int x) {
    this.x = x;
  }

  /**
   * @return The value of the {@code x} attribute
   */
  @Override
  public @NoWarningFromSupertypesTypeAnnotations.Tann("b") int x() {
    return x;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoWarningFromSupertypesTypeAnnotations.Sub#x() x} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for x
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSub withX(@NoWarningFromSupertypesTypeAnnotations.Tann("b") int value) {
    if (this.x == value) return this;
    return new ImmutableSub(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSub} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSub
        && equalTo(0, (ImmutableSub) another);
  }

  private boolean equalTo(int synthetic, ImmutableSub another) {
    return x == another.x;
  }

  /**
   * Computes a hash code from attributes: {@code x}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + x;
    return h;
  }

  /**
   * Prints the immutable value {@code Sub} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Sub")
        .omitNullValues()
        .add("x", x)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NoWarningFromSupertypesTypeAnnotations.Sub} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Sub instance
   */
  public static ImmutableSub copyOf(NoWarningFromSupertypesTypeAnnotations.Sub instance) {
    if (instance instanceof ImmutableSub) {
      return (ImmutableSub) instance;
    }
    return ImmutableSub.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSub ImmutableSub}.
   * <pre>
   * ImmutableSub.builder()
   *    .x(@org.immutables.fixture.NoWarningFromSupertypesTypeAnnotations.Tann("b") int) // required {@link NoWarningFromSupertypesTypeAnnotations.Sub#x() x}
   *    .build();
   * </pre>
   * @return A new ImmutableSub builder
   */
  public static ImmutableSub.Builder builder() {
    return new ImmutableSub.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSub ImmutableSub}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NoWarningFromSupertypesTypeAnnotations.Sub", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_X = 0x1L;
    private long initBits = 0x1L;

    private @NoWarningFromSupertypesTypeAnnotations.Tann("b") int x;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.NoWarningFromSupertypesTypeAnnotations.Sup} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NoWarningFromSupertypesTypeAnnotations.Sup instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.NoWarningFromSupertypesTypeAnnotations.Sub} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NoWarningFromSupertypesTypeAnnotations.Sub instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof NoWarningFromSupertypesTypeAnnotations.Sup) {
        NoWarningFromSupertypesTypeAnnotations.Sup instance = (NoWarningFromSupertypesTypeAnnotations.Sup) object;
        if ((bits & 0x1L) == 0) {
          x(instance.x());
          bits |= 0x1L;
        }
      }
      if (object instanceof NoWarningFromSupertypesTypeAnnotations.Sub) {
        NoWarningFromSupertypesTypeAnnotations.Sub instance = (NoWarningFromSupertypesTypeAnnotations.Sub) object;
        if ((bits & 0x1L) == 0) {
          x(instance.x());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link NoWarningFromSupertypesTypeAnnotations.Sub#x() x} attribute.
     * @param x The value for x 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder x(@NoWarningFromSupertypesTypeAnnotations.Tann("b") int x) {
      this.x = x;
      initBits &= ~INIT_BIT_X;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSub ImmutableSub}.
     * @return An immutable instance of Sub
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSub build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSub(x);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_X) != 0) attributes.add("x");
      return "Cannot build Sub, some of required attributes are not set " + attributes;
    }
  }
}
