package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SpecialAccessorsDiambiguations}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSpecialAccessorsDiambiguations.builder()}.
 */
@Generated(from = "SpecialAccessorsDiambiguations", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSpecialAccessorsDiambiguations
    extends SpecialAccessorsDiambiguations {
  private final int getHashCode;
  private final int computeHashCode;
  private final String isToString;
  private final int h;
  private final int get__;
  private transient final int hashCode;

  private ImmutableSpecialAccessorsDiambiguations(int getHashCode, int computeHashCode, String isToString, int h, int get__) {
    this.getHashCode = getHashCode;
    this.computeHashCode = computeHashCode;
    this.isToString = isToString;
    this.h = h;
    this.get__ = get__;
    this.hashCode = computeHashCode$$();
  }

  /**
   * @return The value of the {@code getHashCode} attribute
   */
  @Override
  public int getHashCode() {
    return getHashCode;
  }

  /**
   * @return The value of the {@code computeHashCode} attribute
   */
  @Override
  public int computeHashCode() {
    return computeHashCode;
  }

  /**
   * @return The value of the {@code isToString} attribute
   */
  @Override
  public String isToString() {
    return isToString;
  }

  /**
   * @return The value of the {@code h} attribute
   */
  @Override
  public int h() {
    return h;
  }

  /**
   * @return The value of the {@code get__} attribute
   */
  @Override
  public int get__() {
    return get__;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SpecialAccessorsDiambiguations#getHashCode() getHashCode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for getHashCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpecialAccessorsDiambiguations withGetHashCode(int value) {
    if (this.getHashCode == value) return this;
    return new ImmutableSpecialAccessorsDiambiguations(value, this.computeHashCode, this.isToString, this.h, this.get__);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SpecialAccessorsDiambiguations#computeHashCode() computeHashCode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for computeHashCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpecialAccessorsDiambiguations withComputeHashCode(int value) {
    if (this.computeHashCode == value) return this;
    return new ImmutableSpecialAccessorsDiambiguations(this.getHashCode, value, this.isToString, this.h, this.get__);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SpecialAccessorsDiambiguations#isToString() isToString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isToString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpecialAccessorsDiambiguations withIsToString(String value) {
    String newValue = Objects.requireNonNull(value, "isToString");
    if (this.isToString.equals(newValue)) return this;
    return new ImmutableSpecialAccessorsDiambiguations(this.getHashCode, this.computeHashCode, newValue, this.h, this.get__);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SpecialAccessorsDiambiguations#h() h} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for h
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpecialAccessorsDiambiguations withH(int value) {
    if (this.h == value) return this;
    return new ImmutableSpecialAccessorsDiambiguations(this.getHashCode, this.computeHashCode, this.isToString, value, this.get__);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SpecialAccessorsDiambiguations#get__() get__} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for get__
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpecialAccessorsDiambiguations withGet__(int value) {
    if (this.get__ == value) return this;
    return new ImmutableSpecialAccessorsDiambiguations(this.getHashCode, this.computeHashCode, this.isToString, this.h, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSpecialAccessorsDiambiguations} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSpecialAccessorsDiambiguations
        && equalTo(0, (ImmutableSpecialAccessorsDiambiguations) another);
  }

  private boolean equalTo(int synthetic, ImmutableSpecialAccessorsDiambiguations another) {
    if (hashCode != another.hashCode) return false;
    return getHashCode == another.getHashCode
        && computeHashCode == another.computeHashCode
        && isToString.equals(another.isToString)
        && h == another.h
        && get__ == another.get__;
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code getHashCode}, {@code computeHashCode}, {@code isToString}, {@code h}, {@code get__}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode$$() {
    @Var int h$$ = 5381;
    h$$ += (h$$ << 5) + getHashCode;
    h$$ += (h$$ << 5) + computeHashCode;
    h$$ += (h$$ << 5) + isToString.hashCode();
    h$$ += (h$$ << 5) + h;
    h$$ += (h$$ << 5) + get__;
    return h$$;
  }

  /**
   * Prints the immutable value {@code SpecialAccessorsDiambiguations} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SpecialAccessorsDiambiguations")
        .omitNullValues()
        .add("getHashCode", getHashCode)
        .add("computeHashCode", computeHashCode)
        .add("isToString", isToString)
        .add("h", h)
        .add("get__", get__)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SpecialAccessorsDiambiguations} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SpecialAccessorsDiambiguations instance
   */
  public static ImmutableSpecialAccessorsDiambiguations copyOf(SpecialAccessorsDiambiguations instance) {
    if (instance instanceof ImmutableSpecialAccessorsDiambiguations) {
      return (ImmutableSpecialAccessorsDiambiguations) instance;
    }
    return ImmutableSpecialAccessorsDiambiguations.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSpecialAccessorsDiambiguations ImmutableSpecialAccessorsDiambiguations}.
   * <pre>
   * ImmutableSpecialAccessorsDiambiguations.builder()
   *    .getHashCode(int) // required {@link SpecialAccessorsDiambiguations#getHashCode() getHashCode}
   *    .computeHashCode(int) // required {@link SpecialAccessorsDiambiguations#computeHashCode() computeHashCode}
   *    .isToString(String) // required {@link SpecialAccessorsDiambiguations#isToString() isToString}
   *    .h(int) // required {@link SpecialAccessorsDiambiguations#h() h}
   *    .get__(int) // required {@link SpecialAccessorsDiambiguations#get__() get__}
   *    .build();
   * </pre>
   * @return A new ImmutableSpecialAccessorsDiambiguations builder
   */
  public static ImmutableSpecialAccessorsDiambiguations.Builder builder() {
    return new ImmutableSpecialAccessorsDiambiguations.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSpecialAccessorsDiambiguations ImmutableSpecialAccessorsDiambiguations}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SpecialAccessorsDiambiguations", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_GET_HASH_CODE = 0x1L;
    private static final long INIT_BIT_COMPUTE_HASH_CODE = 0x2L;
    private static final long INIT_BIT_IS_TO_STRING = 0x4L;
    private static final long INIT_BIT_H = 0x8L;
    private static final long INIT_BIT_GET__ = 0x10L;
    private long initBits = 0x1fL;

    private int getHashCode;
    private int computeHashCode;
    private @Nullable String isToString;
    private int h;
    private int get__;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SpecialAccessorsDiambiguations} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SpecialAccessorsDiambiguations instance) {
      Objects.requireNonNull(instance, "instance");
      getHashCode(instance.getHashCode());
      computeHashCode(instance.computeHashCode());
      isToString(instance.isToString());
      h(instance.h());
      get__(instance.get__());
      return this;
    }

    /**
     * Initializes the value for the {@link SpecialAccessorsDiambiguations#getHashCode() getHashCode} attribute.
     * @param getHashCode The value for getHashCode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder getHashCode(int getHashCode) {
      this.getHashCode = getHashCode;
      initBits &= ~INIT_BIT_GET_HASH_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link SpecialAccessorsDiambiguations#computeHashCode() computeHashCode} attribute.
     * @param computeHashCode The value for computeHashCode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder computeHashCode(int computeHashCode) {
      this.computeHashCode = computeHashCode;
      initBits &= ~INIT_BIT_COMPUTE_HASH_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link SpecialAccessorsDiambiguations#isToString() isToString} attribute.
     * @param isToString The value for isToString 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isToString(String isToString) {
      this.isToString = Objects.requireNonNull(isToString, "isToString");
      initBits &= ~INIT_BIT_IS_TO_STRING;
      return this;
    }

    /**
     * Initializes the value for the {@link SpecialAccessorsDiambiguations#h() h} attribute.
     * @param h The value for h 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder h(int h) {
      this.h = h;
      initBits &= ~INIT_BIT_H;
      return this;
    }

    /**
     * Initializes the value for the {@link SpecialAccessorsDiambiguations#get__() get__} attribute.
     * @param get__ The value for get__ 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder get__(int get__) {
      this.get__ = get__;
      initBits &= ~INIT_BIT_GET__;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSpecialAccessorsDiambiguations ImmutableSpecialAccessorsDiambiguations}.
     * @return An immutable instance of SpecialAccessorsDiambiguations
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSpecialAccessorsDiambiguations build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSpecialAccessorsDiambiguations(getHashCode, computeHashCode, isToString, h, get__);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GET_HASH_CODE) != 0) attributes.add("getHashCode");
      if ((initBits & INIT_BIT_COMPUTE_HASH_CODE) != 0) attributes.add("computeHashCode");
      if ((initBits & INIT_BIT_IS_TO_STRING) != 0) attributes.add("isToString");
      if ((initBits & INIT_BIT_H) != 0) attributes.add("h");
      if ((initBits & INIT_BIT_GET__) != 0) attributes.add("get__");
      return "Cannot build SpecialAccessorsDiambiguations, some of required attributes are not set " + attributes;
    }
  }
}
