package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Sing5}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSing5.of()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableSing5.of()}.
 */
@Generated(from = "Sing5", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableSing5 implements Sing5 {
  private final int a;

  private ImmutableSing5() {
    this.a = Sing5.super.a();
  }

  private ImmutableSing5(int a) {
    this.a = a;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Sing5#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSing5 withA(int value) {
    if (this.a == value) return this;
    return validate(new ImmutableSing5(value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSing5} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSing5
        && equalTo(0, (ImmutableSing5) another);
  }

  private boolean equalTo(int synthetic, ImmutableSing5 another) {
    return a == another.a;
  }

  /**
   * Computes a hash code from attributes: {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    return h;
  }

  /**
   * Prints the immutable value {@code Sing5} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Sing5")
        .omitNullValues()
        .add("a", a)
        .toString();
  }

  private static final ImmutableSing5 INSTANCE = validate(new ImmutableSing5());

  /**
   * Returns the default immutable singleton value of {@code Sing5}
   * @return An immutable instance of Sing5
   */
  public static ImmutableSing5 of() {
    return INSTANCE;
  }

  /**
   * Construct a new immutable {@code Sing5} instance.
   * @param a The value for the {@code a} attribute
   * @return An immutable Sing5 instance
   */
  public static ImmutableSing5 of(int a) {
    return validate(new ImmutableSing5(a));
  }

  private static ImmutableSing5 validate(ImmutableSing5 instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link Sing5} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Sing5 instance
   */
  public static ImmutableSing5 copyOf(Sing5 instance) {
    if (instance instanceof ImmutableSing5) {
      return (ImmutableSing5) instance;
    }
    return ImmutableSing5.of(instance.a());
  }
}
