package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Sing4}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSing4.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableSing4.of()}.
 */
@Generated(from = "Sing4", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableSing4 implements Sing4 {

  private ImmutableSing4() {}

  /**
   * This instance is equal to all instances of {@code ImmutableSing4} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSing4
        && equalTo(0, (ImmutableSing4) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableSing4 another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 1828902700;
  }

  /**
   * Prints the immutable value {@code Sing4}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Sing4{}";
  }

  private static final ImmutableSing4 INSTANCE = validate(new ImmutableSing4());

  /**
   * Returns the default immutable singleton value of {@code Sing4}
   * @return An immutable instance of Sing4
   */
  public static ImmutableSing4 of() {
    return INSTANCE;
  }

  private static ImmutableSing4 validate(ImmutableSing4 instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link Sing4} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Sing4 instance
   */
  public static ImmutableSing4 copyOf(Sing4 instance) {
    if (instance instanceof ImmutableSing4) {
      return (ImmutableSing4) instance;
    }
    return ImmutableSing4.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSing4 ImmutableSing4}.
   * <pre>
   * ImmutableSing4.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableSing4 builder
   */
  public static ImmutableSing4.Builder builder() {
    return new ImmutableSing4.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSing4 ImmutableSing4}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Sing4", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Sing4} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Sing4 instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableSing4 ImmutableSing4}.
     * @return An immutable instance of Sing4
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSing4 build() {
      return ImmutableSing4.of();
    }
  }
}
