package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.Var;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyValidatedConstructedValue}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSillyValidatedConstructedValue.of()}.
 */
@Generated(from = "SillyValidatedConstructedValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyValidatedConstructedValue
    extends SillyValidatedConstructedValue {
  private final int value;
  private final boolean negativeOnly;

  private ImmutableSillyValidatedConstructedValue(int value, boolean negativeOnly) {
    this.value = value;
    this.negativeOnly = negativeOnly;
  }

  private ImmutableSillyValidatedConstructedValue(ImmutableSillyValidatedConstructedValue original, int value, boolean negativeOnly) {
    this.value = value;
    this.negativeOnly = negativeOnly;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public int value() {
    return value;
  }

  /**
   * @return The value of the {@code negativeOnly} attribute
   */
  @Override
  public boolean negativeOnly() {
    return negativeOnly;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyValidatedConstructedValue#value() value} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyValidatedConstructedValue withValue(int value) {
    if (this.value == value) return this;
    return validate(new ImmutableSillyValidatedConstructedValue(this, value, this.negativeOnly));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyValidatedConstructedValue#negativeOnly() negativeOnly} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for negativeOnly
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyValidatedConstructedValue withNegativeOnly(boolean value) {
    if (this.negativeOnly == value) return this;
    return validate(new ImmutableSillyValidatedConstructedValue(this, this.value, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyValidatedConstructedValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyValidatedConstructedValue
        && equalTo(0, (ImmutableSillyValidatedConstructedValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillyValidatedConstructedValue another) {
    return value == another.value
        && negativeOnly == another.negativeOnly;
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code negativeOnly}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value;
    h += (h << 5) + Booleans.hashCode(negativeOnly);
    return h;
  }

  /**
   * Prints the immutable value {@code SillyValidatedConstructedValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyValidatedConstructedValue")
        .omitNullValues()
        .add("value", value)
        .add("negativeOnly", negativeOnly)
        .toString();
  }

  /**
   * Construct a new immutable {@code SillyValidatedConstructedValue} instance.
   * @param value The value for the {@code value} attribute
   * @param negativeOnly The value for the {@code negativeOnly} attribute
   * @return An immutable SillyValidatedConstructedValue instance
   */
  public static ImmutableSillyValidatedConstructedValue of(int value, boolean negativeOnly) {
    return validate(new ImmutableSillyValidatedConstructedValue(value, negativeOnly));
  }

  private static ImmutableSillyValidatedConstructedValue validate(ImmutableSillyValidatedConstructedValue instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link SillyValidatedConstructedValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyValidatedConstructedValue instance
   */
  public static ImmutableSillyValidatedConstructedValue copyOf(SillyValidatedConstructedValue instance) {
    if (instance instanceof ImmutableSillyValidatedConstructedValue) {
      return (ImmutableSillyValidatedConstructedValue) instance;
    }
    return ImmutableSillyValidatedConstructedValue.of(instance.value(), instance.negativeOnly());
  }
}
