package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.subpack.SillySubstructure;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyStructureWithId}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillyStructureWithId.builder()}.
 */
@Generated(from = "SillyStructureWithId", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyStructureWithId implements SillyStructureWithId {
  private final String id;
  private final String attr1;
  private final boolean flag2;
  private final Optional<Integer> opt3;
  private final Option<Integer> opt5;
  private final long very4;
  private final double wet5;
  private final ImmutableList<SillySubstructure> subs6;
  private final SillySubstructure nest7;
  private final Optional<SillyTuplie> tup3;
  private final int int9;

  private ImmutableSillyStructureWithId(
      String id,
      String attr1,
      boolean flag2,
      Optional<Integer> opt3,
      Option<Integer> opt5,
      long very4,
      double wet5,
      ImmutableList<SillySubstructure> subs6,
      SillySubstructure nest7,
      Optional<SillyTuplie> tup3,
      int int9) {
    this.id = id;
    this.attr1 = attr1;
    this.flag2 = flag2;
    this.opt3 = opt3;
    this.opt5 = opt5;
    this.very4 = very4;
    this.wet5 = wet5;
    this.subs6 = subs6;
    this.nest7 = nest7;
    this.tup3 = tup3;
    this.int9 = int9;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code attr1} attribute
   */
  @Override
  public String attr1() {
    return attr1;
  }

  /**
   * @return The value of the {@code flag2} attribute
   */
  @Override
  public boolean flag2() {
    return flag2;
  }

  /**
   * @return The value of the {@code opt3} attribute
   */
  @Override
  public Optional<Integer> opt3() {
    return opt3;
  }

  /**
   * @return The value of the {@code opt5} attribute
   */
  @Override
  public Option<Integer> opt5() {
    return opt5;
  }

  /**
   * @return The value of the {@code very4} attribute
   */
  @Override
  public long very4() {
    return very4;
  }

  /**
   * @return The value of the {@code wet5} attribute
   */
  @Override
  public double wet5() {
    return wet5;
  }

  /**
   * @return The value of the {@code subs6} attribute
   */
  @Override
  public ImmutableList<SillySubstructure> subs6() {
    return subs6;
  }

  /**
   * @return The value of the {@code nest7} attribute
   */
  @Override
  public SillySubstructure nest7() {
    return nest7;
  }

  /**
   * @return The value of the {@code tup3} attribute
   */
  @Override
  public Optional<SillyTuplie> tup3() {
    return tup3;
  }

  /**
   * @return The value of the {@code int9} attribute
   */
  @Override
  public int int9() {
    return int9;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyStructureWithId#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyStructureWithId withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableSillyStructureWithId(
        newValue,
        this.attr1,
        this.flag2,
        this.opt3,
        this.opt5,
        this.very4,
        this.wet5,
        this.subs6,
        this.nest7,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyStructureWithId#attr1() attr1} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attr1
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyStructureWithId withAttr1(String value) {
    String newValue = Objects.requireNonNull(value, "attr1");
    if (this.attr1.equals(newValue)) return this;
    return new ImmutableSillyStructureWithId(
        this.id,
        newValue,
        this.flag2,
        this.opt3,
        this.opt5,
        this.very4,
        this.wet5,
        this.subs6,
        this.nest7,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyStructureWithId#flag2() flag2} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for flag2
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyStructureWithId withFlag2(boolean value) {
    if (this.flag2 == value) return this;
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        value,
        this.opt3,
        this.opt5,
        this.very4,
        this.wet5,
        this.subs6,
        this.nest7,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SillyStructureWithId#opt3() opt3} attribute.
   * @param value The value for opt3
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyStructureWithId withOpt3(int value) {
    Optional<Integer> newValue = Optional.of(value);
    if (this.opt3.equals(newValue)) return this;
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        newValue,
        this.opt5,
        this.very4,
        this.wet5,
        this.subs6,
        this.nest7,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SillyStructureWithId#opt3() opt3} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for opt3
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyStructureWithId withOpt3(Optional<Integer> optional) {
    Optional<Integer> value = optional;
    if (this.opt3.equals(value)) return this;
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        value,
        this.opt5,
        this.very4,
        this.wet5,
        this.subs6,
        this.nest7,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SillyStructureWithId#opt5() opt5} attribute.
   * @param value The value for opt5
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyStructureWithId withOpt5(int value) {
    Option<Integer> newValue = Option.some(value);
    if (this.opt5.equals(newValue)) return this;
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        this.opt3,
        newValue,
        this.very4,
        this.wet5,
        this.subs6,
        this.nest7,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SillyStructureWithId#opt5() opt5} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for opt5
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyStructureWithId withOpt5(Option<Integer> optional) {
    Option<Integer> value = optional;
    if (this.opt5.equals(value)) return this;
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        this.opt3,
        value,
        this.very4,
        this.wet5,
        this.subs6,
        this.nest7,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyStructureWithId#very4() very4} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for very4
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyStructureWithId withVery4(long value) {
    if (this.very4 == value) return this;
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        this.opt3,
        this.opt5,
        value,
        this.wet5,
        this.subs6,
        this.nest7,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyStructureWithId#wet5() wet5} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wet5
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyStructureWithId withWet5(double value) {
    if (Double.doubleToLongBits(this.wet5) == Double.doubleToLongBits(value)) return this;
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        this.opt3,
        this.opt5,
        this.very4,
        value,
        this.subs6,
        this.nest7,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillyStructureWithId#subs6() subs6}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyStructureWithId withSubs6(SillySubstructure... elements) {
    ImmutableList<SillySubstructure> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        this.opt3,
        this.opt5,
        this.very4,
        this.wet5,
        newValue,
        this.nest7,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillyStructureWithId#subs6() subs6}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of subs6 elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyStructureWithId withSubs6(Iterable<? extends SillySubstructure> elements) {
    if (this.subs6 == elements) return this;
    ImmutableList<SillySubstructure> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        this.opt3,
        this.opt5,
        this.very4,
        this.wet5,
        newValue,
        this.nest7,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyStructureWithId#nest7() nest7} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nest7
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyStructureWithId withNest7(SillySubstructure value) {
    if (this.nest7 == value) return this;
    SillySubstructure newValue = Objects.requireNonNull(value, "nest7");
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        this.opt3,
        this.opt5,
        this.very4,
        this.wet5,
        this.subs6,
        newValue,
        this.tup3,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SillyStructureWithId#tup3() tup3} attribute.
   * @param value The value for tup3
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyStructureWithId withTup3(SillyTuplie value) {
    Optional<SillyTuplie> newValue = Optional.of(value);
    if (this.tup3.isPresent() && this.tup3.get() == value) return this;
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        this.opt3,
        this.opt5,
        this.very4,
        this.wet5,
        this.subs6,
        this.nest7,
        newValue,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SillyStructureWithId#tup3() tup3} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tup3
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableSillyStructureWithId withTup3(Optional<? extends SillyTuplie> optional) {
    Optional<SillyTuplie> value = (Optional<SillyTuplie>) optional;
    if (!this.tup3.isPresent() && !value.isPresent()) return this;
    if (this.tup3.isPresent() && value.isPresent() && this.tup3.get() == value.get()) return this;
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        this.opt3,
        this.opt5,
        this.very4,
        this.wet5,
        this.subs6,
        this.nest7,
        value,
        this.int9);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyStructureWithId#int9() int9} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for int9
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyStructureWithId withInt9(int value) {
    if (this.int9 == value) return this;
    return new ImmutableSillyStructureWithId(
        this.id,
        this.attr1,
        this.flag2,
        this.opt3,
        this.opt5,
        this.very4,
        this.wet5,
        this.subs6,
        this.nest7,
        this.tup3,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyStructureWithId} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyStructureWithId
        && equalTo(0, (ImmutableSillyStructureWithId) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillyStructureWithId another) {
    return id.equals(another.id)
        && attr1.equals(another.attr1)
        && flag2 == another.flag2
        && opt3.equals(another.opt3)
        && opt5.equals(another.opt5)
        && very4 == another.very4
        && Double.doubleToLongBits(wet5) == Double.doubleToLongBits(another.wet5)
        && subs6.equals(another.subs6)
        && nest7.equals(another.nest7)
        && tup3.equals(another.tup3)
        && int9 == another.int9;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code attr1}, {@code flag2}, {@code opt3}, {@code opt5}, {@code very4}, {@code wet5}, {@code subs6}, {@code nest7}, {@code tup3}, {@code int9}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + attr1.hashCode();
    h += (h << 5) + Booleans.hashCode(flag2);
    h += (h << 5) + opt3.hashCode();
    h += (h << 5) + opt5.hashCode();
    h += (h << 5) + Longs.hashCode(very4);
    h += (h << 5) + Doubles.hashCode(wet5);
    h += (h << 5) + subs6.hashCode();
    h += (h << 5) + nest7.hashCode();
    h += (h << 5) + tup3.hashCode();
    h += (h << 5) + int9;
    return h;
  }

  /**
   * Prints the immutable value {@code SillyStructureWithId} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyStructureWithId")
        .omitNullValues()
        .add("id", id)
        .add("attr1", attr1)
        .add("flag2", flag2)
        .add("opt3", opt3.orNull())
        .add("opt5", opt5.isDefined() ? opt5.get() : null)
        .add("very4", very4)
        .add("wet5", wet5)
        .add("subs6", subs6)
        .add("nest7", nest7)
        .add("tup3", tup3.orNull())
        .add("int9", int9)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SillyStructureWithId} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyStructureWithId instance
   */
  public static ImmutableSillyStructureWithId copyOf(SillyStructureWithId instance) {
    if (instance instanceof ImmutableSillyStructureWithId) {
      return (ImmutableSillyStructureWithId) instance;
    }
    return ImmutableSillyStructureWithId.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillyStructureWithId ImmutableSillyStructureWithId}.
   * <pre>
   * ImmutableSillyStructureWithId.builder()
   *    .id(String) // required {@link SillyStructureWithId#id() id}
   *    .attr1(String) // required {@link SillyStructureWithId#attr1() attr1}
   *    .flag2(boolean) // required {@link SillyStructureWithId#flag2() flag2}
   *    .opt3(Integer) // optional {@link SillyStructureWithId#opt3() opt3}
   *    .opt5(Integer) // optional {@link SillyStructureWithId#opt5() opt5}
   *    .very4(long) // required {@link SillyStructureWithId#very4() very4}
   *    .wet5(double) // required {@link SillyStructureWithId#wet5() wet5}
   *    .addSubs6|addAllSubs6(org.immutables.fixture.subpack.SillySubstructure) // {@link SillyStructureWithId#subs6() subs6} elements
   *    .nest7(org.immutables.fixture.subpack.SillySubstructure) // required {@link SillyStructureWithId#nest7() nest7}
   *    .tup3(org.immutables.fixture.SillyTuplie) // optional {@link SillyStructureWithId#tup3() tup3}
   *    .int9(int) // required {@link SillyStructureWithId#int9() int9}
   *    .build();
   * </pre>
   * @return A new ImmutableSillyStructureWithId builder
   */
  public static ImmutableSillyStructureWithId.Builder builder() {
    return new ImmutableSillyStructureWithId.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillyStructureWithId ImmutableSillyStructureWithId}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillyStructureWithId", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_ATTR1 = 0x2L;
    private static final long INIT_BIT_FLAG2 = 0x4L;
    private static final long INIT_BIT_VERY4 = 0x8L;
    private static final long INIT_BIT_WET5 = 0x10L;
    private static final long INIT_BIT_NEST7 = 0x20L;
    private static final long INIT_BIT_INT9 = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable String id;
    private @Nullable String attr1;
    private boolean flag2;
    private Optional<Integer> opt3 = Optional.absent();
    private Option<Integer> opt5 = Option.none();
    private long very4;
    private double wet5;
    private ImmutableList.Builder<SillySubstructure> subs6 = ImmutableList.builder();
    private @Nullable SillySubstructure nest7;
    private Optional<SillyTuplie> tup3 = Optional.absent();
    private int int9;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillyStructureWithId} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillyStructureWithId instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      attr1(instance.attr1());
      flag2(instance.flag2());
      Optional<Integer> opt3Optional = instance.opt3();
      if (opt3Optional.isPresent()) {
        opt3(opt3Optional);
      }
      Option<Integer> opt5Optional = instance.opt5();
      if (opt5Optional.isDefined()) {
        opt5(opt5Optional);
      }
      very4(instance.very4());
      wet5(instance.wet5());
      addAllSubs6(instance.subs6());
      nest7(instance.nest7());
      Optional<SillyTuplie> tup3Optional = instance.tup3();
      if (tup3Optional.isPresent()) {
        tup3(tup3Optional);
      }
      int9(instance.int9());
      return this;
    }

    /**
     * Initializes the value for the {@link SillyStructureWithId#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SillyStructureWithId#attr1() attr1} attribute.
     * @param attr1 The value for attr1 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder attr1(String attr1) {
      this.attr1 = Objects.requireNonNull(attr1, "attr1");
      initBits &= ~INIT_BIT_ATTR1;
      return this;
    }

    /**
     * Initializes the value for the {@link SillyStructureWithId#flag2() flag2} attribute.
     * @param flag2 The value for flag2 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder flag2(boolean flag2) {
      this.flag2 = flag2;
      initBits &= ~INIT_BIT_FLAG2;
      return this;
    }

    /**
     * Initializes the optional value {@link SillyStructureWithId#opt3() opt3} to opt3.
     * @param opt3 The value for opt3
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder opt3(int opt3) {
      this.opt3 = Optional.of(opt3);
      return this;
    }

    /**
     * Initializes the optional value {@link SillyStructureWithId#opt3() opt3} to opt3.
     * @param opt3 The value for opt3
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder opt3(Optional<Integer> opt3) {
      this.opt3 = opt3;
      return this;
    }

    /**
     * Initializes the optional value {@link SillyStructureWithId#opt5() opt5} to opt5.
     * @param opt5 The value for opt5
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder opt5(int opt5) {
      this.opt5 = Option.some(opt5);
      return this;
    }

    /**
     * Initializes the optional value {@link SillyStructureWithId#opt5() opt5} to opt5.
     * @param opt5 The value for opt5
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder opt5(Option<Integer> opt5) {
      this.opt5 = opt5;
      return this;
    }

    /**
     * Initializes the value for the {@link SillyStructureWithId#very4() very4} attribute.
     * @param very4 The value for very4 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder very4(long very4) {
      this.very4 = very4;
      initBits &= ~INIT_BIT_VERY4;
      return this;
    }

    /**
     * Initializes the value for the {@link SillyStructureWithId#wet5() wet5} attribute.
     * @param wet5 The value for wet5 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder wet5(double wet5) {
      this.wet5 = wet5;
      initBits &= ~INIT_BIT_WET5;
      return this;
    }

    /**
     * Adds one element to {@link SillyStructureWithId#subs6() subs6} list.
     * @param element A subs6 element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSubs6(SillySubstructure element) {
      this.subs6.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SillyStructureWithId#subs6() subs6} list.
     * @param elements An array of subs6 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSubs6(SillySubstructure... elements) {
      this.subs6.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SillyStructureWithId#subs6() subs6} list.
     * @param elements An iterable of subs6 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder subs6(Iterable<? extends SillySubstructure> elements) {
      this.subs6 = ImmutableList.builder();
      return addAllSubs6(elements);
    }

    /**
     * Adds elements to {@link SillyStructureWithId#subs6() subs6} list.
     * @param elements An iterable of subs6 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSubs6(Iterable<? extends SillySubstructure> elements) {
      this.subs6.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link SillyStructureWithId#nest7() nest7} attribute.
     * @param nest7 The value for nest7 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nest7(SillySubstructure nest7) {
      this.nest7 = Objects.requireNonNull(nest7, "nest7");
      initBits &= ~INIT_BIT_NEST7;
      return this;
    }

    /**
     * Initializes the optional value {@link SillyStructureWithId#tup3() tup3} to tup3.
     * @param tup3 The value for tup3
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tup3(SillyTuplie tup3) {
      this.tup3 = Optional.of(tup3);
      return this;
    }

    /**
     * Initializes the optional value {@link SillyStructureWithId#tup3() tup3} to tup3.
     * @param tup3 The value for tup3
     * @return {@code this} builder for use in a chained invocation
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    @CanIgnoreReturnValue 
    public final Builder tup3(Optional<? extends SillyTuplie> tup3) {
      this.tup3 = (Optional<SillyTuplie>) tup3;
      return this;
    }

    /**
     * Initializes the value for the {@link SillyStructureWithId#int9() int9} attribute.
     * @param int9 The value for int9 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder int9(int int9) {
      this.int9 = int9;
      initBits &= ~INIT_BIT_INT9;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillyStructureWithId ImmutableSillyStructureWithId}.
     * @return An immutable instance of SillyStructureWithId
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillyStructureWithId build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSillyStructureWithId(id, attr1, flag2, opt3, opt5, very4, wet5, subs6.build(), nest7, tup3, int9);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_ATTR1) != 0) attributes.add("attr1");
      if ((initBits & INIT_BIT_FLAG2) != 0) attributes.add("flag2");
      if ((initBits & INIT_BIT_VERY4) != 0) attributes.add("very4");
      if ((initBits & INIT_BIT_WET5) != 0) attributes.add("wet5");
      if ((initBits & INIT_BIT_NEST7) != 0) attributes.add("nest7");
      if ((initBits & INIT_BIT_INT9) != 0) attributes.add("int9");
      return "Cannot build SillyStructureWithId, some of required attributes are not set " + attributes;
    }
  }
}
