package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyInterned}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillyInterned.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSillyInterned.of()}.
 */
@Generated(from = "SillyInterned", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyInterned extends SillyInterned {
  private final int arg1;
  private final int arg2;

  private ImmutableSillyInterned(int arg1, int arg2) {
    this.arg1 = arg1;
    this.arg2 = arg2;
  }

  private ImmutableSillyInterned(ImmutableSillyInterned original, int arg1, int arg2) {
    this.arg1 = arg1;
    this.arg2 = arg2;
  }

  /**
   * @return The value of the {@code arg1} attribute
   */
  @Override
  public int arg1() {
    return arg1;
  }

  /**
   * @return The value of the {@code arg2} attribute
   */
  @Override
  public int arg2() {
    return arg2;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyInterned#arg1() arg1} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for arg1
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyInterned withArg1(int value) {
    if (this.arg1 == value) return this;
    return validate(new ImmutableSillyInterned(this, value, this.arg2));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyInterned#arg2() arg2} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for arg2
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyInterned withArg2(int value) {
    if (this.arg2 == value) return this;
    return validate(new ImmutableSillyInterned(this, this.arg1, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyInterned} that have equal attribute values.
   * As instances of the {@code ImmutableSillyInterned} class are interned, the {@code equals} method is implemented
   * as an efficient reference equality check.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another;
  }

  private boolean equalTo(int synthetic, ImmutableSillyInterned another) {
    return arg1 == another.arg1
        && arg2 == another.arg2;
  }

  /**
   * Computes a hash code from attributes: {@code arg1}, {@code arg2}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + arg1;
    h += (h << 5) + arg2;
    return h;
  }

  /**
   * Prints the immutable value {@code SillyInterned} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyInterned")
        .omitNullValues()
        .add("arg1", arg1)
        .add("arg2", arg2)
        .toString();
  }

  @Generated(from = "SillyInterned", generator = "Immutables")
  private static class InternProxy {
    final ImmutableSillyInterned instance;

    InternProxy(ImmutableSillyInterned instance) {
      this.instance = instance;
    }

    @Override
    public boolean equals(@Nullable Object another) {
      return another != null && instance.equalTo(0, ((InternProxy) another).instance);
    }

    @Override
    public int hashCode() {
      return instance.hashCode();
    }
  }

  private static final class InternerHolder {
    static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();
  }

  /**
   * Construct a new immutable {@code SillyInterned} instance.
   * @param arg1 The value for the {@code arg1} attribute
   * @param arg2 The value for the {@code arg2} attribute
   * @return An immutable SillyInterned instance
   */
  public static ImmutableSillyInterned of(int arg1, int arg2) {
    return validate(new ImmutableSillyInterned(arg1, arg2));
  }

  private static ImmutableSillyInterned validate(ImmutableSillyInterned instance) {
    return InternerHolder.INTERNER.intern(new InternProxy(instance)).instance;
  }

  /**
   * Creates an immutable copy of a {@link SillyInterned} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyInterned instance
   */
  public static ImmutableSillyInterned copyOf(SillyInterned instance) {
    if (instance instanceof ImmutableSillyInterned) {
      return (ImmutableSillyInterned) instance;
    }
    return ImmutableSillyInterned.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillyInterned ImmutableSillyInterned}.
   * <pre>
   * ImmutableSillyInterned.builder()
   *    .arg1(int) // required {@link SillyInterned#arg1() arg1}
   *    .arg2(int) // required {@link SillyInterned#arg2() arg2}
   *    .build();
   * </pre>
   * @return A new ImmutableSillyInterned builder
   */
  public static ImmutableSillyInterned.Builder builder() {
    return new ImmutableSillyInterned.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillyInterned ImmutableSillyInterned}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillyInterned", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ARG1 = 0x1L;
    private static final long INIT_BIT_ARG2 = 0x2L;
    private long initBits = 0x3L;

    private int arg1;
    private int arg2;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillyInterned} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillyInterned instance) {
      Objects.requireNonNull(instance, "instance");
      arg1(instance.arg1());
      arg2(instance.arg2());
      return this;
    }

    /**
     * Initializes the value for the {@link SillyInterned#arg1() arg1} attribute.
     * @param arg1 The value for arg1 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder arg1(int arg1) {
      this.arg1 = arg1;
      initBits &= ~INIT_BIT_ARG1;
      return this;
    }

    /**
     * Initializes the value for the {@link SillyInterned#arg2() arg2} attribute.
     * @param arg2 The value for arg2 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder arg2(int arg2) {
      this.arg2 = arg2;
      initBits &= ~INIT_BIT_ARG2;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillyInterned ImmutableSillyInterned}.
     * @return An immutable instance of SillyInterned
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillyInterned build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableSillyInterned.validate(new ImmutableSillyInterned(null, arg1, arg2));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ARG1) != 0) attributes.add("arg1");
      if ((initBits & INIT_BIT_ARG2) != 0) attributes.add("arg2");
      return "Cannot build SillyInterned, some of required attributes are not set " + attributes;
    }
  }
}
