package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableSampleCopyOfTypes} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link SampleCopyOfTypes}.
 * @see ImmutableSampleCopyOfTypes.ByConstructorAndWithers
 * @see ImmutableSampleCopyOfTypes.ByBuilder
 */
@Generated(from = "SampleCopyOfTypes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSampleCopyOfTypes {
  private ImmutableSampleCopyOfTypes() {}

  /**
   * Immutable implementation of {@link SampleCopyOfTypes.ByConstructorAndWithers}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code ImmutableSampleCopyOfTypes.ByConstructorAndWithers.of()}.
   */
  @Generated(from = "SampleCopyOfTypes.ByConstructorAndWithers", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class ByConstructorAndWithers
      implements SampleCopyOfTypes.ByConstructorAndWithers {
    private final int value;
    private final ImmutableList<String> additional;

    private ByConstructorAndWithers(int value) {
      this.value = value;
      this.additional = ImmutableList.of();
    }

    private ByConstructorAndWithers(int value, ImmutableList<String> additional) {
      this.value = value;
      this.additional = additional;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public int value() {
      return value;
    }

    /**
     * @return The value of the {@code additional} attribute
     */
    @Override
    public ImmutableList<String> additional() {
      return additional;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link SampleCopyOfTypes.ByConstructorAndWithers#value() value} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableSampleCopyOfTypes.ByConstructorAndWithers withValue(int value) {
      if (this.value == value) return this;
      return new ImmutableSampleCopyOfTypes.ByConstructorAndWithers(value, this.additional);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link SampleCopyOfTypes.ByConstructorAndWithers#additional() additional}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableSampleCopyOfTypes.ByConstructorAndWithers withAdditional(String... elements) {
      ImmutableList<String> newValue = ImmutableList.copyOf(elements);
      return new ImmutableSampleCopyOfTypes.ByConstructorAndWithers(this.value, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link SampleCopyOfTypes.ByConstructorAndWithers#additional() additional}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of additional elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableSampleCopyOfTypes.ByConstructorAndWithers withAdditional(Iterable<String> elements) {
      if (this.additional == elements) return this;
      ImmutableList<String> newValue = ImmutableList.copyOf(elements);
      return new ImmutableSampleCopyOfTypes.ByConstructorAndWithers(this.value, newValue);
    }

    /**
     * This instance is equal to all instances of {@code ByConstructorAndWithers} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableSampleCopyOfTypes.ByConstructorAndWithers
          && equalTo(0, (ImmutableSampleCopyOfTypes.ByConstructorAndWithers) another);
    }

    private boolean equalTo(int synthetic, ImmutableSampleCopyOfTypes.ByConstructorAndWithers another) {
      return value == another.value
          && additional.equals(another.additional);
    }

    /**
     * Computes a hash code from attributes: {@code value}, {@code additional}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + value;
      h += (h << 5) + additional.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ByConstructorAndWithers} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ByConstructorAndWithers")
          .omitNullValues()
          .add("value", value)
          .add("additional", additional)
          .toString();
    }

    /**
     * Construct a new immutable {@code ByConstructorAndWithers} instance.
     * @param value The value for the {@code value} attribute
     * @return An immutable ByConstructorAndWithers instance
     */
    public static ImmutableSampleCopyOfTypes.ByConstructorAndWithers of(int value) {
      return new ImmutableSampleCopyOfTypes.ByConstructorAndWithers(value);
    }

    /**
     * Creates an immutable copy of a {@link SampleCopyOfTypes.ByConstructorAndWithers} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ByConstructorAndWithers instance
     */
    public static ImmutableSampleCopyOfTypes.ByConstructorAndWithers copyOf(SampleCopyOfTypes.ByConstructorAndWithers instance) {
      if (instance instanceof ImmutableSampleCopyOfTypes.ByConstructorAndWithers) {
        return (ImmutableSampleCopyOfTypes.ByConstructorAndWithers) instance;
      }
      return ImmutableSampleCopyOfTypes.ByConstructorAndWithers.of(instance.value())
          .withAdditional(instance.additional());
    }
  }

  /**
   * Immutable implementation of {@link SampleCopyOfTypes.ByBuilder}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableSampleCopyOfTypes.ByBuilder.builder()}.
   */
  @Generated(from = "SampleCopyOfTypes.ByBuilder", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class ByBuilder implements SampleCopyOfTypes.ByBuilder {
    private final int value;

    private ByBuilder(int value) {
      this.value = value;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public int value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link SampleCopyOfTypes.ByBuilder#value() value} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableSampleCopyOfTypes.ByBuilder withValue(int value) {
      if (this.value == value) return this;
      return new ImmutableSampleCopyOfTypes.ByBuilder(value);
    }

    /**
     * This instance is equal to all instances of {@code ByBuilder} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableSampleCopyOfTypes.ByBuilder
          && equalTo(0, (ImmutableSampleCopyOfTypes.ByBuilder) another);
    }

    private boolean equalTo(int synthetic, ImmutableSampleCopyOfTypes.ByBuilder another) {
      return value == another.value;
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + value;
      return h;
    }

    /**
     * Prints the immutable value {@code ByBuilder} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ByBuilder")
          .omitNullValues()
          .add("value", value)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link SampleCopyOfTypes.ByBuilder} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ByBuilder instance
     */
    public static ImmutableSampleCopyOfTypes.ByBuilder copyOf(SampleCopyOfTypes.ByBuilder instance) {
      if (instance instanceof ImmutableSampleCopyOfTypes.ByBuilder) {
        return (ImmutableSampleCopyOfTypes.ByBuilder) instance;
      }
      return ImmutableSampleCopyOfTypes.ByBuilder.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableSampleCopyOfTypes.ByBuilder ByBuilder}.
     * <pre>
     * ImmutableSampleCopyOfTypes.ByBuilder.builder()
     *    .value(int) // required {@link SampleCopyOfTypes.ByBuilder#value() value}
     *    .build();
     * </pre>
     * @return A new ByBuilder builder
     */
    public static ImmutableSampleCopyOfTypes.ByBuilder.Builder builder() {
      return new ImmutableSampleCopyOfTypes.ByBuilder.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableSampleCopyOfTypes.ByBuilder ByBuilder}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "SampleCopyOfTypes.ByBuilder", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_VALUE = 0x1L;
      private long initBits = 0x1L;

      private int value;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code ByBuilder} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(SampleCopyOfTypes.ByBuilder instance) {
        Objects.requireNonNull(instance, "instance");
        value(instance.value());
        return this;
      }

      /**
       * Initializes the value for the {@link SampleCopyOfTypes.ByBuilder#value() value} attribute.
       * @param value The value for value 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder value(int value) {
        this.value = value;
        initBits &= ~INIT_BIT_VALUE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableSampleCopyOfTypes.ByBuilder ByBuilder}.
       * @return An immutable instance of ByBuilder
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableSampleCopyOfTypes.ByBuilder build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableSampleCopyOfTypes.ByBuilder(value);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
        return "Cannot build ByBuilder, some of required attributes are not set " + attributes;
      }
    }
  }
}
