package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Redacted.RedactedMask}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRedactedMask.builder()}.
 */
@Generated(from = "Redacted.RedactedMask", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRedactedMask implements Redacted.RedactedMask {
  private final int code;

  private ImmutableRedactedMask(int code) {
    this.code = code;
  }

  /**
   * @return The value of the {@code code} attribute
   */
  @Override
  public int code() {
    return code;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Redacted.RedactedMask#code() code} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for code
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRedactedMask withCode(int value) {
    if (this.code == value) return this;
    return new ImmutableRedactedMask(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRedactedMask} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRedactedMask
        && equalTo(0, (ImmutableRedactedMask) another);
  }

  private boolean equalTo(int synthetic, ImmutableRedactedMask another) {
    return code == another.code;
  }

  /**
   * Computes a hash code from attributes: {@code code}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + code;
    return h;
  }

  /**
   * Prints the immutable value {@code RedactedMask} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RedactedMask")
        .omitNullValues()
        .add("code", "####")
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Redacted.RedactedMask} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RedactedMask instance
   */
  public static ImmutableRedactedMask copyOf(Redacted.RedactedMask instance) {
    if (instance instanceof ImmutableRedactedMask) {
      return (ImmutableRedactedMask) instance;
    }
    return ImmutableRedactedMask.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRedactedMask ImmutableRedactedMask}.
   * <pre>
   * ImmutableRedactedMask.builder()
   *    .code(int) // required {@link Redacted.RedactedMask#code() code}
   *    .build();
   * </pre>
   * @return A new ImmutableRedactedMask builder
   */
  public static ImmutableRedactedMask.Builder builder() {
    return new ImmutableRedactedMask.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRedactedMask ImmutableRedactedMask}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Redacted.RedactedMask", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CODE = 0x1L;
    private long initBits = 0x1L;

    private int code;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RedactedMask} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Redacted.RedactedMask instance) {
      Objects.requireNonNull(instance, "instance");
      code(instance.code());
      return this;
    }

    /**
     * Initializes the value for the {@link Redacted.RedactedMask#code() code} attribute.
     * @param code The value for code 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder code(int code) {
      this.code = code;
      initBits &= ~INIT_BIT_CODE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRedactedMask ImmutableRedactedMask}.
     * @return An immutable instance of RedactedMask
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRedactedMask build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRedactedMask(code);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CODE) != 0) attributes.add("code");
      return "Cannot build RedactedMask, some of required attributes are not set " + attributes;
    }
  }
}
