package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.errorprone.annotations.Var;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProperInitInternNoBuilder}.
 * <p>
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableProperInitInternNoBuilder.of()}.
 */
@Generated(from = "ProperInitInternNoBuilder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableProperInitInternNoBuilder
    implements ProperInitInternNoBuilder {
  private final int x;

  private ImmutableProperInitInternNoBuilder() {
    this.x = ProperInitInternNoBuilder.super.x();
  }

  private ImmutableProperInitInternNoBuilder(int x) {
    this.x = x;
  }

  /**
   * @return The value of the {@code x} attribute
   */
  @Override
  public int x() {
    return x;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProperInitInternNoBuilder#x() x} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for x
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProperInitInternNoBuilder withX(int value) {
    if (this.x == value) return this;
    return validate(new ImmutableProperInitInternNoBuilder(value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProperInitInternNoBuilder} that have equal attribute values.
   * As instances of the {@code ImmutableProperInitInternNoBuilder} class are interned, the {@code equals} method is implemented
   * as an efficient reference equality check.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another;
  }

  private boolean equalTo(int synthetic, ImmutableProperInitInternNoBuilder another) {
    return x == another.x;
  }

  /**
   * Computes a hash code from attributes: {@code x}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + x;
    return h;
  }

  /**
   * Prints the immutable value {@code ProperInitInternNoBuilder} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ProperInitInternNoBuilder")
        .omitNullValues()
        .add("x", x)
        .toString();
  }

  @Generated(from = "ProperInitInternNoBuilder", generator = "Immutables")
  private static class InternProxy {
    final ImmutableProperInitInternNoBuilder instance;

    InternProxy(ImmutableProperInitInternNoBuilder instance) {
      this.instance = instance;
    }

    @Override
    public boolean equals(@Nullable Object another) {
      return another != null && instance.equalTo(0, ((InternProxy) another).instance);
    }

    @Override
    public int hashCode() {
      return instance.hashCode();
    }
  }

  private static final class InternerHolder {
    static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();
  }

  private static final ImmutableProperInitInternNoBuilder INSTANCE = validate(new ImmutableProperInitInternNoBuilder());

  /**
   * Returns the default immutable singleton value of {@code ProperInitInternNoBuilder}
   * @return An immutable instance of ProperInitInternNoBuilder
   */
  public static ImmutableProperInitInternNoBuilder of() {
    return INSTANCE;
  }

  private static ImmutableProperInitInternNoBuilder validate(ImmutableProperInitInternNoBuilder instance) {
    return InternerHolder.INTERNER.intern(new InternProxy(instance)).instance;
  }
}
