package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NullableRef}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNullableRef.builder()}.
 */
@Generated(from = "NullableRef", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableNullableRef extends NullableRef {
  private final @Nullable Object[] refs;

  private ImmutableNullableRef(@Nullable Object[] refs) {
    this.refs = refs;
  }

  /**
   * @return A cloned {@code refs} array
   */
  @Override
  @Nullable Object[] refs() {
    return refs;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableRef#refs() refs}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for refs
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableRef withRefs(@Nullable Object... elements) {
    @Nullable Object[] newValue = elements == null ? null : elements.clone();
    return new ImmutableNullableRef(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullableRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNullableRef
        && equalTo(0, (ImmutableNullableRef) another);
  }

  private boolean equalTo(int synthetic, ImmutableNullableRef another) {
    return Arrays.equals(refs, another.refs);
  }

  /**
   * Computes a hash code from attributes: {@code refs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Arrays.hashCode(refs);
    return h;
  }

  /**
   * Prints the immutable value {@code NullableRef} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NullableRef{"
        + "refs=" + Arrays.toString(refs)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link NullableRef} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullableRef instance
   */
  public static ImmutableNullableRef copyOf(NullableRef instance) {
    if (instance instanceof ImmutableNullableRef) {
      return (ImmutableNullableRef) instance;
    }
    return ImmutableNullableRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNullableRef ImmutableNullableRef}.
   * <pre>
   * ImmutableNullableRef.builder()
   *    .refs(Object[] | null) // nullable {@link NullableRef#refs() refs}
   *    .build();
   * </pre>
   * @return A new ImmutableNullableRef builder
   */
  public static ImmutableNullableRef.Builder builder() {
    return new ImmutableNullableRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNullableRef ImmutableNullableRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NullableRef", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Object[] refs;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableNullableRef} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableNullableRef instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Object[] refsValue = instance.refs();
      if (refsValue != null) {
        refs(refsValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code NullableRef} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NullableRef instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableNullableRef) {
        return from((ModifiableNullableRef) instance);
      }
      @Nullable Object[] refsValue = instance.refs();
      if (refsValue != null) {
        refs(refsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NullableRef#refs() refs} attribute.
     * @param refs The elements for refs
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder refs(Object... refs) {
      this.refs = refs;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNullableRef ImmutableNullableRef}.
     * @return An immutable instance of NullableRef
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNullableRef build() {
      return new ImmutableNullableRef(refs);
    }
  }
}
