package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NullableArray}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNullableArray.builder()}.
 */
@Generated(from = "NullableArray", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNullableArray implements NullableArray {
  private final @Nullable byte[] array;

  private ImmutableNullableArray(@Nullable byte[] array) {
    this.array = array;
  }

  /**
   * @return A cloned {@code array} array
   */
  @Override
  public @Nullable byte[] array() {
    return array;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableArray#array() array}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for array
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableArray withArray(@Nullable byte... elements) {
    @Nullable byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableNullableArray(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullableArray} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNullableArray
        && equalTo(0, (ImmutableNullableArray) another);
  }

  private boolean equalTo(int synthetic, ImmutableNullableArray another) {
    return Arrays.equals(array, another.array);
  }

  /**
   * Computes a hash code from attributes: {@code array}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Arrays.hashCode(array);
    return h;
  }

  /**
   * Prints the immutable value {@code NullableArray} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NullableArray")
        .omitNullValues()
        .add("array", Arrays.toString(array))
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NullableArray} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullableArray instance
   */
  public static ImmutableNullableArray copyOf(NullableArray instance) {
    if (instance instanceof ImmutableNullableArray) {
      return (ImmutableNullableArray) instance;
    }
    return ImmutableNullableArray.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNullableArray ImmutableNullableArray}.
   * <pre>
   * ImmutableNullableArray.builder()
   *    .array(byte[] | null) // nullable {@link NullableArray#array() array}
   *    .build();
   * </pre>
   * @return A new ImmutableNullableArray builder
   */
  public static ImmutableNullableArray.Builder builder() {
    return new ImmutableNullableArray.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNullableArray ImmutableNullableArray}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NullableArray", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable byte[] array;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NullableArray} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NullableArray instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable byte[] arrayValue = instance.array();
      if (arrayValue != null) {
        array(arrayValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NullableArray#array() array} attribute.
     * @param array The elements for array
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder array(byte... array) {
      this.array = array;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNullableArray ImmutableNullableArray}.
     * @return An immutable instance of NullableArray
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNullableArray build() {
      return new ImmutableNullableArray(array);
    }
  }
}
