package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UnderwriteObjectMethods.NoUnderwrite}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNoUnderwrite.builder()}.
 */
@Generated(from = "UnderwriteObjectMethods.NoUnderwrite", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNoUnderwrite extends UnderwriteObjectMethods.NoUnderwrite {
  private final int value;

  private ImmutableNoUnderwrite(int value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public int value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UnderwriteObjectMethods.NoUnderwrite#value() value} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoUnderwrite withValue(int value) {
    if (this.value == value) return this;
    return new ImmutableNoUnderwrite(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNoUnderwrite} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNoUnderwrite
        && equalTo(0, (ImmutableNoUnderwrite) another);
  }

  private boolean equalTo(int synthetic, ImmutableNoUnderwrite another) {
    return value == another.value;
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value;
    return h;
  }

  /**
   * Prints the immutable value {@code NoUnderwrite} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NoUnderwrite")
        .omitNullValues()
        .add("value", value)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link UnderwriteObjectMethods.NoUnderwrite} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NoUnderwrite instance
   */
  public static ImmutableNoUnderwrite copyOf(UnderwriteObjectMethods.NoUnderwrite instance) {
    if (instance instanceof ImmutableNoUnderwrite) {
      return (ImmutableNoUnderwrite) instance;
    }
    return ImmutableNoUnderwrite.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNoUnderwrite ImmutableNoUnderwrite}.
   * <pre>
   * ImmutableNoUnderwrite.builder()
   *    .value(int) // required {@link UnderwriteObjectMethods.NoUnderwrite#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableNoUnderwrite builder
   */
  public static ImmutableNoUnderwrite.Builder builder() {
    return new ImmutableNoUnderwrite.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNoUnderwrite ImmutableNoUnderwrite}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UnderwriteObjectMethods.NoUnderwrite", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private int value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.UnderwriteObjectMethods.AbstractNoUnderwrite} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UnderwriteObjectMethods.AbstractNoUnderwrite instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.UnderwriteObjectMethods.NoUnderwrite} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UnderwriteObjectMethods.NoUnderwrite instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof UnderwriteObjectMethods.AbstractNoUnderwrite) {
        UnderwriteObjectMethods.AbstractNoUnderwrite instance = (UnderwriteObjectMethods.AbstractNoUnderwrite) object;
        value(instance.value());
      }
    }

    /**
     * Initializes the value for the {@link UnderwriteObjectMethods.NoUnderwrite#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(int value) {
      this.value = value;
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNoUnderwrite ImmutableNoUnderwrite}.
     * @return An immutable instance of NoUnderwrite
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNoUnderwrite build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNoUnderwrite(value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build NoUnderwrite, some of required attributes are not set " + attributes;
    }
  }
}
