package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import nonimmutables.GetterAnnotation;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GetterEncloser.Getters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGetters.builder()}.
 */
@Generated(from = "GetterEncloser.Getters", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGetters implements GetterEncloser.Getters {
  private final int ab;
  private final String cd;
  private final boolean ef;

  private ImmutableGetters(int ab, String cd, boolean ef) {
    this.ab = ab;
    this.cd = cd;
    this.ef = ef;
  }

  /**
   * @return The value of the {@code ab} attribute
   */
  @Override
  public int ab() {
    return ab;
  }

  /**
   * @return The value of the {@code cd} attribute
   */
  @POST
  @Path("/cd")
  @Override
  public String cd() {
    return cd;
  }

  /**
   * @return The value of the {@code ef} attribute
   */
  @GetterAnnotation(policy = RetentionPolicy.CLASS, string = "\n\"", type = java.lang.Object.class, value = {@nonimmutables.GetterAnnotation.InnerAnnotation, @nonimmutables.GetterAnnotation.InnerAnnotation}, bval = java.lang.Byte.MIN_VALUE, dval = java.lang.Double.POSITIVE_INFINITY, ival = java.lang.Integer.MAX_VALUE, fval = java.lang.Float.NaN, blval = true, cval = 'j')
  @javax.ws.rs.Path("/ef")
  @Override
  public boolean ef() {
    return ef;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GetterEncloser.Getters#ab() ab} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ab
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGetters withAb(int value) {
    if (this.ab == value) return this;
    return new ImmutableGetters(value, this.cd, this.ef);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GetterEncloser.Getters#cd() cd} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cd
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGetters withCd(String value) {
    String newValue = Objects.requireNonNull(value, "cd");
    if (this.cd.equals(newValue)) return this;
    return new ImmutableGetters(this.ab, newValue, this.ef);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GetterEncloser.Getters#ef() ef} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ef
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGetters withEf(boolean value) {
    if (this.ef == value) return this;
    return new ImmutableGetters(this.ab, this.cd, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGetters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGetters
        && equalTo(0, (ImmutableGetters) another);
  }

  private boolean equalTo(int synthetic, ImmutableGetters another) {
    return ab == another.ab
        && cd.equals(another.cd);
  }

  /**
   * Computes a hash code from attributes: {@code ab}, {@code cd}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + ab;
    h += (h << 5) + cd.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Getters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Getters")
        .omitNullValues()
        .add("ab", ab)
        .add("cd", cd)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GetterEncloser.Getters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Getters instance
   */
  public static ImmutableGetters copyOf(GetterEncloser.Getters instance) {
    if (instance instanceof ImmutableGetters) {
      return (ImmutableGetters) instance;
    }
    return ImmutableGetters.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGetters ImmutableGetters}.
   * <pre>
   * ImmutableGetters.builder()
   *    .ab(int) // required {@link GetterEncloser.Getters#ab() ab}
   *    .cd(String) // required {@link GetterEncloser.Getters#cd() cd}
   *    .ef(boolean) // required {@link GetterEncloser.Getters#ef() ef}
   *    .build();
   * </pre>
   * @return A new ImmutableGetters builder
   */
  public static ImmutableGetters.Builder builder() {
    return new ImmutableGetters.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGetters ImmutableGetters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GetterEncloser.Getters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_AB = 0x1L;
    private static final long INIT_BIT_CD = 0x2L;
    private static final long INIT_BIT_EF = 0x4L;
    private long initBits = 0x7L;

    private int ab;
    private @Nullable String cd;
    private boolean ef;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Getters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GetterEncloser.Getters instance) {
      Objects.requireNonNull(instance, "instance");
      ab(instance.ab());
      cd(instance.cd());
      ef(instance.ef());
      return this;
    }

    /**
     * Initializes the value for the {@link GetterEncloser.Getters#ab() ab} attribute.
     * @param ab The value for ab 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ab(int ab) {
      this.ab = ab;
      initBits &= ~INIT_BIT_AB;
      return this;
    }

    /**
     * Initializes the value for the {@link GetterEncloser.Getters#cd() cd} attribute.
     * @param cd The value for cd 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder cd(String cd) {
      this.cd = Objects.requireNonNull(cd, "cd");
      initBits &= ~INIT_BIT_CD;
      return this;
    }

    /**
     * Initializes the value for the {@link GetterEncloser.Getters#ef() ef} attribute.
     * @param ef The value for ef 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ef(boolean ef) {
      this.ef = ef;
      initBits &= ~INIT_BIT_EF;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGetters ImmutableGetters}.
     * @return An immutable instance of Getters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGetters build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGetters(ab, cd, ef);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AB) != 0) attributes.add("ab");
      if ((initBits & INIT_BIT_CD) != 0) attributes.add("cd");
      if ((initBits & INIT_BIT_EF) != 0) attributes.add("ef");
      return "Cannot build Getters, some of required attributes are not set " + attributes;
    }
  }
}
