package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ForceExtendingBuilder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ForceExtendingBuilder.Builder()}.
 */
@Generated(from = "ForceExtendingBuilder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableForceExtendingBuilder implements ForceExtendingBuilder {

  private ImmutableForceExtendingBuilder(ImmutableForceExtendingBuilder.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableForceExtendingBuilder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableForceExtendingBuilder
        && equalTo(0, (ImmutableForceExtendingBuilder) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableForceExtendingBuilder another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 1126449317;
  }

  /**
   * Prints the immutable value {@code ForceExtendingBuilder}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ForceExtendingBuilder{}";
  }

  /**
   * Creates an immutable copy of a {@link ForceExtendingBuilder} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ForceExtendingBuilder instance
   */
  public static ImmutableForceExtendingBuilder copyOf(ForceExtendingBuilder instance) {
    if (instance instanceof ImmutableForceExtendingBuilder) {
      return (ImmutableForceExtendingBuilder) instance;
    }
    return new ForceExtendingBuilder.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableForceExtendingBuilder ImmutableForceExtendingBuilder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ForceExtendingBuilder", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {

    /**
     * Creates a builder for {@link ImmutableForceExtendingBuilder ImmutableForceExtendingBuilder} instances.
     * <pre>
     * new ForceExtendingBuilder.Builder()
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ForceExtendingBuilder.Builder)) {
        throw new UnsupportedOperationException("Use: new ForceExtendingBuilder.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ForceExtendingBuilder} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ForceExtendingBuilder.Builder from(ForceExtendingBuilder instance) {
      Objects.requireNonNull(instance, "instance");
      return (ForceExtendingBuilder.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableForceExtendingBuilder ImmutableForceExtendingBuilder}.
     * @return An immutable instance of ForceExtendingBuilder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableForceExtendingBuilder build() {
      return new ImmutableForceExtendingBuilder(this);
    }
  }
}
