package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExtendingInnerCreatorValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ExtendingInnerCreatorValue.Creator()}.
 */
@Generated(from = "ExtendingInnerCreatorValue", generator = "Immutables")
@SuppressWarnings({"all", "deprecation", "removal"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableExtendingInnerCreatorValue
    implements ExtendingInnerCreatorValue {

  private ImmutableExtendingInnerCreatorValue(ImmutableExtendingInnerCreatorValue.Creator builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExtendingInnerCreatorValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExtendingInnerCreatorValue
        && equalTo(0, (ImmutableExtendingInnerCreatorValue) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableExtendingInnerCreatorValue another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1468291574;
  }

  /**
   * Prints the immutable value {@code ExtendingInnerCreatorValue}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExtendingInnerCreatorValue{}";
  }

  /**
   * Creates an immutable copy of a {@link ExtendingInnerCreatorValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExtendingInnerCreatorValue instance
   */
  public static ExtendingInnerCreatorValue copyOf(ExtendingInnerCreatorValue instance) {
    if (instance instanceof ImmutableExtendingInnerCreatorValue) {
      return (ImmutableExtendingInnerCreatorValue) instance;
    }
    return new ExtendingInnerCreatorValue.Creator()
        .from(instance)
        .create();
  }

  /**
   * Builds instances of type {@link ExtendingInnerCreatorValue ExtendingInnerCreatorValue}.
   * Initialize attributes and then invoke the {@link #create()} method to create an
   * immutable instance.
   * <p><em>{@code Creator} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExtendingInnerCreatorValue", generator = "Immutables")
  @NotThreadSafe
  public static class Creator {

    /**
     * Creates a builder for {@link ExtendingInnerCreatorValue ExtendingInnerCreatorValue} instances.
     * <pre>
     * new ExtendingInnerCreatorValue.Creator()
     *    .create();
     * </pre>
     */
    public Creator() {
      if (!(this instanceof ExtendingInnerCreatorValue.Creator)) {
        throw new UnsupportedOperationException("Use: new ExtendingInnerCreatorValue.Creator()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExtendingInnerCreatorValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final ExtendingInnerCreatorValue.Creator from(ExtendingInnerCreatorValue instance) {
      Objects.requireNonNull(instance, "instance");
      return (ExtendingInnerCreatorValue.Creator) this;
    }

    /**
     * Builds a new {@link ExtendingInnerCreatorValue ExtendingInnerCreatorValue}.
     * @return An immutable instance of ExtendingInnerCreatorValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ExtendingInnerCreatorValue create() {
      return new ImmutableExtendingInnerCreatorValue(this);
    }
  }
}
