package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExtendedBuilderInterface}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExtendedBuilderInterface.builder()}.
 */
@Generated(from = "ExtendedBuilderInterface", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableExtendedBuilderInterface
    implements ExtendedBuilderInterface {
  private final int a;
  private final int b;

  private ImmutableExtendedBuilderInterface(int a, int b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public int b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtendedBuilderInterface#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExtendedBuilderInterface withA(int value) {
    if (this.a == value) return this;
    return new ImmutableExtendedBuilderInterface(value, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtendedBuilderInterface#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExtendedBuilderInterface withB(int value) {
    if (this.b == value) return this;
    return new ImmutableExtendedBuilderInterface(this.a, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExtendedBuilderInterface} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExtendedBuilderInterface
        && equalTo(0, (ImmutableExtendedBuilderInterface) another);
  }

  private boolean equalTo(int synthetic, ImmutableExtendedBuilderInterface another) {
    return a == another.a
        && b == another.b;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b;
    return h;
  }

  /**
   * Prints the immutable value {@code ExtendedBuilderInterface} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExtendedBuilderInterface")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ExtendedBuilderInterface} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExtendedBuilderInterface instance
   */
  public static ImmutableExtendedBuilderInterface copyOf(ExtendedBuilderInterface instance) {
    if (instance instanceof ImmutableExtendedBuilderInterface) {
      return (ImmutableExtendedBuilderInterface) instance;
    }
    return ImmutableExtendedBuilderInterface.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExtendedBuilderInterface ImmutableExtendedBuilderInterface}.
   * <pre>
   * ImmutableExtendedBuilderInterface.builder()
   *    .a(int) // required {@link ExtendedBuilderInterface#a() a}
   *    .b(int) // required {@link ExtendedBuilderInterface#b() b}
   *    .build();
   * </pre>
   * @return A new ImmutableExtendedBuilderInterface builder
   */
  public static ImmutableExtendedBuilderInterface.Builder builder() {
    return new ImmutableExtendedBuilderInterface.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExtendedBuilderInterface ImmutableExtendedBuilderInterface}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExtendedBuilderInterface", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder implements ExtendedBuilderInterface.Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private int a;
    private int b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExtendedBuilderInterface} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ExtendedBuilderInterface instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      return this;
    }

    /**
     * Initializes the value for the {@link ExtendedBuilderInterface#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link ExtendedBuilderInterface#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(int b) {
      this.b = b;
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExtendedBuilderInterface ImmutableExtendedBuilderInterface}.
     * @return An immutable instance of ExtendedBuilderInterface
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExtendedBuilderInterface build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExtendedBuilderInterface(a, b);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build ExtendedBuilderInterface, some of required attributes are not set " + attributes;
    }
  }
}
