package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeprecateType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeprecateType.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableDeprecateType.of()}.
 */
@Generated(from = "DeprecateType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Deprecated
@Immutable
@CheckReturnValue
final class ImmutableDeprecateType implements DeprecateType {

  private ImmutableDeprecateType() {}

  /**
   * This instance is equal to all instances of {@code ImmutableDeprecateType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeprecateType
        && equalTo(0, (ImmutableDeprecateType) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableDeprecateType another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 1078346578;
  }

  /**
   * Prints the immutable value {@code DeprecateType}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeprecateType{}";
  }

  private static final ImmutableDeprecateType INSTANCE = validate(new ImmutableDeprecateType());

  /**
   * Returns the default immutable singleton value of {@code DeprecateType}
   * @return An immutable instance of DeprecateType
   */
  public static ImmutableDeprecateType of() {
    return INSTANCE;
  }

  private static ImmutableDeprecateType validate(ImmutableDeprecateType instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link DeprecateType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeprecateType instance
   */
  public static ImmutableDeprecateType copyOf(DeprecateType instance) {
    if (instance instanceof ImmutableDeprecateType) {
      return (ImmutableDeprecateType) instance;
    }
    return ImmutableDeprecateType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeprecateType ImmutableDeprecateType}.
   * <pre>
   * ImmutableDeprecateType.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableDeprecateType builder
   */
  public static ImmutableDeprecateType.Builder builder() {
    return new ImmutableDeprecateType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeprecateType ImmutableDeprecateType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeprecateType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeprecateType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeprecateType instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeprecateType ImmutableDeprecateType}.
     * @return An immutable instance of DeprecateType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeprecateType build() {
      return ImmutableDeprecateType.of();
    }
  }
}
