package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableConstructorParameterInheritanceLevels} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link ConstructorParameterInheritanceLevels}.
 * @see ImmutableConstructorParameterInheritanceLevels.B
 * @see ImmutableConstructorParameterInheritanceLevels.D
 */
@Generated(from = "ConstructorParameterInheritanceLevels", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableConstructorParameterInheritanceLevels {
  private ImmutableConstructorParameterInheritanceLevels() {}

  /**
   * Immutable implementation of {@link ConstructorParameterInheritanceLevels.B}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableConstructorParameterInheritanceLevels.B.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableConstructorParameterInheritanceLevels.B.of()}.
   */
  @Generated(from = "ConstructorParameterInheritanceLevels.B", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class B implements ConstructorParameterInheritanceLevels.B {
    private final int b;
    private final int a;

    private B(int b, int a) {
      this.b = b;
      this.a = a;
    }

    /**
     * @return The value of the {@code b} attribute
     */
    @Override
    public int b() {
      return b;
    }

    /**
     * @return The value of the {@code a} attribute
     */
    @Override
    public int a() {
      return a;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ConstructorParameterInheritanceLevels.B#b() b} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for b
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstructorParameterInheritanceLevels.B withB(int value) {
      if (this.b == value) return this;
      return new ImmutableConstructorParameterInheritanceLevels.B(value, this.a);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ConstructorParameterInheritanceLevels.B#a() a} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for a
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstructorParameterInheritanceLevels.B withA(int value) {
      if (this.a == value) return this;
      return new ImmutableConstructorParameterInheritanceLevels.B(this.b, value);
    }

    /**
     * This instance is equal to all instances of {@code B} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableConstructorParameterInheritanceLevels.B
          && equalTo(0, (ImmutableConstructorParameterInheritanceLevels.B) another);
    }

    private boolean equalTo(int synthetic, ImmutableConstructorParameterInheritanceLevels.B another) {
      return b == another.b
          && a == another.a;
    }

    /**
     * Computes a hash code from attributes: {@code b}, {@code a}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + b;
      h += (h << 5) + a;
      return h;
    }

    /**
     * Prints the immutable value {@code B} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("B")
          .omitNullValues()
          .add("b", b)
          .add("a", a)
          .toString();
    }

    /**
     * Construct a new immutable {@code B} instance.
     * @param b The value for the {@code b} attribute
     * @param a The value for the {@code a} attribute
     * @return An immutable B instance
     */
    public static ImmutableConstructorParameterInheritanceLevels.B of(int b, int a) {
      return new ImmutableConstructorParameterInheritanceLevels.B(b, a);
    }

    /**
     * Creates an immutable copy of a {@link ConstructorParameterInheritanceLevels.B} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable B instance
     */
    public static ImmutableConstructorParameterInheritanceLevels.B copyOf(ConstructorParameterInheritanceLevels.B instance) {
      if (instance instanceof ImmutableConstructorParameterInheritanceLevels.B) {
        return (ImmutableConstructorParameterInheritanceLevels.B) instance;
      }
      return ImmutableConstructorParameterInheritanceLevels.B.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableConstructorParameterInheritanceLevels.B B}.
     * <pre>
     * ImmutableConstructorParameterInheritanceLevels.B.builder()
     *    .b(int) // required {@link ConstructorParameterInheritanceLevels.B#b() b}
     *    .a(int) // required {@link ConstructorParameterInheritanceLevels.B#a() a}
     *    .build();
     * </pre>
     * @return A new B builder
     */
    public static ImmutableConstructorParameterInheritanceLevels.B.Builder builder() {
      return new ImmutableConstructorParameterInheritanceLevels.B.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableConstructorParameterInheritanceLevels.B B}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "ConstructorParameterInheritanceLevels.B", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_B = 0x1L;
      private static final long INIT_BIT_A = 0x2L;
      private long initBits = 0x3L;

      private int b;
      private int a;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.ConstructorParameterInheritanceLevels.A} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ConstructorParameterInheritanceLevels.A instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.fixture.ConstructorParameterInheritanceLevels.B} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ConstructorParameterInheritanceLevels.B instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        @Var long bits = 0;
        if (object instanceof ConstructorParameterInheritanceLevels.A) {
          ConstructorParameterInheritanceLevels.A instance = (ConstructorParameterInheritanceLevels.A) object;
          if ((bits & 0x1L) == 0) {
            a(instance.a());
            bits |= 0x1L;
          }
        }
        if (object instanceof ConstructorParameterInheritanceLevels.B) {
          ConstructorParameterInheritanceLevels.B instance = (ConstructorParameterInheritanceLevels.B) object;
          if ((bits & 0x1L) == 0) {
            a(instance.a());
            bits |= 0x1L;
          }
          b(instance.b());
        }
      }

      /**
       * Initializes the value for the {@link ConstructorParameterInheritanceLevels.B#b() b} attribute.
       * @param b The value for b 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder b(int b) {
        this.b = b;
        initBits &= ~INIT_BIT_B;
        return this;
      }

      /**
       * Initializes the value for the {@link ConstructorParameterInheritanceLevels.B#a() a} attribute.
       * @param a The value for a 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder a(int a) {
        this.a = a;
        initBits &= ~INIT_BIT_A;
        return this;
      }

      /**
       * Builds a new {@link ImmutableConstructorParameterInheritanceLevels.B B}.
       * @return An immutable instance of B
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableConstructorParameterInheritanceLevels.B build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableConstructorParameterInheritanceLevels.B(b, a);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
        if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
        return "Cannot build B, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link ConstructorParameterInheritanceLevels.D}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableConstructorParameterInheritanceLevels.D.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableConstructorParameterInheritanceLevels.D.of()}.
   */
  @Generated(from = "ConstructorParameterInheritanceLevels.D", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class D implements ConstructorParameterInheritanceLevels.D {
    private final ConstructorParameterInheritanceLevels.A a;
    private final ConstructorParameterInheritanceLevels.B b;

    private D(
        ConstructorParameterInheritanceLevels.A a,
        ConstructorParameterInheritanceLevels.B b) {
      this.a = Objects.requireNonNull(a, "a");
      this.b = Objects.requireNonNull(b, "b");
    }

    private D(
        ImmutableConstructorParameterInheritanceLevels.D original,
        ConstructorParameterInheritanceLevels.A a,
        ConstructorParameterInheritanceLevels.B b) {
      this.a = a;
      this.b = b;
    }

    /**
     * @return The value of the {@code a} attribute
     */
    @Override
    public ConstructorParameterInheritanceLevels.A a() {
      return a;
    }

    /**
     * @return The value of the {@code b} attribute
     */
    @Override
    public ConstructorParameterInheritanceLevels.B b() {
      return b;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ConstructorParameterInheritanceLevels.D#a() a} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for a
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstructorParameterInheritanceLevels.D withA(ConstructorParameterInheritanceLevels.A value) {
      if (this.a == value) return this;
      ConstructorParameterInheritanceLevels.A newValue = Objects.requireNonNull(value, "a");
      return new ImmutableConstructorParameterInheritanceLevels.D(this, newValue, this.b);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ConstructorParameterInheritanceLevels.D#b() b} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for b
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstructorParameterInheritanceLevels.D withB(ConstructorParameterInheritanceLevels.B value) {
      if (this.b == value) return this;
      ConstructorParameterInheritanceLevels.B newValue = Objects.requireNonNull(value, "b");
      return new ImmutableConstructorParameterInheritanceLevels.D(this, this.a, newValue);
    }

    /**
     * This instance is equal to all instances of {@code D} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableConstructorParameterInheritanceLevels.D
          && equalTo(0, (ImmutableConstructorParameterInheritanceLevels.D) another);
    }

    private boolean equalTo(int synthetic, ImmutableConstructorParameterInheritanceLevels.D another) {
      return a.equals(another.a)
          && b.equals(another.b);
    }

    /**
     * Computes a hash code from attributes: {@code a}, {@code b}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + a.hashCode();
      h += (h << 5) + b.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code D} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("D")
          .omitNullValues()
          .add("a", a)
          .add("b", b)
          .toString();
    }

    /**
     * Construct a new immutable {@code D} instance.
     * @param a The value for the {@code a} attribute
     * @param b The value for the {@code b} attribute
     * @return An immutable D instance
     */
    public static ImmutableConstructorParameterInheritanceLevels.D of(ConstructorParameterInheritanceLevels.A a, ConstructorParameterInheritanceLevels.B b) {
      return new ImmutableConstructorParameterInheritanceLevels.D(a, b);
    }

    /**
     * Creates an immutable copy of a {@link ConstructorParameterInheritanceLevels.D} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable D instance
     */
    public static ImmutableConstructorParameterInheritanceLevels.D copyOf(ConstructorParameterInheritanceLevels.D instance) {
      if (instance instanceof ImmutableConstructorParameterInheritanceLevels.D) {
        return (ImmutableConstructorParameterInheritanceLevels.D) instance;
      }
      return ImmutableConstructorParameterInheritanceLevels.D.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableConstructorParameterInheritanceLevels.D D}.
     * <pre>
     * ImmutableConstructorParameterInheritanceLevels.D.builder()
     *    .a(org.immutables.fixture.ConstructorParameterInheritanceLevels.A) // required {@link ConstructorParameterInheritanceLevels.D#a() a}
     *    .b(org.immutables.fixture.ConstructorParameterInheritanceLevels.B) // required {@link ConstructorParameterInheritanceLevels.D#b() b}
     *    .build();
     * </pre>
     * @return A new D builder
     */
    public static ImmutableConstructorParameterInheritanceLevels.D.Builder builder() {
      return new ImmutableConstructorParameterInheritanceLevels.D.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableConstructorParameterInheritanceLevels.D D}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "ConstructorParameterInheritanceLevels.D", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_A = 0x1L;
      private static final long INIT_BIT_B = 0x2L;
      private long initBits = 0x3L;

      private @Nullable ConstructorParameterInheritanceLevels.A a;
      private @Nullable ConstructorParameterInheritanceLevels.B b;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code D} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ConstructorParameterInheritanceLevels.D instance) {
        Objects.requireNonNull(instance, "instance");
        a(instance.a());
        b(instance.b());
        return this;
      }

      /**
       * Initializes the value for the {@link ConstructorParameterInheritanceLevels.D#a() a} attribute.
       * @param a The value for a 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder a(ConstructorParameterInheritanceLevels.A a) {
        this.a = Objects.requireNonNull(a, "a");
        initBits &= ~INIT_BIT_A;
        return this;
      }

      /**
       * Initializes the value for the {@link ConstructorParameterInheritanceLevels.D#b() b} attribute.
       * @param b The value for b 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder b(ConstructorParameterInheritanceLevels.B b) {
        this.b = Objects.requireNonNull(b, "b");
        initBits &= ~INIT_BIT_B;
        return this;
      }

      /**
       * Builds a new {@link ImmutableConstructorParameterInheritanceLevels.D D}.
       * @return An immutable instance of D
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableConstructorParameterInheritanceLevels.D build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableConstructorParameterInheritanceLevels.D(null, a, b);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
        if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
        return "Cannot build D, some of required attributes are not set " + attributes;
      }
    }
  }
}
