package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AlternativeConstructor}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAlternativeConstructor.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAlternativeConstructor.of()}.
 */
@Generated(from = "AlternativeConstructor", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAlternativeConstructor extends AlternativeConstructor {
  private final ImmutableList<String> foo;

  private ImmutableAlternativeConstructor(Iterable<String> foo) {
    this.foo = ImmutableList.copyOf(foo);
  }

  private ImmutableAlternativeConstructor(
      ImmutableAlternativeConstructor original,
      ImmutableList<String> foo) {
    this.foo = foo;
  }

  /**
   * @return The value of the {@code foo} attribute
   */
  @Override
  public ImmutableList<String> foo() {
    return foo;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AlternativeConstructor#foo() foo}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAlternativeConstructor withFoo(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAlternativeConstructor(this, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AlternativeConstructor#foo() foo}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of foo elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAlternativeConstructor withFoo(Iterable<String> elements) {
    if (this.foo == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAlternativeConstructor(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAlternativeConstructor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAlternativeConstructor
        && equalTo(0, (ImmutableAlternativeConstructor) another);
  }

  private boolean equalTo(int synthetic, ImmutableAlternativeConstructor another) {
    return foo.equals(another.foo);
  }

  /**
   * Computes a hash code from attributes: {@code foo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + foo.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AlternativeConstructor} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AlternativeConstructor")
        .omitNullValues()
        .add("foo", foo)
        .toString();
  }

  /**
   * Construct a new immutable {@code AlternativeConstructor} instance.
   * @param foo The value for the {@code foo} attribute
   * @return An immutable AlternativeConstructor instance
   */
  public static ImmutableAlternativeConstructor of(List<String> foo) {
    return of((Iterable<String>) foo);
  }

  /**
   * Construct a new immutable {@code AlternativeConstructor} instance.
   * @param foo The value for the {@code foo} attribute
   * @return An immutable AlternativeConstructor instance
   */
  public static ImmutableAlternativeConstructor of(Iterable<String> foo) {
    return new ImmutableAlternativeConstructor(foo);
  }

  /**
   * Creates an immutable copy of a {@link AlternativeConstructor} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AlternativeConstructor instance
   */
  public static ImmutableAlternativeConstructor copyOf(AlternativeConstructor instance) {
    if (instance instanceof ImmutableAlternativeConstructor) {
      return (ImmutableAlternativeConstructor) instance;
    }
    return ImmutableAlternativeConstructor.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAlternativeConstructor ImmutableAlternativeConstructor}.
   * <pre>
   * ImmutableAlternativeConstructor.builder()
   *    .addFoo|addAllFoo(String) // {@link AlternativeConstructor#foo() foo} elements
   *    .build();
   * </pre>
   * @return A new ImmutableAlternativeConstructor builder
   */
  public static ImmutableAlternativeConstructor.Builder builder() {
    return new ImmutableAlternativeConstructor.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAlternativeConstructor ImmutableAlternativeConstructor}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AlternativeConstructor", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<String> foo = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AlternativeConstructor} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AlternativeConstructor instance) {
      Objects.requireNonNull(instance, "instance");
      addAllFoo(instance.foo());
      return this;
    }

    /**
     * Adds one element to {@link AlternativeConstructor#foo() foo} list.
     * @param element A foo element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFoo(String element) {
      this.foo.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AlternativeConstructor#foo() foo} list.
     * @param elements An array of foo elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFoo(String... elements) {
      this.foo.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AlternativeConstructor#foo() foo} list.
     * @param elements An iterable of foo elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder foo(Iterable<String> elements) {
      this.foo = ImmutableList.builder();
      return addAllFoo(elements);
    }

    /**
     * Adds elements to {@link AlternativeConstructor#foo() foo} list.
     * @param elements An iterable of foo elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFoo(Iterable<String> elements) {
      this.foo.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableAlternativeConstructor ImmutableAlternativeConstructor}.
     * @return An immutable instance of AlternativeConstructor
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAlternativeConstructor build() {
      return new ImmutableAlternativeConstructor(null, foo.build());
    }
  }
}
